/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.util;

import com.eerussianguy.firmalife.common.FLTags;
import com.eerussianguy.firmalife.common.blockentities.ClimateStationBlockEntity;
import com.eerussianguy.firmalife.common.blockentities.LargePlanterBlockEntity;
import com.eerussianguy.firmalife.common.blocks.FLBlocks;
import com.eerussianguy.firmalife.common.util.GreenhouseType;
import com.eerussianguy.firmalife.common.util.Plantable;
import com.eerussianguy.firmalife.config.FLConfig;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendar;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.TriPredicate;

public final class Mechanics {
    public static final Predicate<BlockState> CELLAR = state -> Helpers.isBlock((BlockState)state, FLTags.Blocks.CELLAR_INSULATION);
    private static final int UPDATE_INTERVAL = 24000;
    public static final Supplier<Float> GROWTH_FACTOR = () -> Float.valueOf(1.0f / (((Double)FLConfig.SERVER.greenhouseGrowthDays.get()).floatValue() * 24000.0f));
    public static final Supplier<Float> NUTRIENT_CONSUMPTION = () -> Float.valueOf(1.0f / (((Double)FLConfig.SERVER.greenhouseNutrientDays.get()).floatValue() * 24000.0f));
    public static final Supplier<Float> WATER_CONSUMPTION = () -> Float.valueOf(1.0f / (((Double)FLConfig.SERVER.greenhouseWaterDays.get()).floatValue() * 24000.0f));
    public static final float NUTRIENT_GROWTH_FACTOR = 0.5f;

    public static Set<BlockPos> floodfill(Level level, BlockPos startPos, BlockPos.MutableBlockPos mutable, BoundingBox bounds, TriPredicate<BlockState, BlockPos, Direction> wallPredicate, Predicate<BlockState> interiorPredicate, boolean testOrigin, int lastSize, Direction[] checkDirections) {
        if (testOrigin && !wallPredicate.test((Object)level.m_8055_(startPos), (Object)startPos, (Object)Direction.UP)) {
            return Collections.emptySet();
        }
        int maxSize = bounds.m_71056_() * bounds.m_71057_() * bounds.m_71058_();
        HashSet<BlockPos> filled = lastSize == -1 ? new HashSet<BlockPos>() : new HashSet(lastSize);
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        filled.add(startPos);
        queue.addFirst(startPos);
        while (!queue.isEmpty()) {
            if (filled.size() > maxSize) {
                return Collections.emptySet();
            }
            BlockPos testPos = (BlockPos)queue.removeFirst();
            for (Direction direction : checkDirections) {
                BlockState stateAt;
                mutable.m_122190_((Vec3i)testPos).m_122173_(direction);
                if (filled.contains(mutable) || wallPredicate.test((Object)(stateAt = level.m_8055_((BlockPos)mutable)), (Object)mutable, (Object)direction)) continue;
                if (interiorPredicate.test(stateAt)) {
                    if (!bounds.m_71051_((Vec3i)mutable)) {
                        return Collections.emptySet();
                    }
                    BlockPos posNext = mutable.m_7949_();
                    queue.addFirst(posNext);
                    filled.add(posNext);
                    continue;
                }
                return Collections.emptySet();
            }
        }
        return filled;
    }

    @Nullable
    public static Set<BlockPos> getCellar(Level level, BlockPos pos, BlockState state) {
        return Mechanics.getCellar(level, pos, state, -1);
    }

    @Nullable
    public static Set<BlockPos> getCellar(Level level, BlockPos pos, BlockState state, int lastSize) {
        ClimateStationBlockEntity station;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (Direction d : Helpers.DIRECTIONS) {
            mutable.m_122159_((Vec3i)pos, d);
            if (!CELLAR.test(level.m_8055_((BlockPos)mutable))) continue;
            return Mechanics.tryFindCellarInfo(level, pos, lastSize, mutable);
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ClimateStationBlockEntity && (station = (ClimateStationBlockEntity)blockEntity).favoriteIsCellar()) {
            return Mechanics.tryFindCellarInfo(level, pos, lastSize, mutable);
        }
        return null;
    }

    @Nullable
    private static Set<BlockPos> tryFindCellarInfo(Level level, BlockPos pos, int lastSize, BlockPos.MutableBlockPos mutable) {
        BoundingBox box = new BoundingBox(pos).m_191961_(15);
        Set<BlockPos> filled = Mechanics.floodfill(level, pos, mutable, box, (TriPredicate<BlockState, BlockPos, Direction>)((TriPredicate)(s, p, dir) -> CELLAR.test((BlockState)s)), s -> !Helpers.isBlock((BlockState)s, (Block)((Block)FLBlocks.CLIMATE_STATION.get())), false, lastSize, Helpers.DIRECTIONS);
        return filled.isEmpty() ? null : filled;
    }

    @Nullable
    public static GreenhouseInfo getGreenhouse(Level level, BlockPos pos, BlockState state) {
        return Mechanics.getGreenhouse(level, pos, state, -1);
    }

    @Nullable
    public static GreenhouseInfo getGreenhouse(Level level, BlockPos pos, BlockState state, int lastSize) {
        ClimateStationBlockEntity station;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (Direction d : Helpers.DIRECTIONS) {
            mutable.m_122159_((Vec3i)pos, d);
            GreenhouseType greenhouse = GreenhouseType.get(level.m_8055_((BlockPos)mutable));
            if (greenhouse == null) continue;
            return Mechanics.tryFindGreenhouseInfo(level, pos, lastSize, mutable, greenhouse);
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ClimateStationBlockEntity && (station = (ClimateStationBlockEntity)blockEntity).getFavoriteType() != null) {
            return Mechanics.tryFindGreenhouseInfo(level, pos, lastSize, mutable, station.getFavoriteType());
        }
        return null;
    }

    @Nullable
    private static GreenhouseInfo tryFindGreenhouseInfo(Level level, BlockPos pos, int lastSize, BlockPos.MutableBlockPos mutable, GreenhouseType greenhouse) {
        TriPredicate predicate;
        BoundingBox box = new BoundingBox(pos).m_191961_(15);
        Set<BlockPos> filled = Mechanics.floodfill(level, pos, mutable, box, (TriPredicate<BlockState, BlockPos, Direction>)(predicate = (wallState, wallPos, direction) -> {
            if (Helpers.isBlock((BlockState)wallState, FLTags.Blocks.ALWAYS_VALID_GREENHOUSE_WALL)) {
                return true;
            }
            if (direction == Direction.DOWN) {
                return !wallState.m_60795_();
            }
            if (!greenhouse.ingredient.test(wallState)) {
                return false;
            }
            if (direction == Direction.UP && wallState.m_60734_() instanceof SlabBlock) {
                return true;
            }
            return wallState.m_60783_((BlockGetter)level, wallPos, direction.m_122424_());
        }), s -> !Helpers.isBlock((BlockState)s, (Block)((Block)FLBlocks.CLIMATE_STATION.get())), false, lastSize, Helpers.DIRECTIONS);
        if (filled.isEmpty()) {
            return null;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ClimateStationBlockEntity) {
            ClimateStationBlockEntity station = (ClimateStationBlockEntity)blockEntity;
            station.setFavorite(greenhouse);
        }
        return new GreenhouseInfo(greenhouse, filled);
    }

    public static boolean growthTick(Level level, BlockPos pos, BlockState state, LargePlanterBlockEntity planter) {
        long firstTick = planter.getLastGrowthTick();
        long thisTick = Calendars.SERVER.getTicks();
        long lastTick = firstTick;
        for (long tick = firstTick + 24000L; tick < thisTick; tick += 24000L) {
            if (!Mechanics.growthTickStep(level, level.m_213780_(), lastTick, tick, planter)) {
                return false;
            }
            lastTick = tick;
        }
        return lastTick >= thisTick || Mechanics.growthTickStep(level, level.m_213780_(), lastTick, thisTick, planter);
    }

    public static boolean growthTickStep(Level level, RandomSource random, long fromTick, long toTick, LargePlanterBlockEntity planter) {
        ICalendar calendar = Calendars.get((LevelReader)level);
        long tickDelta = toTick - fromTick;
        boolean growing = planter.checkValid();
        for (int slot = 0; slot < planter.slots(); ++slot) {
            Plantable plant = planter.getPlantable(slot);
            if (plant != null) {
                float nutrientsConsumed = planter.consumeNutrientAndResupplyOthers(plant.getPrimaryNutrient(), NUTRIENT_CONSUMPTION.get().floatValue() * (float)tickDelta);
                float totalGrowthDelta = Helpers.uniform((RandomSource)random, (float)0.9f, (float)1.1f) * (float)tickDelta * GROWTH_FACTOR.get().floatValue() + nutrientsConsumed * 0.5f;
                float growth = planter.getGrowth(slot);
                if (totalGrowthDelta > 0.0f && growing) {
                    float delta = Mth.m_14036_((float)totalGrowthDelta, (float)0.0f, (float)1.0f);
                    growth += delta;
                    planter.drainWater((float)tickDelta * WATER_CONSUMPTION.get().floatValue());
                }
                planter.setGrowth(slot, Mth.m_14036_((float)growth, (float)0.0f, (float)1.0f));
                continue;
            }
            planter.setGrowth(slot, 0.0f);
        }
        planter.setLastGrowthTick(calendar.getTicks());
        planter.afterGrowthTickStep(growing);
        return true;
    }

    public record GreenhouseInfo(GreenhouseType type, Set<BlockPos> positions) {
    }
}

