/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.util;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blocks.FLBlocks;
import java.util.Locale;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCArmorMaterials;
import net.dries007.tfc.common.TFCTiers;
import net.dries007.tfc.util.Metal;
import net.dries007.tfc.util.registry.RegistryMetal;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.common.util.NonNullFunction;

public enum FLMetal implements RegistryMetal
{
    CHROMIUM(-655617, MapColor.f_283779_),
    STAINLESS_STEEL(-2491137, MapColor.f_283779_);

    private final String serializedName = this.name().toLowerCase(Locale.ROOT);
    private final int color;
    private final MapColor mapColor;
    private final ResourceLocation sheet;

    private FLMetal(int color, MapColor mapColor) {
        this.color = color;
        this.mapColor = mapColor;
        this.sheet = FLHelpers.identifier("block/metal/full/" + this.serializedName);
    }

    public ResourceLocation getSheet() {
        return this.sheet;
    }

    public String m_7912_() {
        return this.serializedName;
    }

    public int getColor() {
        return this.color;
    }

    public Rarity getRarity() {
        return Rarity.EPIC;
    }

    public Tier toolTier() {
        return TFCTiers.STEEL;
    }

    public ArmorMaterial armorTier() {
        return TFCArmorMaterials.RED_STEEL;
    }

    public Metal.Tier metalTier() {
        return Metal.Tier.TIER_VI;
    }

    public MapColor mapColor() {
        return this.mapColor;
    }

    public Supplier<Block> getFullBlock() {
        return (Supplier)FLBlocks.METALS.get((Object)this).get(Metal.BlockType.BLOCK);
    }

    public static enum ItemType {
        INGOT((NonNullFunction<FLMetal, Item>)((NonNullFunction)metal -> new Item(new Item.Properties()))),
        DOUBLE_INGOT((NonNullFunction<FLMetal, Item>)((NonNullFunction)metal -> new Item(new Item.Properties()))),
        SHEET((NonNullFunction<FLMetal, Item>)((NonNullFunction)metal -> new Item(new Item.Properties()))),
        DOUBLE_SHEET((NonNullFunction<FLMetal, Item>)((NonNullFunction)metal -> new Item(new Item.Properties()))),
        ROD((NonNullFunction<FLMetal, Item>)((NonNullFunction)metal -> new Item(new Item.Properties())));

        private final NonNullFunction<FLMetal, Item> itemFactory;

        private ItemType(NonNullFunction<FLMetal, Item> itemFactory) {
            this.itemFactory = itemFactory;
        }

        public Item create(FLMetal metal) {
            return (Item)this.itemFactory.apply((Object)metal);
        }
    }
}

