/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.recipes;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.recipes.FLRecipeSerializers;
import com.eerussianguy.firmalife.common.recipes.FLRecipeTypes;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.dries007.tfc.common.recipes.RecipeSerializerImpl;
import net.dries007.tfc.common.recipes.SimpleItemRecipe;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.dries007.tfc.util.JsonHelpers;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.Nullable;

public class StompingRecipe
extends SimpleItemRecipe {
    public static final IndirectHashCollection<Item, StompingRecipe> CACHE = IndirectHashCollection.createForRecipe(SimpleItemRecipe::getValidItems, FLRecipeTypes.STOMPING);
    private final ResourceLocation inputTexture;
    private final ResourceLocation outputTexture;
    private final SoundEvent sound;

    public StompingRecipe(ResourceLocation id, Ingredient ingredient, ItemStackProvider result, ResourceLocation inputTexture, ResourceLocation outputTexture, SoundEvent sound) {
        super(id, ingredient, result);
        this.inputTexture = inputTexture;
        this.outputTexture = outputTexture;
        this.sound = sound;
    }

    @Nullable
    public static StompingRecipe getRecipe(Level level, ItemStackInventory wrapper) {
        for (StompingRecipe recipe : CACHE.getAll((Object)wrapper.getStack().m_41720_())) {
            if (!recipe.matches(wrapper, level)) continue;
            return recipe;
        }
        return null;
    }

    public ResourceLocation getInputTexture() {
        return this.inputTexture;
    }

    public ResourceLocation getOutputTexture() {
        return this.outputTexture;
    }

    public SoundEvent getSound() {
        return this.sound;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)FLRecipeSerializers.STOMPING.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)FLRecipeTypes.STOMPING.get();
    }

    public static class StompingSerializer
    extends RecipeSerializerImpl<StompingRecipe> {
        public StompingRecipe fromJson(ResourceLocation id, JsonObject json) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)JsonHelpers.get((JsonObject)json, (String)"ingredient"));
            ItemStackProvider result = ItemStackProvider.fromJson((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            ResourceLocation preTexture = FLHelpers.res(JsonHelpers.m_13906_((JsonObject)json, (String)"input_texture"));
            ResourceLocation outTexture = FLHelpers.res(JsonHelpers.m_13906_((JsonObject)json, (String)"output_texture"));
            SoundEvent sound = (SoundEvent)JsonHelpers.getRegistryEntry((JsonObject)json, (String)"sound", (IForgeRegistry)ForgeRegistries.SOUND_EVENTS);
            return new StompingRecipe(id, ingredient, result, preTexture, outTexture, sound);
        }

        @Nullable
        public StompingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStackProvider result = ItemStackProvider.fromNetwork((FriendlyByteBuf)buffer);
            ResourceLocation pre = buffer.m_130281_();
            ResourceLocation post = buffer.m_130281_();
            SoundEvent sound = (SoundEvent)buffer.readRegistryIdUnsafe(ForgeRegistries.SOUND_EVENTS);
            return new StompingRecipe(id, ingredient, result, pre, post, sound);
        }

        public void toNetwork(FriendlyByteBuf buffer, StompingRecipe recipe) {
            recipe.getIngredient().m_43923_(buffer);
            recipe.getResult().toNetwork(buffer);
            buffer.m_130085_(recipe.inputTexture);
            buffer.m_130085_(recipe.outputTexture);
            buffer.writeRegistryIdUnsafe(ForgeRegistries.SOUND_EVENTS, (Object)recipe.sound);
        }
    }
}

