/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.recipes;

import com.eerussianguy.firmalife.common.blockentities.MixingBowlBlockEntity;
import com.eerussianguy.firmalife.common.recipes.FLRecipeSerializers;
import com.eerussianguy.firmalife.common.recipes.FLRecipeTypes;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.recipes.ISimpleRecipe;
import net.dries007.tfc.common.recipes.RecipeSerializerImpl;
import net.dries007.tfc.common.recipes.ingredients.FluidStackIngredient;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class MixingBowlRecipe
implements ISimpleRecipe<MixingBowlBlockEntity.MixingBowlInventory> {
    private final ResourceLocation id;
    private final List<Ingredient> itemIngredients;
    private final FluidStackIngredient fluidIngredient;
    private final ItemStack resultItem;
    private final FluidStack resultFluid;

    protected MixingBowlRecipe(ResourceLocation id, List<Ingredient> itemIngredients, FluidStackIngredient fluidIngredient, ItemStack resultItem, FluidStack resultFluid) {
        this.id = id;
        this.itemIngredients = itemIngredients;
        this.fluidIngredient = fluidIngredient;
        this.resultItem = resultItem;
        this.resultFluid = resultFluid;
        FoodCapability.setStackNonDecaying((ItemStack)this.resultItem);
    }

    public boolean matches(MixingBowlBlockEntity.MixingBowlInventory inventory, Level level) {
        if (!this.fluidIngredient.test(inventory.getFluidInTank(0))) {
            return false;
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < 5; ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            stacks.add(stack);
        }
        return this.itemIngredients.isEmpty() ? stacks.isEmpty() : Helpers.perfectMatchExists(stacks, this.itemIngredients);
    }

    public FluidStackIngredient getFluidIngredient() {
        return this.fluidIngredient;
    }

    public FluidStack getDisplayFluid() {
        return this.resultFluid;
    }

    public FluidStack getResultFluid() {
        return this.resultFluid.copy();
    }

    public List<Ingredient> getItemIngredients() {
        return this.itemIngredients;
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return this.resultItem;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)FLRecipeSerializers.MIXING_BOWL.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)FLRecipeTypes.MIXING_BOWL.get();
    }

    public static class Serializer
    extends RecipeSerializerImpl<MixingBowlRecipe> {
        public MixingBowlRecipe fromJson(ResourceLocation id, JsonObject json) {
            ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
            if (json.has("ingredients")) {
                JsonArray array = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
                for (JsonElement element : array) {
                    ingredients.add(Ingredient.m_43917_((JsonElement)element));
                }
            }
            FluidStackIngredient fluidIngredient = json.has("fluid_ingredient") ? FluidStackIngredient.fromJson((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"fluid_ingredient")) : FluidStackIngredient.EMPTY;
            ItemStack result = json.has("output_item") ? JsonHelpers.getItemStack((JsonObject)json, (String)"output_item") : ItemStack.f_41583_;
            FluidStack fluidResult = json.has("output_fluid") ? JsonHelpers.getFluidStack((JsonObject)json, (String)"output_fluid") : FluidStack.EMPTY;
            return new MixingBowlRecipe(id, ingredients, fluidIngredient, result, fluidResult);
        }

        @Nullable
        public MixingBowlRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            int count = buffer.m_130242_();
            ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>(count);
            for (int i = 0; i < count; ++i) {
                ingredients.add(Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            FluidStackIngredient fluidIngredient = FluidStackIngredient.fromNetwork((FriendlyByteBuf)buffer);
            ItemStack result = buffer.m_130267_();
            FluidStack fluidOut = buffer.readFluidStack();
            return new MixingBowlRecipe(id, ingredients, fluidIngredient, result, fluidOut);
        }

        public void toNetwork(FriendlyByteBuf buffer, MixingBowlRecipe recipe) {
            buffer.m_130130_(recipe.itemIngredients.size());
            for (Ingredient ingredient : recipe.itemIngredients) {
                ingredient.m_43923_(buffer);
            }
            recipe.fluidIngredient.toNetwork(buffer);
            buffer.m_130055_(recipe.resultItem);
            buffer.writeFluidStack(recipe.resultFluid);
        }
    }
}

