/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.recipes;

import com.eerussianguy.firmalife.common.recipes.FLRecipeSerializers;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.PotBlockEntity;
import net.dries007.tfc.common.capabilities.food.DynamicBowlHandler;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodData;
import net.dries007.tfc.common.capabilities.food.FoodHandler;
import net.dries007.tfc.common.capabilities.food.IFood;
import net.dries007.tfc.common.recipes.PotRecipe;
import net.dries007.tfc.common.recipes.ingredients.FluidStackIngredient;
import net.dries007.tfc.compat.jade.common.BlockEntityTooltip;
import net.dries007.tfc.compat.jade.common.BlockEntityTooltips;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.ItemHandlerHelper;

public class BowlPotRecipe
extends PotRecipe {
    public static final PotRecipe.OutputType OUTPUT_TYPE = nbt -> {
        ItemStack stack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("item"));
        return new BowlOutput(stack);
    };
    private final ItemStack itemOutput;
    private final FoodData food;

    public BowlPotRecipe(ResourceLocation id, List<Ingredient> itemIngredients, FluidStackIngredient fluidIngredient, int duration, float minTemp, ItemStack itemOutput, FoodData food) {
        super(id, itemIngredients, fluidIngredient, duration, minTemp);
        this.itemOutput = FoodCapability.setStackNonDecaying((ItemStack)itemOutput);
        this.food = food;
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return this.itemOutput;
    }

    public PotRecipe.Output getOutput(PotBlockEntity.PotInventory inv) {
        ItemStack item = this.itemOutput.m_41777_();
        IFood cap = (IFood)Helpers.getCapability((ICapabilityProvider)item, (Capability)FoodCapability.CAPABILITY);
        if (cap instanceof FoodHandler.Dynamic) {
            FoodHandler.Dynamic dynamic = (FoodHandler.Dynamic)cap;
            dynamic.setCreationDate(FoodCapability.getRoundedCreationDate());
            dynamic.setFood(this.food);
        }
        return new BowlOutput(item);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)FLRecipeSerializers.BOWL_POT.get();
    }

    public record BowlOutput(ItemStack stack) implements PotRecipe.Output
    {
        public boolean isEmpty() {
            return this.stack.m_41619_();
        }

        public int getFluidColor() {
            return -14372399;
        }

        public InteractionResult onInteract(PotBlockEntity entity, Player player, ItemStack clickedWith) {
            if (Helpers.isItem((Item)clickedWith.m_41720_(), (TagKey)TFCTags.Items.SOUP_BOWLS) && !this.stack.m_41619_()) {
                this.stack.getCapability(FoodCapability.CAPABILITY).filter(food -> food instanceof DynamicBowlHandler).ifPresent(food -> ((DynamicBowlHandler)food).setBowl(clickedWith.m_255036_(1)));
                clickedWith.m_41774_(1);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.stack.m_41620_(1));
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }

        public void write(CompoundTag nbt) {
            nbt.m_128365_("item", (Tag)this.stack.m_41739_(new CompoundTag()));
        }

        public PotRecipe.OutputType getType() {
            return OUTPUT_TYPE;
        }

        public BlockEntityTooltip getTooltip() {
            return (level, blockState, blockPos, blockEntity, tooltip) -> {
                ArrayList text = new ArrayList();
                BlockEntityTooltips.itemWithCount((Consumer)tooltip, (ItemStack)this.stack);
                FoodCapability.addTooltipInfo((ItemStack)this.stack, text);
                text.forEach(tooltip);
            };
        }
    }

    public static class Serializer
    extends PotRecipe.Serializer<BowlPotRecipe> {
        protected BowlPotRecipe fromJson(ResourceLocation recipeId, JsonObject json, List<Ingredient> ingredients, FluidStackIngredient fluidIngredient, int duration, float minTemp) {
            return new BowlPotRecipe(recipeId, ingredients, fluidIngredient, duration, minTemp, JsonHelpers.getItemStack((JsonObject)json, (String)"item_output"), FoodData.read((JsonObject)json.getAsJsonObject("food")));
        }

        protected BowlPotRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer, List<Ingredient> ingredients, FluidStackIngredient fluidIngredient, int duration, float minTemp) {
            return new BowlPotRecipe(recipeId, ingredients, fluidIngredient, duration, minTemp, buffer.m_130267_(), FoodData.decode((FriendlyByteBuf)buffer));
        }

        public void toNetwork(FriendlyByteBuf buffer, BowlPotRecipe recipe) {
            super.toNetwork(buffer, (PotRecipe)recipe);
            buffer.m_130055_(recipe.itemOutput);
            recipe.food.encode(buffer);
        }
    }
}

