/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.misc;

import com.eerussianguy.firmalife.common.misc.AddItemModifier;
import com.eerussianguy.firmalife.common.misc.BlockIngredientLootCondition;
import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class FLLoot {
    public static final DeferredRegister<Codec<? extends IGlobalLootModifier>> MODIFIER_SERIALIZERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"firmalife");
    public static final DeferredRegister<LootItemConditionType> CONDITIONS = DeferredRegister.create((ResourceKey)Registries.f_256976_, (String)"firmalife");
    public static final RegistryObject<LootItemConditionType> BLOCK_INGREDIENT = FLLoot.lootCondition("block_ingredient", new BlockIngredientLootCondition.Serializer());
    public static final RegistryObject<Codec<AddItemModifier>> ADD_ITEM = FLLoot.glmSerializer("add_item", () -> AddItemModifier.CODEC);

    private static RegistryObject<LootItemConditionType> lootCondition(String id, Serializer<? extends LootItemCondition> serializer) {
        return CONDITIONS.register(id, () -> new LootItemConditionType(serializer));
    }

    private static <T extends IGlobalLootModifier> RegistryObject<Codec<T>> glmSerializer(String id, Supplier<Codec<T>> modifier) {
        return MODIFIER_SERIALIZERS.register(id, modifier);
    }

    public static void registerAll(IEventBus bus) {
        CONDITIONS.register(bus);
        MODIFIER_SERIALIZERS.register(bus);
    }
}

