/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.items;

import com.eerussianguy.firmalife.common.blocks.greenhouse.SprinklerPipeBlock;
import com.eerussianguy.firmalife.config.FLConfig;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class SprinklerItem
extends BlockItem {
    private final Block floorBlock;

    public SprinklerItem(Block block, Block floorBlock, Item.Properties properties) {
        super(block, properties);
        this.floorBlock = floorBlock;
    }

    @Nullable
    protected BlockState m_5965_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        for (Direction dir : context.m_6232_()) {
            cursor.m_122159_((Vec3i)pos, dir);
            if (!this.isPipe(level, (BlockPos)cursor)) continue;
            if (dir == Direction.UP) {
                return super.m_5965_(context);
            }
            if (dir != Direction.DOWN) continue;
            return this.getPlacementState(this.floorBlock, context);
        }
        return null;
    }

    public void m_6192_(Map<Block, Item> map, Item item) {
        super.m_6192_(map, item);
        map.put(this.floorBlock, item);
    }

    public void removeFromBlockToItemMap(Map<Block, Item> map, Item item) {
        super.removeFromBlockToItemMap(map, item);
        map.remove(this.floorBlock);
    }

    @Nullable
    private BlockState getPlacementState(Block block, BlockPlaceContext context) {
        BlockState state = block.m_5573_(context);
        return state != null && this.m_40610_(context, state) ? state : null;
    }

    public boolean isPipe(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_60734_() instanceof SprinklerPipeBlock || (Boolean)FLConfig.SERVER.usePipesForSprinklers.get() == false;
    }
}

