/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.items;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.FLTags;
import com.eerussianguy.firmalife.common.blocks.FLBlocks;
import com.eerussianguy.firmalife.common.blocks.FLFluids;
import com.eerussianguy.firmalife.common.blocks.OvenType;
import com.eerussianguy.firmalife.common.capabilities.wine.WineType;
import com.eerussianguy.firmalife.common.items.BeehiveFrameItem;
import com.eerussianguy.firmalife.common.items.FLFood;
import com.eerussianguy.firmalife.common.items.FilledWineBottleItem;
import com.eerussianguy.firmalife.common.items.FinishItem;
import com.eerussianguy.firmalife.common.items.GrapeSeedItem;
import com.eerussianguy.firmalife.common.items.HollowShellItem;
import com.eerussianguy.firmalife.common.items.PeelItem;
import com.eerussianguy.firmalife.common.items.SeedBallItem;
import com.eerussianguy.firmalife.common.items.Spice;
import com.eerussianguy.firmalife.common.items.SprinklerItem;
import com.eerussianguy.firmalife.common.items.WateringCanItem;
import com.eerussianguy.firmalife.common.items.WineBottleItem;
import com.eerussianguy.firmalife.common.items.WineGlassItem;
import com.eerussianguy.firmalife.common.util.ExtraFluid;
import com.eerussianguy.firmalife.common.util.FLArmorMaterials;
import com.eerussianguy.firmalife.common.util.FLFruit;
import com.eerussianguy.firmalife.common.util.FLMetal;
import com.eerussianguy.firmalife.config.FLConfig;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.rock.Ore;
import net.dries007.tfc.common.items.Food;
import net.dries007.tfc.common.items.JarItem;
import net.dries007.tfc.util.Helpers;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class FLItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"firmalife");
    public static final EnumSet<Food> TFC_FRUITS = EnumSet.of(Food.BANANA, new Food[]{Food.BLACKBERRY, Food.BLUEBERRY, Food.BUNCHBERRY, Food.CHERRY, Food.CLOUDBERRY, Food.CRANBERRY, Food.ELDERBERRY, Food.GOOSEBERRY, Food.GREEN_APPLE, Food.LEMON, Food.OLIVE, Food.ORANGE, Food.PEACH, Food.PLUM, Food.RASPBERRY, Food.RED_APPLE, Food.SNOWBERRY, Food.STRAWBERRY, Food.WINTERGREEN_BERRY});
    public static final RegistryObject<Item> BEEHIVE_FRAME = FLItems.register("beehive_frame", () -> new BeehiveFrameItem(FLItems.prop()));
    public static final RegistryObject<Item> BEESWAX = FLItems.register("beeswax", () -> new HoneycombItem(FLItems.prop()));
    public static final RegistryObject<Item> CINNAMON_BARK = FLItems.register("cinnamon_bark");
    public static final RegistryObject<Item> CHEESECLOTH = FLItems.register("cheesecloth");
    public static final RegistryObject<Item> FRUIT_LEAF = FLItems.register("fruit_leaf");
    public static final RegistryObject<Item> HOLLOW_SHELL = FLItems.register("hollow_shell", () -> new HollowShellItem(FLItems.prop(), (Supplier<Integer>)FLConfig.SERVER.hollowShellCapacity, FLTags.Fluids.USABLE_IN_HOLLOW_SHELL, false, false));
    public static final RegistryObject<Item> WINE_GLASS = FLItems.register("wine_glass", () -> new WineGlassItem(FLItems.prop(), (Supplier<Integer>)FLConfig.SERVER.wineGlassCapacity, FLTags.Fluids.USABLE_IN_WINE_GLASS));
    public static final RegistryObject<Item> ICE_SHAVINGS = FLItems.register("ice_shavings");
    public static final RegistryObject<Item> OVEN_INSULATION = FLItems.register("oven_insulation", () -> new PeelItem(FLItems.prop()));
    public static final RegistryObject<Item> PEEL = FLItems.register("peel", () -> new PeelItem(FLItems.prop()));
    public static final RegistryObject<Item> PIE_PAN = FLItems.register("pie_pan");
    public static final RegistryObject<Item> PINEAPPLE_FIBER = FLItems.register("pineapple_fiber");
    public static final RegistryObject<Item> PINEAPPLE_LEATHER = FLItems.register("pineapple_leather");
    public static final RegistryObject<Item> PINEAPPLE_YARN = FLItems.register("pineapple_yarn");
    public static final RegistryObject<Item> POTTERY_SHERD = FLItems.register("pottery_sherd");
    public static final RegistryObject<Item> RAW_HONEY = FLItems.register("raw_honey");
    public static final RegistryObject<Item> REINFORCED_GLASS = FLItems.register("reinforced_glass");
    public static final RegistryObject<Item> RENNET = FLItems.register("rennet");
    public static final RegistryObject<Item> SEED_BALL = FLItems.register("seed_ball", () -> new SeedBallItem(FLItems.prop()));
    public static final RegistryObject<Item> SPOON = FLItems.register("spoon");
    public static final RegistryObject<Item> SPRINKLER = FLItems.register("sprinkler", () -> new SprinklerItem((Block)FLBlocks.SPRINKLER.get(), (Block)FLBlocks.FLOOR_SPRINKLER.get(), FLItems.prop()));
    public static final RegistryObject<Item> STAINLESS_STEEL_JAR_LID = FLItems.register("stainless_steel_jar_lid");
    public static final RegistryObject<Item> EMPTY_JAR_WITH_STAINLESS_STEEL_LID = FLItems.register("empty_jar_with_stainless_steel_lid");
    public static final RegistryObject<Item> TREATED_LUMBER = FLItems.register("treated_lumber");
    public static final RegistryObject<Item> WATERING_CAN = FLItems.register("watering_can", () -> new WateringCanItem(FLItems.prop().m_41499_(20)));
    public static final RegistryObject<Item> HEMATITIC_WINE_BOTTLE = FLItems.register("hematitic_wine_bottle", () -> new FilledWineBottleItem(FLItems.prop(), FLHelpers.identifier("block/hematitic_wine_bottle")));
    public static final RegistryObject<Item> VOLCANIC_WINE_BOTTLE = FLItems.register("volcanic_wine_bottle", () -> new FilledWineBottleItem(FLItems.prop(), FLHelpers.identifier("block/volcanic_wine_bottle")));
    public static final RegistryObject<Item> OLIVINE_WINE_BOTTLE = FLItems.register("olivine_wine_bottle", () -> new FilledWineBottleItem(FLItems.prop(), FLHelpers.identifier("block/olivine_wine_bottle")));
    public static final RegistryObject<Item> EMPTY_HEMATITIC_WINE_BOTTLE = FLItems.register("empty_hematitic_wine_bottle", () -> new WineBottleItem(FLItems.prop(), FLHelpers.identifier("block/empty_hematitic_wine_bottle")));
    public static final RegistryObject<Item> EMPTY_VOLCANIC_WINE_BOTTLE = FLItems.register("empty_volcanic_wine_bottle", () -> new WineBottleItem(FLItems.prop(), FLHelpers.identifier("block/empty_volcanic_wine_bottle")));
    public static final RegistryObject<Item> EMPTY_OLIVINE_WINE_BOTTLE = FLItems.register("empty_olivine_wine_bottle", () -> new WineBottleItem(FLItems.prop(), FLHelpers.identifier("block/empty_olivine_wine_bottle")));
    public static final RegistryObject<Item> CORK = FLItems.register("cork");
    public static final RegistryObject<Item> TIRAGE_MIXTURE = FLItems.register("tirage_mixture");
    public static final RegistryObject<Item> BARREL_STAVE = FLItems.register("barrel_stave");
    public static final RegistryObject<Item> BOTTLE_LABEL = FLItems.register("bottle_label");
    public static final RegistryObject<Item> RED_GRAPE_SEEDS = FLItems.register("seeds/red_grape", () -> new GrapeSeedItem(new Item.Properties(), (Supplier<? extends Block>)FLBlocks.GRAPE_STRING_PLANT_RED));
    public static final RegistryObject<Item> WHITE_GRAPE_SEEDS = FLItems.register("seeds/white_grape", () -> new GrapeSeedItem(new Item.Properties(), (Supplier<? extends Block>)FLBlocks.GRAPE_STRING_PLANT_WHITE));
    public static final RegistryObject<Item> BEEKEEPER_HELMET = FLItems.register("beekeeper_helmet", () -> new ArmorItem((ArmorMaterial)FLArmorMaterials.BEEKEEPER, ArmorItem.Type.HELMET, new Item.Properties()));
    public static final RegistryObject<Item> BEEKEEPER_CHESTPLATE = FLItems.register("beekeeper_chestplate", () -> new ArmorItem((ArmorMaterial)FLArmorMaterials.BEEKEEPER, ArmorItem.Type.CHESTPLATE, new Item.Properties()));
    public static final RegistryObject<Item> BEEKEEPER_LEGGINGS = FLItems.register("beekeeper_leggings", () -> new ArmorItem((ArmorMaterial)FLArmorMaterials.BEEKEEPER, ArmorItem.Type.LEGGINGS, new Item.Properties()));
    public static final RegistryObject<Item> BEEKEEPER_BOOTS = FLItems.register("beekeeper_boots", () -> new ArmorItem((ArmorMaterial)FLArmorMaterials.BEEKEEPER, ArmorItem.Type.BOOTS, new Item.Properties()));
    public static final Map<Spice, RegistryObject<Item>> SPICES = Helpers.mapOfKeys(Spice.class, spice -> FLItems.register("spice/" + spice.name()));
    public static final Map<FLFood, RegistryObject<Item>> FOODS = Helpers.mapOfKeys(FLFood.class, food -> FLItems.register("food/" + food.name(), () -> new Item(new Item.Properties().m_41489_(food.getFoodProperties()))));
    public static final Map<FLFruit, RegistryObject<Item>> FRUITS = Helpers.mapOfKeys(FLFruit.class, food -> FLItems.register("food/" + food.name(), () -> new Item(new Item.Properties().m_41489_(food.getFoodProperties()))));
    public static final Map<OvenType, RegistryObject<Item>> FINISHES = Helpers.mapOfKeys(OvenType.class, type -> type != OvenType.BRICK, type -> FLItems.register(type.getTrueName() + "_finish", () -> new FinishItem(FLItems.prop(), (OvenType)((Object)type))));
    public static final RegistryObject<Item> HONEY_JAR = FLItems.register("jar/honey", () -> new JarItem(new Item.Properties(), FLHelpers.identifier("block/jar/honey"), true));
    public static final RegistryObject<Item> COMPOST_JAR = FLItems.register("jar/compost", () -> new JarItem(new Item.Properties(), FLHelpers.identifier("block/jar/compost"), true));
    public static final RegistryObject<Item> ROTTEN_COMPOST_JAR = FLItems.register("jar/rotten_compost", () -> new JarItem(new Item.Properties(), FLHelpers.identifier("block/jar/rotten_compost"), true));
    public static final RegistryObject<Item> GUANO_JAR = FLItems.register("jar/guano", () -> new JarItem(new Item.Properties(), FLHelpers.identifier("block/jar/guano"), true));
    public static final Map<FLFruit, RegistryObject<Item>> FL_FRUIT_PRESERVES = Helpers.mapOfKeys(FLFruit.class, food -> FLItems.register("jar/" + food.getSerializedName(), () -> new JarItem(new Item.Properties(), FLHelpers.identifier("block/jar/" + food.getSerializedName()), false)));
    public static final Map<FLFruit, RegistryObject<Item>> FL_UNSEALED_FRUIT_PRESERVES = Helpers.mapOfKeys(FLFruit.class, food -> FLItems.register("jar/" + food.getSerializedName() + "_unsealed", () -> new JarItem(new Item.Properties(), FLHelpers.identifier("block/jar/" + food.getSerializedName()), true)));
    public static final RegistryObject<Item> FILLED_PIE = FLItems.register("food/filled_pie");
    public static final RegistryObject<Item> RAW_PUMPKIN_PIE = FLItems.register("food/raw_pumpkin_pie");
    public static final RegistryObject<Item> RAW_PIZZA = FLItems.register("food/raw_pizza");
    public static final RegistryObject<Item> NIGHTSHADE_BERRY = FLItems.register("food/nightshade_berry", () -> new Item(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(4).m_38758_(0.3f).effect(() -> new MobEffectInstance(MobEffects.f_19602_, 1, 10), 0.5f).m_38767_())));
    public static final RegistryObject<Item> STINKY_SOUP = FLItems.register("food/stinky_soup", () -> new Item(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(4).m_38758_(0.3f).effect(() -> new MobEffectInstance(MobEffects.f_19602_, 1, 10), 0.5f).m_38767_())));
    public static final Map<Ore.Grade, RegistryObject<Item>> CHROMIUM_ORES = Helpers.mapOfKeys(Ore.Grade.class, grade -> FLItems.register("ore/" + grade.name() + "_chromite"));
    public static final Map<FLMetal, Map<FLMetal.ItemType, RegistryObject<Item>>> METAL_ITEMS = Helpers.mapOfKeys(FLMetal.class, metal -> Helpers.mapOfKeys(FLMetal.ItemType.class, type -> FLItems.register("metal/" + type.name() + "/" + metal.name(), () -> type.create((FLMetal)((Object)metal)))));
    public static final Map<FLMetal, RegistryObject<BucketItem>> METAL_FLUID_BUCKETS = Helpers.mapOfKeys(FLMetal.class, metal -> FLItems.register("bucket/metal/" + metal.name(), () -> new BucketItem((Supplier)FLFluids.METALS.get(metal).source(), new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1))));
    public static final Map<ExtraFluid, RegistryObject<BucketItem>> EXTRA_FLUID_BUCKETS = Helpers.mapOfKeys(ExtraFluid.class, fluid -> FLItems.register("bucket/" + fluid.m_7912_(), () -> new BucketItem((Supplier)FLFluids.EXTRA_FLUIDS.get(fluid).source(), new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1))));
    public static final Map<WineType, RegistryObject<BucketItem>> WINE_FLUID_BUCKETS = Helpers.mapOfKeys(WineType.class, fluid -> FLItems.register("bucket/" + fluid.m_7912_(), () -> new BucketItem((Supplier)FLFluids.WINE_FLUIDS.get(fluid).source(), new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1))));

    private static Item.Properties prop() {
        return new Item.Properties();
    }

    private static Item.Properties foodProperties() {
        return new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(4).m_38758_(0.3f).m_38767_());
    }

    private static RegistryObject<Item> register(String name) {
        return FLItems.register(name, () -> new Item(new Item.Properties()));
    }

    private static <T extends Item> RegistryObject<T> register(String name, Supplier<T> item) {
        return ITEMS.register(name.toLowerCase(Locale.ROOT), item);
    }
}

