/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.capabilities.bee;

import com.eerussianguy.firmalife.common.capabilities.bee.BeeAbility;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraftforge.common.util.INBTSerializable;

public interface IBee
extends INBTSerializable<CompoundTag> {
    public static final int MAX_DISEASE = 5;
    public static final int MAX_INFECTION = 5;

    public void setHasQueen(boolean var1);

    public boolean hasQueen();

    public int[] getAbilityMap();

    public void setAbilities(int[] var1);

    public void setAbility(BeeAbility var1, int var2);

    public void setGeneticDisease(int var1);

    public int getGeneticDisease();

    default public boolean hasGeneticDisease() {
        return this.getGeneticDisease() != -1;
    }

    public void setParasiticInfection(int var1);

    public int getParasiticInfection();

    default public boolean hasParasiticInfection() {
        return this.getParasiticInfection() != -1;
    }

    default public int getAbility(BeeAbility ability) {
        return this.getAbilityMap()[ability.ordinal()];
    }

    default public void initFreshAbilities(RandomSource random) {
        int[] values = BeeAbility.fresh();
        values[random.m_188503_((int)values.length)] = random.m_188503_(3) + 1;
        values[random.m_188503_((int)values.length)] = random.m_188503_(3) + 1;
        if (random.m_188501_() < 0.1f) {
            values[random.m_188503_((int)values.length)] = random.m_188503_(3) + 1;
        }
        this.setAbilities(values);
        this.setHasQueen(true);
    }

    default public void setAbilitiesFromParents(IBee parent1, IBee parent2, RandomSource random) {
        int[] parent1Abilities = parent1.getAbilityMap();
        int[] parent2Abilities = parent2.getAbilityMap();
        int mutation = (parent1Abilities[BeeAbility.MUTANT.ordinal()] + parent2Abilities[BeeAbility.MUTANT.ordinal()]) / 2;
        mutation = Mth.m_14045_((int)mutation, (int)1, (int)5);
        int abilitiesSet = 0;
        List<BeeAbility> abilities = Arrays.asList(BeeAbility.VALUES);
        Collections.shuffle(abilities);
        for (BeeAbility ability : abilities) {
            int average = (parent1Abilities[ability.ordinal()] + parent2Abilities[ability.ordinal()]) / 2;
            if (average < 1 || abilitiesSet >= 4) continue;
            ++abilitiesSet;
            this.setAbility(ability, Mth.m_216271_((RandomSource)random, (int)(average - mutation), (int)(average + mutation)));
        }
        this.setHasQueen(true);
        if (parent1.hasGeneticDisease()) {
            this.setGeneticDisease(parent1.getGeneticDisease());
        } else {
            this.setGeneticDisease(parent2.getGeneticDisease());
        }
        if (mutation >= 4 && random.m_188503_(5) == 0) {
            this.setGeneticDisease(Mth.m_216271_((RandomSource)random, (int)0, (int)5));
        }
    }

    default public void addTooltipInfo(List<Component> tooltip) {
        if (this.hasQueen()) {
            tooltip.add((Component)Component.m_237115_((String)"firmalife.bee.queen").m_130940_(ChatFormatting.GOLD));
            if (this.getGeneticDisease() != -1) {
                tooltip.add((Component)Component.m_237110_((String)"firmalife.bee.genetic_disease", (Object[])new Object[]{Component.m_237115_((String)("firmalife.bee.disease" + this.getGeneticDisease()))}).m_130940_(ChatFormatting.RED));
            }
            if (this.getParasiticInfection() != -1) {
                tooltip.add((Component)Component.m_237110_((String)"firmalife.bee.parasitic_infection", (Object[])new Object[]{Component.m_237115_((String)("firmalife.bee.infection" + this.getGeneticDisease()))}).m_130940_(ChatFormatting.RED));
            }
            tooltip.add((Component)Component.m_237115_((String)"firmalife.bee.abilities").m_130940_(ChatFormatting.WHITE));
            for (BeeAbility ability : BeeAbility.VALUES) {
                int amount = this.getAbility(ability);
                if (amount <= 0) continue;
                tooltip.add((Component)Component.m_237110_((String)("firmalife.bee.ability." + ability.m_7912_()), (Object[])new Object[]{String.valueOf(amount)}).m_130940_(ChatFormatting.GRAY));
            }
        } else {
            tooltip.add((Component)Component.m_237115_((String)"firmalife.bee.no_queen").m_130940_(ChatFormatting.RED));
        }
    }
}

