/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.capabilities.bee;

import com.eerussianguy.firmalife.common.capabilities.bee.BeeAbility;
import com.eerussianguy.firmalife.common.capabilities.bee.BeeCapability;
import com.eerussianguy.firmalife.common.capabilities.bee.IBee;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeeHandler
implements IBee,
ICapabilitySerializable<CompoundTag> {
    private final LazyOptional<IBee> capability = LazyOptional.of(() -> this);
    private final ItemStack stack;
    private int[] abilities;
    private boolean hasQueen = false;
    private int geneticDisease = -1;
    private int parasiticInfection = -1;
    private boolean initialized = false;

    public BeeHandler(ItemStack stack) {
        this.stack = stack;
        this.abilities = new int[BeeAbility.SIZE];
    }

    @Override
    public int[] getAbilityMap() {
        return this.abilities;
    }

    @Override
    public void setAbilities(int[] abilities) {
        this.abilities = abilities;
        this.save();
    }

    @Override
    public void setAbility(BeeAbility ability, int value) {
        this.abilities[ability.ordinal()] = Mth.m_14045_((int)value, (int)1, (int)10);
        this.save();
    }

    @Override
    public void setGeneticDisease(int geneticDisease) {
        this.geneticDisease = geneticDisease;
    }

    @Override
    public int getGeneticDisease() {
        return this.geneticDisease;
    }

    @Override
    public void setParasiticInfection(int parasiticInfection) {
        this.parasiticInfection = parasiticInfection;
    }

    @Override
    public int getParasiticInfection() {
        return this.parasiticInfection;
    }

    @Override
    public boolean hasQueen() {
        return this.hasQueen;
    }

    @Override
    public void setHasQueen(boolean exists) {
        this.hasQueen = exists;
        this.save();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == BeeCapability.CAPABILITY) {
            this.load();
            return this.capability.cast();
        }
        return LazyOptional.empty();
    }

    private void load() {
        if (!this.initialized) {
            this.initialized = true;
            CompoundTag tag = this.stack.m_41784_();
            if (tag.m_128441_("queen")) {
                this.hasQueen = tag.m_128471_("queen");
                this.abilities = tag.m_128465_("abilities");
                this.geneticDisease = EntityHelpers.getIntOrDefault((CompoundTag)tag, (String)"geneticDiseases", (int)-1);
                this.parasiticInfection = EntityHelpers.getIntOrDefault((CompoundTag)tag, (String)"parasiticInfections", (int)-1);
            }
        }
    }

    private void save() {
        CompoundTag tag = this.stack.m_41784_();
        tag.m_128385_("abilities", this.abilities);
        tag.m_128379_("queen", this.hasQueen);
        tag.m_128405_("geneticDiseases", this.geneticDisease);
        tag.m_128405_("parasiticInfections", this.parasiticInfection);
    }

    public CompoundTag serializeNBT() {
        return new CompoundTag();
    }

    public void deserializeNBT(CompoundTag nbt) {
    }
}

