/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blocks.plant;

import com.eerussianguy.firmalife.common.blockentities.GrapePlantBlockEntity;
import com.eerussianguy.firmalife.common.blocks.FLBlocks;
import com.eerussianguy.firmalife.common.blocks.plant.GrapeStringWithPlantBlock;
import com.eerussianguy.firmalife.common.blocks.plant.GrapeTrellisPostBlock;
import java.util.List;
import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.ISlowEntities;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.plant.fruit.Lifecycle;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodTrait;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class GrapeTrellisPostWithPlantBlock
extends GrapeTrellisPostBlock
implements ISlowEntities {
    public static final EnumProperty<Lifecycle> LIFECYCLE = TFCBlockStateProperties.LIFECYCLE;
    public static final VoxelShape SHAPE_WITH_PLANT = Shapes.m_83110_((VoxelShape)SHAPE, (VoxelShape)GrapeTrellisPostWithPlantBlock.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    private final Supplier<? extends Item> grapeItem;

    public GrapeTrellisPostWithPlantBlock(ExtendedProperties properties, Supplier<? extends Item> grapeItem) {
        super(properties);
        this.grapeItem = grapeItem;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)AXIS, (Comparable)Direction.Axis.X)).m_61124_((Property)STRING_PLUS, (Comparable)Boolean.valueOf(false))).m_61124_((Property)STRING_MINUS, (Comparable)Boolean.valueOf(false))).m_61124_(LIFECYCLE, (Comparable)Lifecycle.HEALTHY));
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        InteractionResult ropeUse = super.m_6227_(state, level, pos, player, hand, result);
        if (!ropeUse.m_19077_() && state.m_61143_(LIFECYCLE) == Lifecycle.FRUITING) {
            level.m_5594_(player, pos, SoundEvents.f_12457_, SoundSource.PLAYERS, 1.0f, level.m_213780_().m_188501_() + 0.7f + 0.3f);
            ItemStack stack = this.grapeItem.get().m_7968_();
            GrapePlantBlockEntity grape = this.findPlant(level, pos, state);
            if (grape != null) {
                List<FoodTrait> traits = grape.scanAndReport();
                for (FoodTrait trait : traits) {
                    FoodCapability.applyTrait((ItemStack)stack, (FoodTrait)trait);
                }
            }
            FoodCapability.updateFoodDecayOnCreate((ItemStack)stack);
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
            level.m_46597_(pos, (BlockState)state.m_61124_(LIFECYCLE, (Comparable)Lifecycle.HEALTHY));
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    private GrapePlantBlockEntity findPlant(Level level, BlockPos pos, BlockState state) {
        Direction dir = state.m_61143_((Property)AXIS) == Direction.Axis.X ? Direction.NORTH : Direction.WEST;
        BlockEntity blockEntity = level.m_7702_(pos.m_7495_().m_121945_(dir));
        if (blockEntity instanceof GrapePlantBlockEntity) {
            GrapePlantBlockEntity grape = (GrapePlantBlockEntity)blockEntity;
            return grape;
        }
        blockEntity = level.m_7702_(pos.m_7495_().m_121945_(dir.m_122424_()));
        if (blockEntity instanceof GrapePlantBlockEntity) {
            GrapePlantBlockEntity grape = (GrapePlantBlockEntity)blockEntity;
            return grape;
        }
        return null;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_WITH_PLANT;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (((Direction.Axis)state.m_61143_((Property)AXIS)).test(facing) && !(facingState.m_60734_() instanceof GrapeStringWithPlantBlock)) {
            return level.m_8055_(pos.m_121945_(facing.m_122424_())).m_60734_() instanceof GrapeStringWithPlantBlock ? state : Helpers.copyProperties((BlockState)((Block)FLBlocks.GRAPE_TRELLIS_POST.get()).m_49966_(), (BlockState)state);
        }
        return super.m_7417_(state, facing, facingState, level, pos, facingPos);
    }

    public VoxelShape m_7947_(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.m_83040_();
    }

    public float slowEntityFactor(BlockState blockState) {
        return 0.5f;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{LIFECYCLE}));
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)FLBlocks.GRAPE_TRELLIS_POST.get());
    }
}

