/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blocks.plant;

import com.eerussianguy.firmalife.common.blockentities.GrapePlantBlockEntity;
import com.eerussianguy.firmalife.common.blocks.FLBlocks;
import com.eerussianguy.firmalife.common.blocks.plant.GrapeStringBlock;
import com.eerussianguy.firmalife.common.blocks.plant.GrapeStringWithPlantBlock;
import com.eerussianguy.firmalife.common.blocks.plant.IGrape;
import com.eerussianguy.firmalife.common.util.FLClimateRanges;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.plant.fruit.Lifecycle;
import net.dries007.tfc.common.blocks.soil.FarmlandBlock;
import net.dries007.tfc.common.blocks.soil.HoeOverlayBlock;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.climate.ClimateRange;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GrapeGroundPlantOnStringBlock
extends GrapeStringBlock
implements IGrape,
HoeOverlayBlock {
    public static final IntegerProperty STAGE = TFCBlockStateProperties.STAGE_2;
    public static final EnumProperty<Lifecycle> LIFECYCLE = TFCBlockStateProperties.LIFECYCLE;
    public static final VoxelShape SHAPE_X_PLANT = Shapes.m_83110_((VoxelShape)SHAPE_X, (VoxelShape)GrapeGroundPlantOnStringBlock.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0));
    public static final VoxelShape SHAPE_Z_PLANT = Shapes.m_83110_((VoxelShape)SHAPE_Z, (VoxelShape)GrapeGroundPlantOnStringBlock.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0));
    private final Supplier<? extends Block> topBlock;

    public GrapeGroundPlantOnStringBlock(ExtendedProperties properties, Supplier<? extends Block> topBlock) {
        super(properties);
        this.topBlock = topBlock;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)STAGE, (Comparable)Integer.valueOf(0))).m_61124_(LIFECYCLE, (Comparable)Lifecycle.HEALTHY));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        return InteractionResult.PASS;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof GrapePlantBlockEntity) {
            GrapePlantBlockEntity grape = (GrapePlantBlockEntity)blockEntity;
            grape.tryUpdate();
        }
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        BlockState superState = super.m_7417_(state, facing, facingState, level, pos, facingPos);
        if (superState.m_60795_()) {
            return superState;
        }
        if (facing == Direction.DOWN && !Helpers.isBlock((BlockState)facingState, (TagKey)TFCTags.Blocks.BUSH_PLANTABLE_ON)) {
            return Helpers.copyProperty((BlockState)((Block)FLBlocks.GRAPE_STRING.get()).m_49966_(), (BlockState)state, (Property)AXIS);
        }
        return state;
    }

    @Override
    public void advance(Level level, BlockPos pos, BlockState state) {
        if ((Integer)state.m_61143_((Property)STAGE) == 2) {
            BlockPos abovePos = pos.m_7494_();
            BlockState above = level.m_8055_(abovePos);
            if (above.m_60734_() instanceof GrapeStringBlock && !(above.m_60734_() instanceof GrapeStringWithPlantBlock) && above.m_61143_((Property)AXIS) == state.m_61143_((Property)AXIS)) {
                level.m_46597_(abovePos, Helpers.copyProperty((BlockState)this.topBlock.get().m_49966_(), (BlockState)above, (Property)AXIS));
            }
        } else {
            level.m_46597_(pos, (BlockState)state.m_61122_((Property)STAGE));
        }
    }

    public void addHoeOverlayInfo(Level level, BlockPos pos, BlockState state, List<Component> tooltip, boolean debug) {
        tooltip.add(FarmlandBlock.getTemperatureTooltip((Level)level, (BlockPos)pos, (ClimateRange)FLClimateRanges.GRAPES.get(), (boolean)false));
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof GrapePlantBlockEntity) {
            GrapePlantBlockEntity grape = (GrapePlantBlockEntity)blockEntity;
            if (((Boolean)TFCConfig.CLIENT.enableDebug.get()).booleanValue()) {
                tooltip.add((Component)Component.m_237113_((String)("[Debug] Growth: " + grape.getGrowth())));
                tooltip.add((Component)Component.m_237113_((String)("[Debug] Brain Pos: " + grape.getBrainPos().m_123344_())));
                tooltip.add((Component)Component.m_237113_((String)("[Debug] Soil data: " + Arrays.toString(grape.debugViewOfSoilData()))));
                tooltip.add((Component)Component.m_237113_((String)("[Debug] Bees: " + grape.debugHasBees())));
            }
        }
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return state.m_61143_((Property)AXIS) == Direction.Axis.X ? SHAPE_X_PLANT : SHAPE_Z_PLANT;
    }

    public VoxelShape m_7947_(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.m_83040_();
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{STAGE, LIFECYCLE}));
    }
}

