/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blocks.greenhouse;

import com.eerussianguy.firmalife.client.FLClientHelpers;
import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blockentities.ClimateType;
import com.eerussianguy.firmalife.common.blockentities.LargePlanterBlockEntity;
import com.eerussianguy.firmalife.common.blocks.FLStateProperties;
import com.eerussianguy.firmalife.common.blocks.greenhouse.PlanterType;
import com.eerussianguy.firmalife.common.util.Mechanics;
import com.eerussianguy.firmalife.common.util.Plantable;
import java.util.List;
import java.util.function.Consumer;
import net.dries007.tfc.common.blockentities.FarmlandBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.crop.CropHelpers;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.common.blocks.soil.HoeOverlayBlock;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class LargePlanterBlock
extends DeviceBlock
implements HoeOverlayBlock {
    public static final BooleanProperty WATERED = FLStateProperties.WATERED;
    private static final VoxelShape LARGE_SHAPE = LargePlanterBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);

    public LargePlanterBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)WATERED, (Comparable)Boolean.valueOf(false)));
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof LargePlanterBlockEntity) {
            LargePlanterBlockEntity planter = (LargePlanterBlockEntity)blockEntity;
            if (state.m_60734_() == this && Mechanics.growthTick((Level)level, pos, state, planter)) {
                planter.updateBlockState(state);
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack held = player.m_21120_(hand);
        Plantable plant = Plantable.get(held);
        int slot = this.getUseSlot(hit, pos);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof LargePlanterBlockEntity) {
            LargePlanterBlockEntity planter = (LargePlanterBlockEntity)blockEntity;
            if (held.m_41720_() == Items.f_41829_ && player.m_7500_()) {
                for (int i2 = 0; i2 < planter.slots(); ++i2) {
                    planter.setGrowth(i2, 1.0f);
                }
                planter.markForSync();
                return InteractionResult.SUCCESS;
            }
            if (CropHelpers.useFertilizer((Level)level, (Player)player, (InteractionHand)hand, (BlockPos)pos)) {
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (plant != null) {
                if (plant.getPlanterType() != this.getPlanterType()) {
                    player.m_5661_((Component)Component.m_237115_((String)"firmalife.greenhouse.wrong_type").m_7220_((Component)FLHelpers.translateEnum(plant.getPlanterType())), true);
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
                if (planter.getTier() < plant.getTier()) {
                    if (!planter.isClimateValid()) {
                        player.m_5661_((Component)Component.m_237115_((String)"firmalife.greenhouse.climate_invalid"), true);
                    } else {
                        player.m_5661_((Component)Component.m_237115_((String)"firmalife.greenhouse.wrong_tier"), true);
                    }
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
                return this.insertSlot(level, planter, held, player, slot);
            }
            if (player.m_6144_() && held.m_41619_()) {
                return LargePlanterBlock.takeSlot(level, planter, slot, i -> ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)i));
            }
        }
        return InteractionResult.PASS;
    }

    public PlanterType getPlanterType() {
        return PlanterType.LARGE;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        for (Direction d : Helpers.DIRECTIONS) {
            LargePlanterBlockEntity planter;
            BlockPos rel = pos.m_121945_(d);
            BlockEntity blockEntity = level.m_7702_(rel);
            if (!(blockEntity instanceof LargePlanterBlockEntity) || !(planter = (LargePlanterBlockEntity)blockEntity).checkValid()) continue;
            planter.setValid(level, rel, true, planter.getTier(), ClimateType.GREENHOUSE);
        }
    }

    public void addHoeOverlayInfo(Level level, BlockPos pos, BlockState state, List<Component> text, boolean debug) {
        if (!level.f_46443_) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof LargePlanterBlockEntity) {
            Component invalidReason;
            LargePlanterBlockEntity planter = (LargePlanterBlockEntity)blockEntity;
            BlockHitResult target = FLClientHelpers.getTargetedLocation();
            if (target == null) {
                return;
            }
            int slot = this.getUseSlot(target, pos);
            text.add((Component)Component.m_237110_((String)"firmalife.planter.growth_water", (Object[])new Object[]{String.format("%.2f", Float.valueOf(planter.getGrowth(slot))), String.format("%.2f", Float.valueOf(planter.getWater()))}));
            if (planter.getGrowth(slot) >= 1.0f) {
                text.add((Component)Component.m_237115_((String)"tfc.tooltip.farmland.mature"));
            }
            boolean valid = (invalidReason = planter.getInvalidReason()) == null;
            text.add((Component)Component.m_237115_((String)(valid ? "firmalife.greenhouse.valid_block" : "firmalife.greenhouse.invalid_block")));
            if (!valid) {
                text.add(invalidReason);
            }
            text.add((Component)Component.m_237110_((String)"tfc.tooltip.farmland.nutrients", (Object[])new Object[]{this.format(planter, FarmlandBlockEntity.NutrientType.NITROGEN), this.format(planter, FarmlandBlockEntity.NutrientType.PHOSPHOROUS), this.format(planter, FarmlandBlockEntity.NutrientType.POTASSIUM)}));
        }
    }

    private String format(LargePlanterBlockEntity planter, FarmlandBlockEntity.NutrientType value) {
        return String.format("%.2f", Float.valueOf(planter.getNutrient(value) * 100.0f));
    }

    protected int getUseSlot(BlockHitResult hit, BlockPos pos) {
        return 0;
    }

    public InteractionResult insertSlot(Level level, LargePlanterBlockEntity planter, ItemStack held, Player player, int slot) {
        return planter.getCapability(Capabilities.ITEM).map(inv -> {
            InteractionResult res = InteractionResult.PASS;
            if (inv.getStackInSlot(slot).m_41619_() && (res = FLHelpers.insertOne(level, held, slot, inv, player)).m_19077_()) {
                planter.setGrowth(slot, 0.0f);
                planter.updateCache();
            }
            return res;
        }).orElse(InteractionResult.PASS);
    }

    public static InteractionResult takeSlot(Level level, LargePlanterBlockEntity planter, int slot, Consumer<ItemStack> onExtract) {
        return planter.getCapability(Capabilities.ITEM).map(inv -> {
            Plantable plant = planter.getPlantable(slot);
            if (plant != null && planter.getGrowth(slot) >= 1.0f) {
                if (planter.resetGrowthTo() == 0.0f) {
                    inv.extractItem(slot, 1, false);
                }
                int seedAmount = level.f_46441_.m_188501_() < plant.getExtraSeedChance() ? 2 : 1;
                ItemStack seed = plant.getSeed();
                if (!seed.m_41619_()) {
                    seed.m_41764_(seedAmount);
                    FLHelpers.roundCreationDate(seed);
                    onExtract.accept(seed);
                }
                ItemStack crop = plant.getCrop();
                FLHelpers.roundCreationDate(crop);
                onExtract.accept(crop);
                planter.setGrowth(slot, planter.resetGrowthTo());
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            return InteractionResult.PASS;
        }).orElse(InteractionResult.PASS);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return LARGE_SHAPE;
    }
}

