/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blocks.greenhouse;

import com.eerussianguy.firmalife.common.blockentities.SprinklerBlockEntity;
import com.eerussianguy.firmalife.common.blocks.FLStateProperties;
import com.eerussianguy.firmalife.common.misc.FLParticles;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.dries007.tfc.client.particle.FluidParticleOption;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.common.blocks.soil.HoeOverlayBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;

public class AbstractSprinklerBlock
extends DeviceBlock
implements HoeOverlayBlock {
    public static final BooleanProperty STASIS = FLStateProperties.STASIS;
    private final Predicate<Direction> pipeConnection;
    private final Function<BlockPos, Iterable<BlockPos>> pathMaker;
    private final double dh;
    private final double dy;
    private final Vec3 particleOffset;

    public AbstractSprinklerBlock(ExtendedProperties properties, Predicate<Direction> pipeConnection, Function<BlockPos, Iterable<BlockPos>> pathMaker, double dh, double dy, Vec3 particleOffset) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.NOOP);
        this.pipeConnection = pipeConnection;
        this.pathMaker = pathMaker;
        this.dh = dh;
        this.dy = dy;
        this.particleOffset = particleOffset;
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)STASIS, (Comparable)Boolean.valueOf(false)));
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)STASIS)).booleanValue()) {
            Vec3 part = this.particleOffset(state);
            level.m_7106_((ParticleOptions)new FluidParticleOption((ParticleType)FLParticles.SPRINKLER.get(), (Fluid)Fluids.f_76193_), (double)pos.m_123341_() + part.f_82479_, (double)pos.m_123342_() + part.f_82480_, (double)pos.m_123343_() + part.f_82481_, Mth.m_216263_((RandomSource)random, (double)(-this.dh), (double)this.dh) * 0.1, this.dy * 0.33, Mth.m_216263_((RandomSource)random, (double)(-this.dh), (double)this.dh) * 0.1);
            if (random.m_188501_() < 0.1f) {
                level.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_144128_, SoundSource.BLOCKS, 0.5f + random.m_188501_(), 1.0f, false);
            }
        }
    }

    protected Vec3 particleOffset(BlockState state) {
        return this.particleOffset;
    }

    public Predicate<Direction> getPipeConnection() {
        return this.pipeConnection;
    }

    public Function<BlockPos, Iterable<BlockPos>> getPathMaker() {
        return this.pathMaker;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{STASIS}));
    }

    public void addHoeOverlayInfo(Level level, BlockPos pos, BlockState state, List<Component> text, boolean debug) {
        text.add((Component)Component.m_237115_((String)((Boolean)state.m_61143_((Property)STASIS) != false ? "firmalife.greenhouse.valid_sprinkler" : "firmalife.greenhouse.invalid_sprinkler")));
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SprinklerBlockEntity) {
            SprinklerBlockEntity sprinkler = (SprinklerBlockEntity)blockEntity;
            text.add((Component)Component.m_237115_((String)(sprinkler.isValid() ? "firmalife.greenhouse.valid_generic" : "firmalife.greenhouse.invalid_generic")));
        }
    }
}

