/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blocks;

import com.eerussianguy.firmalife.common.blockentities.VatBlockEntity;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.SealableDeviceBlock;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.ItemHandlerHelper;

public class VatBlock
extends SealableDeviceBlock {
    public static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)VatBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0), (VoxelShape[])new VoxelShape[]{VatBlock.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)12.0, (double)2.0), VatBlock.m_49796_((double)1.0, (double)1.0, (double)14.0, (double)15.0, (double)12.0, (double)15.0), VatBlock.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)2.0, (double)12.0, (double)14.0), VatBlock.m_49796_((double)14.0, (double)1.0, (double)1.0, (double)15.0, (double)12.0, (double)14.0)});
    public static final VoxelShape SEALED_SHAPE = Shapes.m_83124_((VoxelShape)SHAPE, (VoxelShape[])new VoxelShape[]{VatBlock.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0), VatBlock.m_49796_((double)5.0, (double)13.0, (double)5.0, (double)11.0, (double)14.0, (double)11.0)});

    public static void toggleSeal(Level level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof VatBlockEntity) {
            VatBlockEntity vat = (VatBlockEntity)blockEntity;
            Helpers.playSound((Level)level, (BlockPos)pos, (SoundEvent)SoundEvents.f_12447_);
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)SEALED, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)SEALED) == false)));
            vat.markForSync();
        }
    }

    public VatBlock(ExtendedProperties properties) {
        super(properties);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof VatBlockEntity) {
            VatBlockEntity vat = (VatBlockEntity)blockEntity;
            this.handleNeighborChanged(state, level, pos, () -> VatBlock.toggleSeal(level, pos, state), () -> VatBlock.toggleSeal(level, pos, state));
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return (Boolean)state.m_61143_((Property)SEALED) != false ? SEALED_SHAPE : SHAPE;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        VatBlockEntity vat;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof VatBlockEntity && (vat = (VatBlockEntity)blockEntity).isBoiling()) {
            double x = (double)pos.m_123341_() + 0.5;
            double y = pos.m_123342_();
            double z = (double)pos.m_123343_() + 0.5;
            for (int i = 0; i < rand.m_188503_(5) + 4; ++i) {
                level.m_6493_((ParticleOptions)TFCParticles.BUBBLE.get(), false, x + (double)rand.m_188501_() * 0.375 - 0.1875, y + (double)0.751f, z + (double)rand.m_188501_() * 0.375 - 0.1875, 0.0, 0.05, 0.0);
            }
            level.m_6493_((ParticleOptions)TFCParticles.STEAM.get(), false, x, y + 0.8, z, (double)Helpers.triangle((RandomSource)rand), 0.5, (double)Helpers.triangle((RandomSource)rand));
            level.m_7785_(x, y, z, SoundEvents.f_12540_, SoundSource.BLOCKS, 1.0f, rand.m_188501_() * 0.7f + 0.4f, false);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof VatBlockEntity) {
            VatBlockEntity vat = (VatBlockEntity)blockEntity;
            ItemStack stack = player.m_21120_(hand);
            if (!vat.isBoiling()) {
                if (vat.hasOutput()) {
                    if (Helpers.isItem((ItemStack)stack, (TagKey)TFCTags.Items.EMPTY_JAR_WITH_LID)) {
                        stack.m_41774_(1);
                        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)vat.takeOutput());
                        return InteractionResult.m_19078_((boolean)level.f_46443_);
                    }
                    return InteractionResult.FAIL;
                }
                if (stack.m_41619_() && player.m_6144_()) {
                    VatBlock.toggleSeal(level, pos, state);
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
                if (!((Boolean)state.m_61143_((Property)SEALED)).booleanValue()) {
                    if (FluidHelpers.transferBetweenBlockEntityAndItem((ItemStack)stack, (BlockEntity)vat, (Player)player, (InteractionHand)hand)) {
                        vat.markForSync();
                        return InteractionResult.m_19078_((boolean)level.f_46443_);
                    }
                    return vat.getCapability(Capabilities.ITEM).map(inventory -> {
                        if (inventory.isItemValid(0, stack) && !stack.m_41619_()) {
                            player.m_21008_(hand, inventory.insertItem(0, stack, false));
                            vat.markForSync();
                        } else {
                            ItemStack give = inventory.extractItem(0, 64, false);
                            vat.markForSync();
                            if (give.m_41619_()) {
                                return InteractionResult.PASS;
                            }
                            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)give);
                        }
                        return InteractionResult.m_19078_((boolean)level.f_46443_);
                    }).orElse(InteractionResult.PASS);
                }
            }
        }
        return InteractionResult.PASS;
    }
}

