/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blocks;

import com.eerussianguy.firmalife.common.blocks.FLStateProperties;
import com.eerussianguy.firmalife.common.blocks.FourWayDeviceBlock;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TwoByTwoBlock
extends FourWayDeviceBlock {
    public static final IntegerProperty BARREL_PART = FLStateProperties.BARREL_PART;
    public static final VoxelShape[] SHAPE_0 = Helpers.computeHorizontalShapes(dir -> Helpers.rotateShape((Direction)dir, (double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)16.0, (double)14.0));
    public static final VoxelShape[] SHAPE_1 = Helpers.computeHorizontalShapes(dir -> Helpers.rotateShape((Direction)dir, (double)2.0, (double)2.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    public static final VoxelShape[] SHAPE_2 = Helpers.computeHorizontalShapes(dir -> Helpers.rotateShape((Direction)dir, (double)0.0, (double)2.0, (double)0.0, (double)14.0, (double)16.0, (double)14.0));
    public static final VoxelShape[] SHAPE_3 = Helpers.computeHorizontalShapes(dir -> Helpers.rotateShape((Direction)dir, (double)0.0, (double)2.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0));
    public static final VoxelShape[] SHAPE_4 = Helpers.computeHorizontalShapes(dir -> Helpers.rotateShape((Direction)dir, (double)2.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)14.0));
    public static final VoxelShape[] SHAPE_5 = Helpers.computeHorizontalShapes(dir -> Helpers.rotateShape((Direction)dir, (double)2.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0));
    public static final VoxelShape[] SHAPE_6 = Helpers.computeHorizontalShapes(dir -> Helpers.rotateShape((Direction)dir, (double)0.0, (double)0.0, (double)0.0, (double)14.0, (double)14.0, (double)14.0));
    public static final VoxelShape[] SHAPE_7 = Helpers.computeHorizontalShapes(dir -> Helpers.rotateShape((Direction)dir, (double)0.0, (double)0.0, (double)0.0, (double)14.0, (double)14.0, (double)16.0));
    public static final VoxelShape[][] SHAPES = new VoxelShape[][]{SHAPE_0, SHAPE_1, SHAPE_2, SHAPE_3, SHAPE_4, SHAPE_5, SHAPE_6, SHAPE_7};

    private static boolean canPlaceBigBarrel(Level level, BlockPos pos, BlockState state, Direction facing) {
        for (BlockPos testPos : BlockPos.m_121940_((BlockPos)pos, (BlockPos)pos.m_121945_(facing).m_121945_(facing.m_122427_()).m_7494_())) {
            if (level.m_8055_(testPos).m_247087_()) continue;
            return false;
        }
        return true;
    }

    private static boolean canPartSurvive(LevelReader level, BlockPos pos, BlockState state) {
        if (!(state.m_60734_() instanceof TwoByTwoBlock)) {
            return false;
        }
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        Direction cw = facing.m_122427_();
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        int dx = facing.m_122429_();
        int cdx = cw.m_122429_();
        int dz = facing.m_122431_();
        int cdz = cw.m_122431_();
        return switch ((Integer)state.m_61143_((Property)BARREL_PART)) {
            case 0 -> {
                if (TwoByTwoBlock.stageAt(dx, 0, dz, level, pos, cursor, 1) && TwoByTwoBlock.stageAt(cdx, 0, cdz, level, pos, cursor, 2) && TwoByTwoBlock.stageAt(0, 1, 0, level, pos, cursor, 4)) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (TwoByTwoBlock.stageAt(-dx, 0, -dz, level, pos, cursor, 0) && TwoByTwoBlock.stageAt(cdx, 0, cdz, level, pos, cursor, 3) && TwoByTwoBlock.stageAt(0, 1, 0, level, pos, cursor, 5)) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (TwoByTwoBlock.stageAt(dx, 0, dz, level, pos, cursor, 3) && TwoByTwoBlock.stageAt(-cdx, 0, -cdz, level, pos, cursor, 0) && TwoByTwoBlock.stageAt(0, 1, 0, level, pos, cursor, 6)) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (TwoByTwoBlock.stageAt(-dx, 0, -dz, level, pos, cursor, 2) && TwoByTwoBlock.stageAt(-cdx, 0, -cdz, level, pos, cursor, 1) && TwoByTwoBlock.stageAt(0, 1, 0, level, pos, cursor, 7)) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                if (TwoByTwoBlock.stageAt(dx, 0, dz, level, pos, cursor, 5) && TwoByTwoBlock.stageAt(cdx, 0, cdz, level, pos, cursor, 6) && TwoByTwoBlock.stageAt(0, -1, 0, level, pos, cursor, 0)) {
                    yield true;
                }
                yield false;
            }
            case 5 -> {
                if (TwoByTwoBlock.stageAt(-dx, 0, -dz, level, pos, cursor, 4) && TwoByTwoBlock.stageAt(cdx, 0, cdz, level, pos, cursor, 7) && TwoByTwoBlock.stageAt(0, -1, 0, level, pos, cursor, 1)) {
                    yield true;
                }
                yield false;
            }
            case 6 -> {
                if (TwoByTwoBlock.stageAt(dx, 0, dz, level, pos, cursor, 7) && TwoByTwoBlock.stageAt(-cdx, 0, -cdz, level, pos, cursor, 4) && TwoByTwoBlock.stageAt(0, -1, 0, level, pos, cursor, 2)) {
                    yield true;
                }
                yield false;
            }
            case 7 -> {
                if (TwoByTwoBlock.stageAt(-dx, 0, -dz, level, pos, cursor, 6) && TwoByTwoBlock.stageAt(-cdx, 0, -cdz, level, pos, cursor, 5) && TwoByTwoBlock.stageAt(0, -1, 0, level, pos, cursor, 3)) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private static boolean stageAt(int dx, int dy, int dz, LevelReader level, BlockPos origin, BlockPos.MutableBlockPos cursor, int stageWanted) {
        cursor.m_122190_((Vec3i)origin).m_122184_(dx, dy, dz);
        BlockState state = level.m_8055_((BlockPos)cursor);
        return state.m_60734_() instanceof TwoByTwoBlock && (Integer)state.m_61143_((Property)BARREL_PART) == stageWanted;
    }

    public static BlockPos findZeroPos(Level level, BlockPos pos, BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        int part = (Integer)state.m_61143_((Property)BARREL_PART);
        if (part > 3) {
            pos = pos.m_7495_();
            part -= 4;
        }
        return switch (part) {
            case 1 -> pos.m_121945_(facing.m_122424_());
            case 2 -> pos.m_121945_(facing.m_122428_());
            case 3 -> pos.m_121945_(facing.m_122428_()).m_121945_(facing.m_122424_());
            default -> pos;
        };
    }

    public TwoByTwoBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)BARREL_PART, (Comparable)Integer.valueOf(0))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockPos zero = TwoByTwoBlock.findZeroPos(level, pos, state);
        return this.useCoreBlock(level.m_8055_(zero), level, zero, player, hand, hit.m_82430_(zero));
    }

    public InteractionResult useCoreBlock(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return (Integer)state.m_61143_((Property)BARREL_PART) == 0 ? super.m_142194_(pos, state) : null;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES[(Integer)state.m_61143_((Property)BARREL_PART)][((Direction)state.m_61143_((Property)FACING)).m_122416_()];
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return (Integer)state.m_61143_((Property)BARREL_PART) == 0 || TwoByTwoBlock.canPartSurvive(level, pos, state);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        return TwoByTwoBlock.canPartSurvive((LevelReader)level, pos, state) ? state : Blocks.f_50016_.m_49966_();
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{BARREL_PART}));
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return TwoByTwoBlock.canPlaceBigBarrel(ctx.m_43725_(), ctx.m_8083_(), this.m_49966_(), ctx.m_8125_()) ? (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_()) : null;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        Direction forward = placer != null ? placer.m_6350_() : Direction.NORTH;
        Direction back = forward.m_122424_();
        Direction right = forward.m_122427_();
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
        state = (BlockState)state.m_61124_((Property)FACING, (Comparable)forward);
        cursor.m_122173_(forward);
        level.m_46597_((BlockPos)cursor, (BlockState)state.m_61124_((Property)BARREL_PART, (Comparable)Integer.valueOf(1)));
        cursor.m_122173_(right).m_122173_(back);
        level.m_46597_((BlockPos)cursor, (BlockState)state.m_61124_((Property)BARREL_PART, (Comparable)Integer.valueOf(2)));
        cursor.m_122173_(forward);
        level.m_46597_((BlockPos)cursor, (BlockState)state.m_61124_((Property)BARREL_PART, (Comparable)Integer.valueOf(3)));
        cursor.m_122190_((Vec3i)pos).m_122184_(0, 1, 0);
        level.m_46597_((BlockPos)cursor, (BlockState)state.m_61124_((Property)BARREL_PART, (Comparable)Integer.valueOf(4)));
        cursor.m_122173_(forward);
        level.m_46597_((BlockPos)cursor, (BlockState)state.m_61124_((Property)BARREL_PART, (Comparable)Integer.valueOf(5)));
        cursor.m_122173_(right).m_122173_(back);
        level.m_46597_((BlockPos)cursor, (BlockState)state.m_61124_((Property)BARREL_PART, (Comparable)Integer.valueOf(6)));
        cursor.m_122173_(forward);
        level.m_46597_((BlockPos)cursor, (BlockState)state.m_61124_((Property)BARREL_PART, (Comparable)Integer.valueOf(7)));
    }
}

