/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blocks;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.items.FLFoodTraits;
import com.eerussianguy.firmalife.config.FLConfig;
import java.util.List;
import java.util.function.Supplier;
import net.dries007.tfc.common.blockentities.FirepitBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class StringBlock
extends DeviceBlock {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;
    private static final VoxelShape SHAPE_X = StringBlock.m_49796_((double)0.0, (double)8.0, (double)7.0, (double)16.0, (double)10.0, (double)9.0);
    private static final VoxelShape SHAPE_Z = StringBlock.m_49796_((double)7.0, (double)8.0, (double)0.0, (double)9.0, (double)10.0, (double)16.0);
    private final Supplier<? extends Item> item;

    @Nullable
    public static FirepitBlockEntity findFirepit(Level level, BlockPos pos) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        mutable.m_122190_((Vec3i)pos);
        int range = (Integer)FLConfig.SERVER.smokingFirepitRange.get();
        for (int i = 0; i < range; ++i) {
            FirepitBlockEntity firepit;
            mutable.m_122184_(0, -1, 0);
            BlockState stateAt = level.m_8055_((BlockPos)mutable);
            if (stateAt.m_60795_() || StringBlock.isStringBlock(stateAt)) continue;
            BlockEntity blockEntity = level.m_7702_((BlockPos)mutable);
            return blockEntity instanceof FirepitBlockEntity ? (firepit = (FirepitBlockEntity)blockEntity) : null;
        }
        return null;
    }

    public StringBlock(ExtendedProperties properties, Supplier<? extends Item> item) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
        this.item = item;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        level.m_141902_(pos, (BlockEntityType)FLBlockEntities.STRING.get()).ifPresent(string -> {
            ItemStack stack = string.readStack();
            if (!stack.m_41619_()) {
                stack.getCapability(FoodCapability.CAPABILITY).ifPresent(food -> {
                    List traits = food.getTraits();
                    if (traits.contains(FLFoodTraits.SMOKED) || traits.contains(FLFoodTraits.RANCID_SMOKED)) {
                        double x = (double)pos.m_123341_() + 0.5;
                        double y = (double)pos.m_123342_() + 0.55;
                        double z = (double)pos.m_123343_() + 0.5;
                        for (int i = 0; i < 4; ++i) {
                            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, (double)(Helpers.triangle((RandomSource)random) / 10.0f), (double)(random.m_188501_() / 5.0f), (double)(Helpers.triangle((RandomSource)random) / 10.0f));
                        }
                    }
                });
            }
        });
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        for (Direction d : Direction.Plane.HORIZONTAL) {
            if (this.getHorizontalDistance(d, (LevelReader)level, pos) <= 0 || !this.isWallSupport((LevelReader)level, pos.m_121945_(d.m_122424_()), level.m_8055_(pos.m_121945_(d.m_122424_())), d.m_122424_())) continue;
            return (BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)d.m_122434_());
        }
        return null;
    }

    private boolean isWallSupport(LevelReader level, BlockPos pos, BlockState state, Direction direction) {
        return state.m_60783_((BlockGetter)level, pos, direction.m_122424_());
    }

    private static boolean isStringBlock(BlockState state) {
        return state.m_60734_() instanceof StringBlock;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (facing.m_122434_() == state.m_61143_(AXIS) && !StringBlock.isStringBlock(facingState) && !facingState.m_60783_((BlockGetter)level, facingPos, facing)) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        Direction direction = null;
        for (Direction checkDir : Direction.Plane.HORIZONTAL) {
            if (checkDir.m_122434_() != state.m_61143_(AXIS)) continue;
            mutablePos.m_122190_((Vec3i)pos).m_122173_(checkDir);
            if (!this.isWallSupport((LevelReader)level, (BlockPos)mutablePos, level.m_8055_((BlockPos)mutablePos), checkDir)) continue;
            direction = checkDir.m_122424_();
            break;
        }
        if (direction == null) {
            return;
        }
        int distance = this.getHorizontalDistance(direction, (LevelReader)level, pos);
        if (distance == 0 || stack.m_41613_() < distance) {
            level.m_46961_(pos, true);
        } else if (distance > 0) {
            stack.m_41774_(distance - 1);
            for (int i = 1; i < distance; ++i) {
                mutablePos.m_122190_((Vec3i)pos).m_122175_(direction, i);
                BlockState stateAt = level.m_8055_((BlockPos)mutablePos);
                if (!stateAt.m_60795_()) continue;
                level.m_7731_((BlockPos)mutablePos, (BlockState)state.m_61124_(AXIS, (Comparable)direction.m_122434_()), 2);
                mutablePos.m_122173_(Direction.DOWN);
                level.m_186469_((BlockPos)mutablePos, level.m_6425_((BlockPos)mutablePos).m_76152_(), 3);
            }
        }
    }

    private int getHorizontalDistance(Direction direction, LevelReader level, BlockPos pos) {
        int distance = -1;
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 5; ++i) {
            cursor.m_122190_((Vec3i)pos).m_122175_(direction, i);
            BlockState state = level.m_8055_((BlockPos)cursor);
            if (!(StringBlock.isStringBlock(state) || state.m_60795_() || this.isWallSupport(level, (BlockPos)cursor, state, direction))) {
                return 0;
            }
            cursor.m_122175_(direction, 1);
            state = level.m_8055_((BlockPos)cursor);
            if (!this.isWallSupport(level, (BlockPos)cursor, state, direction)) continue;
            distance = i;
            break;
        }
        return distance == -1 ? 0 : distance + 1;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return state.m_61143_(AXIS) == Direction.Axis.X ? SHAPE_X : SHAPE_Z;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return this.getItem();
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        return FLHelpers.consumeInventory(level, pos, FLBlockEntities.STRING, (string, inv) -> {
            ItemStack item = player.m_21120_(hand);
            if (item.m_41619_()) {
                ItemStack stack = inv.extractItem(0, player.m_6144_() ? Integer.MAX_VALUE : 1, false);
                if (stack.m_41619_()) {
                    return InteractionResult.PASS;
                }
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
                string.resetCounter();
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
            if (inv.isItemValid(0, item)) {
                string.resetCounter();
                player.m_21008_(hand, FLHelpers.mergeInsertStack(inv, 0, item));
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
            return InteractionResult.PASS;
        });
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return switch (rot) {
            case Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90 -> {
                switch ((Direction.Axis)state.m_61143_(AXIS)) {
                    case Z: {
                        yield (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        yield (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                yield state;
            }
            default -> state;
        };
    }

    public ItemStack getItem() {
        return new ItemStack((ItemLike)this.item.get());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{AXIS}));
    }
}

