/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blocks;

import com.eerussianguy.firmalife.common.blockentities.StovetopGrillBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.stream.Collectors;
import net.dries007.tfc.client.IHighlightHandler;
import net.dries007.tfc.common.TFCDamageSources;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.BottomSupportedDeviceBlock;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class StovetopGrillBlock
extends BottomSupportedDeviceBlock
implements IHighlightHandler {
    private static final Map<Integer, VoxelShape> SLOT_RENDER_SHAPES = Map.of(4, Shapes.m_83048_((double)0.4, (double)0.0, (double)0.4, (double)0.6, (double)0.22, (double)0.6), 3, Shapes.m_83048_((double)0.6, (double)0.0, (double)0.6, (double)0.8, (double)0.22, (double)0.8), 2, Shapes.m_83048_((double)0.6, (double)0.0, (double)0.2, (double)0.8, (double)0.22, (double)0.4), 1, Shapes.m_83048_((double)0.2, (double)0.0, (double)0.6, (double)0.4, (double)0.22, (double)0.8), 0, Shapes.m_83048_((double)0.2, (double)0.0, (double)0.2, (double)0.4, (double)0.22, (double)0.4));
    private static final Map<Integer, AABB> SLOT_BOUNDS = SLOT_RENDER_SHAPES.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((VoxelShape)entry.getValue()).m_83215_().m_82400_((double)0.01f)));
    public static final Map<Integer, Vec3> SLOT_CENTERS = SLOT_BOUNDS.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((AABB)entry.getValue()).m_82399_().m_82542_(1.0, 0.0, 1.0).m_82520_(0.0, 0.125, 0.0)));
    public static final VoxelShape GRILL_SHAPE = StovetopGrillBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0);

    public static int getSlotForSelection(BlockHitResult result) {
        Vec3 location = result.m_82450_();
        BlockPos pos = result.m_82425_();
        for (Map.Entry<Integer, AABB> entry : SLOT_BOUNDS.entrySet()) {
            if (!entry.getValue().m_82338_(pos).m_82390_(location)) continue;
            return entry.getKey();
        }
        return -1;
    }

    public StovetopGrillBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP, GRILL_SHAPE);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        IItemHandler inv;
        StovetopGrillBlockEntity grill;
        super.m_214162_(state, level, pos, rand);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof StovetopGrillBlockEntity && (grill = (StovetopGrillBlockEntity)blockEntity).getTemperature() > 0.0f && (inv = (IItemHandler)Helpers.getCapability((ICapabilityProvider)grill, (Capability)Capabilities.ITEM)) != null) {
            SLOT_CENTERS.forEach((slot, vec) -> {
                if (!inv.getStackInSlot(slot.intValue()).m_41619_() && rand.m_188501_() < 0.4f) {
                    double x = vec.f_82479_ + (double)pos.m_123341_();
                    double y = vec.f_82480_ + (double)pos.m_123342_();
                    double z = vec.f_82481_ + (double)pos.m_123343_();
                    level.m_7785_(x, y, z, SoundEvents.f_11907_, SoundSource.BLOCKS, 0.25f, rand.m_188501_() * 0.7f + 0.4f, false);
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, 0.0, 0.0);
                }
            });
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof StovetopGrillBlockEntity) {
            ItemStack current;
            StovetopGrillBlockEntity grill = (StovetopGrillBlockEntity)blockEntity;
            ItemStack stack = player.m_21120_(hand);
            IItemHandler inv = (IItemHandler)Helpers.getCapability((ICapabilityProvider)grill, (Capability)Capabilities.ITEM);
            int slot = StovetopGrillBlock.getSlotForSelection(result);
            ItemStack itemStack = current = slot == -1 || inv == null ? ItemStack.f_41583_ : inv.getStackInSlot(slot);
            if (!stack.m_41619_() && inv != null && slot != -1 && current.m_41619_() && inv.isItemValid(slot, stack)) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)inv.insertItem(slot, stack.m_41620_(1), false));
                grill.markForSync();
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (stack.m_41619_() && slot != -1 && inv != null && !current.m_41619_()) {
                if (!inv.isItemValid(slot, current) || player.m_6144_()) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)inv.extractItem(slot, 64, false));
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
            } else {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    Helpers.openScreen((ServerPlayer)serverPlayer, (MenuProvider)grill, (BlockPos)pos);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        StovetopGrillBlockEntity grill;
        BlockEntity blockEntity;
        if (!entity.m_5825_() && entity instanceof LivingEntity && !EnchantmentHelper.m_44938_((LivingEntity)((LivingEntity)entity)) && (blockEntity = level.m_7702_(pos)) instanceof StovetopGrillBlockEntity && (grill = (StovetopGrillBlockEntity)blockEntity).getTemperature() > 0.0f) {
            TFCDamageSources.grill((Entity)entity, (float)1.0f);
        }
        super.m_141947_(level, pos, state, entity);
    }

    public boolean drawHighlight(Level level, BlockPos pos, Player player, BlockHitResult rayTrace, PoseStack stack, MultiBufferSource buffers, Vec3 rendererPosition) {
        int slot = StovetopGrillBlock.getSlotForSelection(rayTrace);
        if (slot != -1) {
            IHighlightHandler.drawBox((PoseStack)stack, (VoxelShape)SLOT_RENDER_SHAPES.get(slot), (MultiBufferSource)buffers, (BlockPos)pos, (Vec3)rendererPosition, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            return true;
        }
        return false;
    }
}

