/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blocks;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.blockentities.StompingBarrelBlockEntity;
import com.eerussianguy.firmalife.common.recipes.StompingRecipe;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.ItemHandlerHelper;

public class StompingBarrelBlock
extends DeviceBlock {
    public static final VoxelShape SHAPE = StompingBarrelBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)14.0, (double)8.0, (double)14.0);

    public StompingBarrelBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        return FLHelpers.consumeInventory(level, pos, FLBlockEntities.STOMPING_BARREL, (barrel, inv) -> {
            ItemStack held = player.m_21120_(hand);
            ItemStack current = inv.getStackInSlot(0);
            if (StompingRecipe.getRecipe(level, new ItemStackInventory(held)) != null) {
                if ((ItemStack.m_41656_((ItemStack)current, (ItemStack)held) || current.m_41619_()) && current.m_41613_() < 16) {
                    Helpers.playSound((Level)level, (BlockPos)pos, (SoundEvent)SoundEvents.f_12470_);
                    ItemStack leftover = inv.insertItem(0, held.m_41620_(16), false);
                    if (!leftover.m_41619_()) {
                        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)leftover);
                    }
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
            } else if (held.m_41619_() && !current.m_41619_()) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)inv.extractItem(0, 64, false));
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            return InteractionResult.PASS;
        });
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float distance) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof StompingBarrelBlockEntity) {
            StompingBarrelBlockEntity barrel = (StompingBarrelBlockEntity)blockEntity;
            barrel.stomp(entity);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }
}

