/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blocks;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.FLTags;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.blockentities.OvenTopBlockEntity;
import com.eerussianguy.firmalife.common.blocks.AbstractOvenBlock;
import com.eerussianguy.firmalife.common.blocks.OvenBottomBlock;
import com.eerussianguy.firmalife.common.items.FinishItem;
import com.eerussianguy.firmalife.common.misc.FLDamageSources;
import com.eerussianguy.firmalife.config.FLConfig;
import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class OvenTopBlock
extends AbstractOvenBlock {
    public static final VoxelShape[] SHAPES = Helpers.computeHorizontalShapes(d -> Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Helpers.rotateShape((Direction)d, (double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)11.0, (double)15.0), (BooleanOp)BooleanOp.f_82685_));

    public OvenTopBlock(ExtendedProperties properties, @Nullable Supplier<? extends Block> curedBlock) {
        super(properties, curedBlock);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)HAS_CHIMNEY, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES[((Direction)state.m_61143_((Property)FACING)).m_122416_()];
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack item = player.m_21120_(hand);
        if (item.m_41720_() instanceof FinishItem) {
            return InteractionResult.PASS;
        }
        return FLHelpers.consumeInventory(level, pos, FLBlockEntities.OVEN_TOP, (oven, inv) -> {
            boolean peel = Helpers.isItem((ItemStack)item, FLTags.Items.USABLE_ON_OVEN);
            if (peel || item.m_41619_() && player.m_6144_()) {
                if (!peel && oven.getTemperature() > 100.0f && ((Boolean)FLConfig.SERVER.ovenRequirePeel.get()).booleanValue() && !player.m_7500_()) {
                    FLDamageSources.oven((Entity)player, 0.5f);
                }
                return FLHelpers.takeOneAny(level, 0, 3, inv, player);
            }
            if (!item.m_41619_()) {
                return FLHelpers.insertOneAny(level, item, 0, 3, inv, player);
            }
            return InteractionResult.PASS;
        });
    }

    public int m_7753_(BlockState state, BlockGetter level, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_60734_() instanceof OvenBottomBlock ? 0 : super.m_7753_(state, level, pos);
    }

    @Override
    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (level.m_141902_(pos, (BlockEntityType)FLBlockEntities.OVEN_TOP.get()).map(oven -> oven.getTemperature() > 0.0f).orElse(false).booleanValue()) {
            super.m_214162_(state, level, pos, random);
        }
    }

    @Override
    public void cure(Level level, BlockState state, BlockPos pos) {
        if (this.getCured() != null) {
            OvenTopBlockEntity.cure(level, state, this.getCured().m_49966_(), pos);
        }
    }
}

