/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blocks;

import com.eerussianguy.firmalife.common.blocks.FLBlocks;
import com.eerussianguy.firmalife.common.capabilities.wine.WineType;
import com.eerussianguy.firmalife.common.items.FLItems;
import com.eerussianguy.firmalife.common.util.ExtraFluid;
import com.eerussianguy.firmalife.common.util.FLMetal;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.dries007.tfc.common.fluids.ExtendedFluidType;
import net.dries007.tfc.common.fluids.FluidRegistryObject;
import net.dries007.tfc.common.fluids.FluidTypeClientProperties;
import net.dries007.tfc.common.fluids.MixingFluid;
import net.dries007.tfc.common.fluids.MoltenFluid;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.registry.RegistrationHelpers;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class FLFluids {
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"firmalife");
    public static final Map<FLMetal, FluidRegistryObject<ForgeFlowingFluid>> METALS = Helpers.mapOfKeys(FLMetal.class, metal -> FLFluids.register("metal/" + metal.m_7912_(), properties -> properties.block((Supplier)FLBlocks.METAL_FLUIDS.get(metal)).bucket((Supplier)FLItems.METAL_FLUID_BUCKETS.get(metal)).explosionResistance(100.0f), FLFluids.lavaLike().descriptionId("fluid.firmalife.metal." + metal.m_7912_()).canConvertToSource(false), new FluidTypeClientProperties(0xFF000000 | metal.getColor(), TFCFluids.MOLTEN_STILL, TFCFluids.MOLTEN_FLOW, null, null), MoltenFluid.Source::new, MoltenFluid.Flowing::new));
    public static final Map<ExtraFluid, FluidRegistryObject<ForgeFlowingFluid>> EXTRA_FLUIDS = Helpers.mapOfKeys(ExtraFluid.class, fluid -> FLFluids.register(fluid.m_7912_(), properties -> properties.block((Supplier)FLBlocks.EXTRA_FLUIDS.get(fluid)).bucket((Supplier)FLItems.EXTRA_FLUID_BUCKETS.get(fluid)), FLFluids.waterLike().descriptionId("fluid.firmalife." + fluid.m_7912_()).canConvertToSource(false), new FluidTypeClientProperties(fluid.getColor(), TFCFluids.WATER_STILL, TFCFluids.WATER_FLOW, TFCFluids.WATER_OVERLAY, null), MixingFluid.Source::new, MixingFluid.Flowing::new));
    public static final Map<WineType, FluidRegistryObject<ForgeFlowingFluid>> WINE_FLUIDS = Helpers.mapOfKeys(WineType.class, fluid -> FLFluids.register(fluid.m_7912_(), properties -> properties.block((Supplier)FLBlocks.WINE_FLUIDS.get(fluid)).bucket((Supplier)FLItems.WINE_FLUID_BUCKETS.get(fluid)), FLFluids.waterLike().descriptionId("fluid.firmalife." + fluid.m_7912_()).canConvertToSource(false), new FluidTypeClientProperties(fluid.getColor(), TFCFluids.WATER_STILL, TFCFluids.WATER_FLOW, TFCFluids.WATER_OVERLAY, null), MixingFluid.Source::new, MixingFluid.Flowing::new));

    private static FluidType.Properties lavaLike() {
        return FluidType.Properties.create().adjacentPathType(BlockPathTypes.LAVA).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11780_).lightLevel(15).density(3000).viscosity(6000).temperature(1300).canConvertToSource(false).canDrown(false).canExtinguish(false).canHydrate(false).canPushEntity(false).canSwim(false).supportsBoating(false);
    }

    private static FluidType.Properties waterLike() {
        return FluidType.Properties.create().adjacentPathType(BlockPathTypes.WATER).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_).canConvertToSource(true).canDrown(true).canExtinguish(true).canHydrate(false).canPushEntity(true).canSwim(true).supportsBoating(true);
    }

    private static <F extends FlowingFluid> FluidRegistryObject<F> register(String name, Consumer<ForgeFlowingFluid.Properties> builder, FluidType.Properties typeProperties, FluidTypeClientProperties clientProperties, Function<ForgeFlowingFluid.Properties, F> sourceFactory, Function<ForgeFlowingFluid.Properties, F> flowingFactory) {
        int index = name.lastIndexOf(47);
        String flowingName = index == -1 ? "flowing_" + name : name.substring(0, index) + "/flowing_" + name.substring(index + 1);
        return RegistrationHelpers.registerFluid((DeferredRegister)TFCFluids.FLUID_TYPES, FLUIDS, (String)name, (String)name, (String)flowingName, builder, () -> new ExtendedFluidType(typeProperties, clientProperties), sourceFactory, flowingFactory);
    }
}

