/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blocks;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blockentities.DryingMatBlockEntity;
import com.eerussianguy.firmalife.common.blockentities.SimpleItemRecipeBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.BottomSupportedDeviceBlock;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DryingMatBlock
extends BottomSupportedDeviceBlock {
    private static final VoxelShape SHAPE = DryingMatBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);

    public static InteractionResult use(Level level, BlockPos pos, Player player, InteractionHand hand) {
        ItemStack held = player.m_21120_(hand);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SimpleItemRecipeBlockEntity) {
            SimpleItemRecipeBlockEntity mat = (SimpleItemRecipeBlockEntity)blockEntity;
            InteractionResult result = mat.getCapability(Capabilities.ITEM).map(inv -> {
                if (inv.getStackInSlot(0).m_41619_() && !held.m_41619_()) {
                    InteractionResult res = FLHelpers.insertOne(level, held, 0, inv, player);
                    if (res.m_19077_()) {
                        mat.markForSync();
                        mat.start();
                    }
                    return res;
                }
                if (!inv.getStackInSlot(0).m_41619_() && held.m_41619_() && player.m_6144_()) {
                    mat.markForSync();
                    FLHelpers.roundCreationDate(inv.getStackInSlot(0));
                    return FLHelpers.takeOne(level, 0, inv, player);
                }
                return InteractionResult.PASS;
            }).orElse(InteractionResult.PASS);
            mat.markForSync();
            return result;
        }
        return InteractionResult.PASS;
    }

    public DryingMatBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP, SHAPE);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        BlockEntity blockEntity;
        if (facingState.m_60734_() instanceof PistonHeadBlock && facingState.m_61143_((Property)PistonHeadBlock.f_52588_) == facing.m_122424_() && facing.m_122434_().m_122479_() && (blockEntity = level.m_7702_(currentPos)) instanceof DryingMatBlockEntity) {
            DryingMatBlockEntity mat = (DryingMatBlockEntity)blockEntity;
            mat.ejectItem(facing.m_122424_());
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        return DryingMatBlock.use(level, pos, player, hand);
    }
}

