/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blockentities;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blockentities.ApplianceBlockEntity;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.container.StovetopGrillContainer;
import java.util.function.Predicate;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.capabilities.PartialItemHandler;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodTrait;
import net.dries007.tfc.common.capabilities.food.FoodTraits;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.capabilities.heat.IHeat;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.Nullable;

public class StovetopGrillBlockEntity
extends ApplianceBlockEntity<GrillInventory> {
    public static final int SLOTS = 5;
    private final HeatingRecipe[] cachedRecipes;
    private boolean needsRecipeUpdate = true;

    public static void serverTick(Level level, BlockPos pos, BlockState state, StovetopGrillBlockEntity grill) {
        grill.checkForLastTickSync();
        grill.checkForCalendarUpdate();
        if (grill.needsRecipeUpdate) {
            grill.updateCachedRecipe();
        }
        grill.tickTemperature();
        grill.handleCooking();
    }

    public StovetopGrillBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FLBlockEntities.STOVETOP_GRILL.get(), pos, state, GrillInventory::new, FLHelpers.blockEntityName("stovetop_grill"));
        this.sidedInventory.on((Object)new PartialItemHandler(this.inventory).insert(new int[]{0, 1, 2, 3, 4}), new Direction[]{Direction.UP}).on((Object)new PartialItemHandler(this.inventory).extract(new int[]{0, 1, 2, 3, 4}), (Predicate)Direction.Plane.HORIZONTAL);
        this.cachedRecipes = new HeatingRecipe[5];
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        return StovetopGrillContainer.create(this, inventory, containerId);
    }

    public int getSlotStackLimit(int slot) {
        return 1;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return Helpers.mightHaveCapability((ItemStack)stack, (Capability)HeatCapability.CAPABILITY);
    }

    @Override
    public void loadAdditional(CompoundTag nbt) {
        super.loadAdditional(nbt);
        this.needsRecipeUpdate = true;
    }

    public void setAndUpdateSlots(int slot) {
        super.setAndUpdateSlots(slot);
        this.needsRecipeUpdate = true;
    }

    protected void handleCooking() {
        assert (this.f_58857_ != null);
        int slot = 0;
        while (slot < 5) {
            ItemStack inputStack = ((GrillInventory)this.inventory).getStackInSlot(slot);
            int finalSlot = slot++;
            inputStack.getCapability(HeatCapability.CAPABILITY, null).ifPresent(cap -> {
                HeatCapability.addTemp((IHeat)cap, (float)this.temperature);
                HeatingRecipe recipe = this.cachedRecipes[finalSlot];
                if (recipe != null && recipe.isValidTemperature(cap.getTemperature())) {
                    ItemStack output = recipe.assemble(new ItemStackInventory(inputStack), this.f_58857_.m_9598_());
                    FoodCapability.applyTrait((ItemStack)output, (FoodTrait)FoodTraits.WOOD_GRILLED);
                    ((GrillInventory)this.inventory).setStackInSlot(finalSlot, output);
                    this.markForSync();
                }
            });
        }
    }

    protected void updateCachedRecipe() {
        assert (this.f_58857_ != null);
        for (int slot = 0; slot < 5; ++slot) {
            ItemStack stack = ((GrillInventory)this.inventory).getStackInSlot(slot);
            this.cachedRecipes[slot] = stack.m_41619_() ? null : HeatingRecipe.getRecipe((ItemStackInventory)new ItemStackInventory(stack));
        }
    }

    public static class GrillInventory
    extends ApplianceBlockEntity.ApplianceInventory {
        public GrillInventory(InventoryBlockEntity<?> entity) {
            super(entity, 5);
        }
    }
}

