/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blockentities;

import com.eerussianguy.firmalife.common.blockentities.ClimateReceiver;
import com.eerussianguy.firmalife.common.blockentities.ClimateType;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.blocks.FLBlocks;
import com.eerussianguy.firmalife.common.blocks.greenhouse.AbstractSprinklerBlock;
import com.eerussianguy.firmalife.common.blocks.greenhouse.GreenhousePortBlock;
import com.eerussianguy.firmalife.common.blocks.greenhouse.PumpingStationBlock;
import com.eerussianguy.firmalife.common.blocks.greenhouse.SprinklerBlock;
import com.eerussianguy.firmalife.common.blocks.greenhouse.SprinklerPipeBlock;
import com.eerussianguy.firmalife.config.FLConfig;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.Set;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.TFCBlockEntity;
import net.dries007.tfc.common.blocks.DirectionPropertyBlock;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.FluidTankCallback;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class SprinklerBlockEntity
extends TFCBlockEntity
implements FluidTankCallback,
ClimateReceiver {
    private static final int MAX_COST = 32;
    private boolean valid = false;

    public static void serverTick(Level level, BlockPos pos, BlockState state, SprinklerBlockEntity sprinkler) {
        Block block;
        if (level.m_46467_() % (long)(80 + pos.m_123343_() % 4) == 0L && sprinkler.valid && (block = state.m_60734_()) instanceof AbstractSprinklerBlock) {
            boolean valid;
            AbstractSprinklerBlock block2 = (AbstractSprinklerBlock)block;
            Fluid fluid = SprinklerBlockEntity.searchForFluid(level, pos, block2 instanceof SprinklerBlock ? Direction.UP : Direction.DOWN, true);
            boolean bl = valid = fluid != null;
            if (valid) {
                for (BlockPos waterPos : block2.getPathMaker().apply(pos)) {
                    ClimateReceiver receiver = ClimateReceiver.get(level, waterPos);
                    if (receiver == null) continue;
                    receiver.addWater(0.01f, waterPos.m_123342_() > pos.m_123342_() ? Direction.UP : Direction.DOWN);
                }
            }
            if ((Boolean)state.m_61143_((Property)AbstractSprinklerBlock.STASIS) != valid) {
                level.m_46597_(pos, (BlockState)state.m_61122_((Property)AbstractSprinklerBlock.STASIS));
            }
        }
    }

    @Nullable
    public static Fluid searchForFluid(Level level, BlockPos start, Direction pipeDirection, boolean drain) {
        if (!((Boolean)FLConfig.SERVER.usePipesForSprinklers.get()).booleanValue()) {
            FluidStack drained;
            Fluid fluid;
            IFluidHandler cap;
            BlockPos checkPos = start.m_121945_(pipeDirection);
            BlockEntity be = level.m_7702_(checkPos);
            if (be != null && (cap = (IFluidHandler)be.getCapability(Capabilities.FLUID, pipeDirection.m_122424_()).resolve().orElse(null)) != null && (fluid = cap.getFluidInTank(0).getFluid()) != Fluids.f_76191_ && Helpers.isFluid((Fluid)fluid, (TagKey)TFCTags.Fluids.ANY_FRESH_WATER) && drain && !(drained = cap.drain(1, IFluidHandler.FluidAction.EXECUTE)).isEmpty()) {
                return drained.getFluid();
            }
            return null;
        }
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        ArrayDeque<Path> queue = new ArrayDeque<Path>();
        ObjectOpenHashSet seen = new ObjectOpenHashSet(64);
        BlockPos pipePos = start.m_121945_(pipeDirection);
        BlockState pipeState = level.m_8055_(pipePos);
        if (!SprinklerBlockEntity.isPipe(pipeState)) {
            return null;
        }
        SprinklerBlockEntity.enqueueConnections(cursor, level, new Path(pipeState, pipePos, 1), (Set<BlockPos>)seen, queue);
        while (!queue.isEmpty()) {
            Path prev = (Path)queue.poll();
            Fluid fluid = SprinklerBlockEntity.enqueueConnections(cursor, level, prev, (Set<BlockPos>)seen, queue);
            if (fluid == null) continue;
            return fluid;
        }
        return null;
    }

    @Nullable
    private static Fluid enqueueConnections(BlockPos.MutableBlockPos cursor, Level level, Path prev, Set<BlockPos> seen, Queue<Path> queue) {
        for (Direction direction : Helpers.DIRECTIONS) {
            cursor.m_122159_((Vec3i)prev.pos, direction);
            if (seen.contains(cursor)) continue;
            BlockState stateAdj = level.m_8055_((BlockPos)cursor);
            if (!(!SprinklerBlockEntity.isPipe(stateAdj) || prev.state.m_60734_() instanceof SprinklerPipeBlock && stateAdj.m_60734_() instanceof SprinklerPipeBlock && stateAdj.m_60734_() != prev.state.m_60734_())) {
                if (prev.cost >= 32) continue;
                BlockPos posAdj = cursor.m_7949_();
                queue.add(new Path(stateAdj, posAdj, 1 + prev.cost));
                seen.add(posAdj);
                continue;
            }
            if (!direction.m_122434_().m_122479_() || !SprinklerBlockEntity.isPipeInDirection(prev.state, direction) || stateAdj.m_60734_() != FLBlocks.PUMPING_STATION.get() && stateAdj.m_60734_() != FLBlocks.IRRIGATION_TANK.get() || !PumpingStationBlock.hasConnection((LevelAccessor)level, (BlockPos)cursor)) continue;
            return stateAdj.m_60819_().m_76152_();
        }
        return null;
    }

    private static boolean isPipe(BlockState state) {
        return state.m_60734_() instanceof SprinklerPipeBlock || state.m_60734_() instanceof GreenhousePortBlock;
    }

    private static boolean isPipeInDirection(BlockState state, Direction direction) {
        return state.m_60734_() instanceof SprinklerPipeBlock ? (Boolean)state.m_61143_((Property)DirectionPropertyBlock.getProperty((Direction)direction)) : state.m_61143_(GreenhousePortBlock.AXIS) == direction.m_122434_();
    }

    public SprinklerBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)FLBlockEntities.SPRINKLER.get(), pos, state);
    }

    public SprinklerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public boolean isActive() {
        return this.valid;
    }

    public void loadAdditional(CompoundTag tag) {
        this.valid = tag.m_128471_("valid");
        super.loadAdditional(tag);
    }

    public void m_183515_(CompoundTag tag) {
        tag.m_128379_("valid", this.valid);
        super.m_183515_(tag);
    }

    @Override
    public void setValid(Level level, BlockPos pos, boolean valid, int tier, ClimateType climate) {
        if (valid != this.valid) {
            this.markForSync();
        }
        this.valid = valid;
    }

    public boolean isValid() {
        return this.valid;
    }

    private record Path(BlockState state, BlockPos pos, int cost) {
    }
}

