/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blockentities;

import java.util.function.Supplier;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.recipes.SimpleItemRecipe;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public abstract class SimpleItemRecipeBlockEntity<T extends SimpleItemRecipe>
extends InventoryBlockEntity<ItemStackHandler> {
    private final Supplier<Integer> duration;
    protected long startTick;
    @Nullable
    protected T cachedRecipe;
    protected boolean needsRecipeUpdate = false;

    public SimpleItemRecipeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, Component defaultName, Supplier<Integer> duration) {
        super(type, pos, state, SimpleItemRecipeBlockEntity.defaultInventory((int)1), defaultName);
        this.duration = duration;
    }

    public void loadAdditional(CompoundTag nbt) {
        this.startTick = nbt.m_128454_("startTick");
        super.loadAdditional(nbt);
        this.needsRecipeUpdate = true;
    }

    public void m_183515_(CompoundTag nbt) {
        nbt.m_128356_("startTick", this.startTick);
        super.m_183515_(nbt);
    }

    public void setAndUpdateSlots(int slot) {
        super.setAndUpdateSlots(slot);
        this.needsRecipeUpdate = true;
    }

    public int getSlotStackLimit(int slot) {
        return 1;
    }

    abstract void updateCache();

    @Nullable
    public T getCachedRecipe() {
        if (this.cachedRecipe == null && this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.updateCache();
        }
        return this.cachedRecipe;
    }

    public long getTicksLeft() {
        assert (this.f_58857_ != null);
        return (long)this.getDuration() - (Calendars.get((LevelReader)this.f_58857_).getTicks() - this.startTick);
    }

    public void start() {
        assert (this.f_58857_ != null);
        this.updateCache();
        if (this.cachedRecipe != null) {
            this.startTick = Calendars.get((LevelReader)this.f_58857_).getTicks();
            if (!this.f_58857_.m_45527_(this.f_58858_.m_7494_())) {
                this.startTick += (long)this.getDuration();
            }
            this.markForSync();
        }
    }

    public void finish() {
        assert (this.f_58857_ != null);
        T recipe = this.cachedRecipe;
        if (recipe != null) {
            int ct = this.readStack().m_41613_();
            ItemStack out = recipe.assemble(new ItemStackInventory(this.readStack()), this.f_58857_.m_9598_());
            out.m_41764_(out.m_41613_() * ct);
            ((ItemStackHandler)this.inventory).setStackInSlot(0, out);
            this.updateCache();
            this.markForSync();
        }
    }

    public void resetCounter() {
        this.startTick = Calendars.SERVER.getTicks();
        this.markForSync();
    }

    public ItemStack viewStack() {
        return ((ItemStackHandler)this.inventory).getStackInSlot(0);
    }

    public ItemStack readStack() {
        return ((ItemStackHandler)this.inventory).getStackInSlot(0).m_41777_();
    }

    public int getDuration() {
        return this.duration.get();
    }
}

