/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blockentities;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.blockentities.LargePlanterBlockEntity;
import com.eerussianguy.firmalife.common.util.Plantable;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class QuadPlanterBlockEntity
extends LargePlanterBlockEntity {
    public static final Component NAME = FLHelpers.blockEntityName("quad_planter");
    private static final int NUM_SLOTS = 4;
    private final Plantable[] cachedPlants = new Plantable[]{null, null, null, null};
    private float[] growth = new float[]{0.0f, 0.0f, 0.0f, 0.0f};

    public QuadPlanterBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)FLBlockEntities.QUAD_PLANTER.get(), pos, state, NAME);
    }

    public QuadPlanterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, Component name) {
        super(type, pos, state, (InventoryBlockEntity.InventoryFactory<ItemStackHandler>)QuadPlanterBlockEntity.defaultInventory((int)4), name);
    }

    @Override
    protected void loadUnique(CompoundTag nbt) {
        this.growth = new float[]{nbt.m_128457_("grow0"), nbt.m_128457_("grow1"), nbt.m_128457_("grow2"), nbt.m_128457_("grow3")};
    }

    @Override
    protected void saveUnique(CompoundTag nbt) {
        for (int i = 0; i < 4; ++i) {
            nbt.m_128350_("grow" + i, this.growth[i]);
        }
    }

    @Override
    public void updateCache() {
        for (int i = 0; i < 4; ++i) {
            this.cachedPlants[i] = Plantable.get(((ItemStackHandler)this.inventory).getStackInSlot(i));
        }
        this.markForSync();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
    }

    @Override
    public int slots() {
        return 4;
    }

    @Override
    public float getGrowth(int slot) {
        return this.growth[slot];
    }

    @Override
    public void setGrowth(int slot, float growth) {
        this.growth[slot] = growth;
        this.markForSync();
    }

    @Override
    @Nullable
    public Plantable getPlantable(int slot) {
        return this.cachedPlants[slot];
    }
}

