/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blockentities;

import com.eerussianguy.firmalife.common.blockentities.FLBeehiveBlockEntity;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.blocks.plant.GrapeGroundPlantOnStringBlock;
import com.eerussianguy.firmalife.common.blocks.plant.IGrape;
import com.eerussianguy.firmalife.common.items.FLFoodTraits;
import com.eerussianguy.firmalife.common.util.FLClimateRanges;
import java.util.ArrayList;
import java.util.List;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.TickableBlockEntity;
import net.dries007.tfc.common.blocks.plant.fruit.Lifecycle;
import net.dries007.tfc.common.capabilities.food.FoodTrait;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendarTickable;
import net.dries007.tfc.util.calendar.Month;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.util.climate.ClimateRange;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public class GrapePlantBlockEntity
extends TickableBlockEntity
implements ICalendarTickable {
    public static final int UPDATE_INTERVAL = 24000;
    private long lastUpdateTick;
    private long lastGrowthTick;
    private float growth = 0.0f;
    private int[] soilData = new int[]{0, 0, 0, 0, 0};
    private int dirt;
    private int grass;
    private int gravel;
    private int minus;
    private int zero = 0;
    private boolean hasBees = false;

    public static void serverTick(Level level, BlockPos pos, BlockState state, GrapePlantBlockEntity plant) {
        plant.checkForCalendarUpdate();
        plant.checkForLastTickSync();
    }

    public GrapePlantBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FLBlockEntities.GRAPE_PLANT.get(), pos, state);
        this.lastGrowthTick = Calendars.SERVER.getTicks();
        this.lastUpdateTick = Integer.MIN_VALUE;
    }

    public void onCalendarUpdate(long ticks) {
        assert (this.f_58857_ != null);
        this.tryUpdate();
    }

    public void tryUpdate() {
        long now = Calendars.SERVER.getTicks();
        if (now > this.lastGrowthTick + 24000L) {
            while (this.lastGrowthTick < now) {
                this.updateTick();
                this.lastGrowthTick += 24000L;
            }
            this.recordOwnData();
            this.markForSync();
        }
    }

    public void updateTick() {
        assert (this.f_58857_ != null);
        Lifecycle lifecycle = Lifecycle.DORMANT;
        if (FLClimateRanges.GRAPES.get().checkTemperature(Climate.getTemperature((Level)this.f_58857_, (BlockPos)this.f_58858_), false) == ClimateRange.Result.VALID) {
            this.growth += 0.125f + this.f_58857_.f_46441_.m_188501_() * 0.05f;
            if (this.growth >= 1.0f) {
                this.advanceAt(this.f_58858_);
                this.advanceAt(this.f_58858_.m_7494_());
                this.growth = 0.0f;
                this.markForSync();
            }
            lifecycle = Lifecycle.HEALTHY;
            Month month = Calendars.get((LevelReader)this.f_58857_).getCalendarMonthOfYear();
            if (month == Month.JUNE) {
                lifecycle = Lifecycle.FLOWERING;
            } else if (month == Month.JULY) {
                lifecycle = Lifecycle.FRUITING;
            }
        }
        this.lifecycleAt(this.f_58858_, lifecycle);
        this.lifecycleAt(this.f_58858_.m_7494_(), lifecycle);
    }

    private void advanceAt(BlockPos pos) {
        assert (this.f_58857_ != null);
        BlockState state = this.f_58857_.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof IGrape) {
            IGrape grape = (IGrape)block;
            grape.advance(this.f_58857_, pos, state);
        }
    }

    private void lifecycleAt(BlockPos pos, Lifecycle lifecycle) {
        assert (this.f_58857_ != null);
        BlockState state = this.f_58857_.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof IGrape) {
            IGrape grape = (IGrape)block;
            grape.advanceLifecycle(this.f_58857_, pos, state, lifecycle);
        }
    }

    public BlockPos getBrainPos() {
        assert (this.f_58857_ != null);
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        Direction dir = GrapePlantBlockEntity.getStringDirection(state);
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        cursor.m_122190_((Vec3i)this.f_58858_);
        while (state.m_60734_() instanceof GrapeGroundPlantOnStringBlock) {
            cursor.m_122175_(dir, 2);
            state = this.f_58857_.m_8055_((BlockPos)cursor);
        }
        cursor.m_122175_(dir, -2);
        return cursor.m_7949_();
    }

    @NotNull
    private static Direction getStringDirection(BlockState state) {
        return state.m_61143_((Property)GrapeGroundPlantOnStringBlock.AXIS) == Direction.Axis.X ? Direction.EAST : Direction.SOUTH;
    }

    public List<FoodTrait> scanAndReport() {
        BlockEntity blockEntity;
        assert (this.f_58857_ != null);
        BlockPos brainPos = this.getBrainPos();
        if (!this.f_58858_.equals((Object)brainPos) && (blockEntity = this.f_58857_.m_7702_(brainPos)) instanceof GrapePlantBlockEntity) {
            GrapePlantBlockEntity plant = (GrapePlantBlockEntity)blockEntity;
            return plant.scanAndReport();
        }
        int dirtCount = this.soilData[0];
        int grassCount = this.soilData[1];
        int gravelCount = this.soilData[2];
        int countAtMinus1 = this.soilData[3];
        int countAtZero = this.soilData[4];
        boolean anyBees = this.hasBees;
        Direction dir = GrapePlantBlockEntity.getStringDirection(this.f_58857_.m_8055_(this.f_58858_)).m_122424_();
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        cursor.m_122190_((Vec3i)this.f_58858_);
        while (true) {
            cursor.m_122175_(dir, 2);
            BlockEntity blockEntity2 = this.f_58857_.m_7702_((BlockPos)cursor);
            if (!(blockEntity2 instanceof GrapePlantBlockEntity)) break;
            GrapePlantBlockEntity plant = (GrapePlantBlockEntity)blockEntity2;
            dirtCount += plant.soilData[0];
            grassCount += plant.soilData[1];
            gravelCount += plant.soilData[2];
            countAtMinus1 += plant.soilData[3];
            countAtZero += plant.soilData[4];
            anyBees |= plant.hasBees;
        }
        ArrayList<FoodTrait> traits = new ArrayList<FoodTrait>();
        if (anyBees) {
            traits.add(FLFoodTraits.BEE_POLLINATED);
        }
        if (dirtCount > gravelCount && dirtCount > grassCount) {
            traits.add(FLFoodTraits.DIRT_GROWN);
        }
        if (gravelCount > dirtCount && gravelCount > grassCount) {
            traits.add(FLFoodTraits.GRAVEL_GROWN);
        }
        if (countAtMinus1 < 33 && countAtZero > 20) {
            traits.add(FLFoodTraits.SLOPE_GROWN);
        }
        return traits;
    }

    private void recordOwnData() {
        assert (this.f_58857_ != null);
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        float temp = Climate.getTemperature((Level)this.f_58857_, (BlockPos)this.f_58858_);
        int dirtCount = 0;
        int grassCount = 0;
        int gravelCount = 0;
        int countAtMinus1 = 0;
        int countAtZero = 0;
        boolean bees = false;
        for (int x = -3; x <= 3; ++x) {
            for (int z = -3; z <= 3; ++z) {
                for (int y = -1; y <= 0; ++y) {
                    FLBeehiveBlockEntity hive;
                    BlockEntity blockEntity;
                    cursor.m_122154_((Vec3i)this.f_58858_, x, y, z);
                    if (!this.f_58857_.m_46749_((BlockPos)cursor)) continue;
                    BlockState state = this.f_58857_.m_8055_((BlockPos)cursor);
                    if (!state.m_60795_()) {
                        if (y == -1) {
                            ++countAtMinus1;
                        } else {
                            ++countAtZero;
                        }
                    }
                    if (Helpers.isBlock((BlockState)state, (TagKey)TFCTags.Blocks.GRASS)) {
                        ++grassCount;
                        continue;
                    }
                    if (Helpers.isBlock((BlockState)state, (TagKey)BlockTags.f_144274_)) {
                        ++dirtCount;
                        continue;
                    }
                    if (Helpers.isBlock((BlockState)state, (TagKey)Tags.Blocks.GRAVEL)) {
                        ++gravelCount;
                        continue;
                    }
                    if (bees || !((blockEntity = this.f_58857_.m_7702_((BlockPos)cursor)) instanceof FLBeehiveBlockEntity) || (hive = (FLBeehiveBlockEntity)blockEntity).getUsableBees(temp).isEmpty()) continue;
                    bees = true;
                }
            }
        }
        this.hasBees = bees;
        this.soilData = new int[]{dirtCount, grassCount, gravelCount, countAtMinus1, countAtZero};
    }

    public boolean isBrain() {
        return this.getBrainPos().equals((Object)this.f_58858_);
    }

    public int[] debugViewOfSoilData() {
        return this.soilData;
    }

    public boolean debugHasBees() {
        return this.hasBees;
    }

    public float getGrowth() {
        return this.growth;
    }

    public long getLastGrowthTick() {
        return this.lastGrowthTick;
    }

    public void setLastGrowthTick(long lastGrowthTick) {
        this.lastGrowthTick = lastGrowthTick;
        this.markForSync();
    }

    @Deprecated
    public long getLastCalendarUpdateTick() {
        return this.lastUpdateTick;
    }

    @Deprecated
    public void setLastCalendarUpdateTick(long tick) {
        this.lastUpdateTick = tick;
    }

    public void loadAdditional(CompoundTag nbt) {
        this.lastUpdateTick = nbt.m_128454_("tick");
        this.lastGrowthTick = nbt.m_128454_("lastGrowthTick");
        this.growth = nbt.m_128457_("growth");
        this.hasBees = nbt.m_128471_("hasBees");
        this.soilData = nbt.m_128465_("soilData");
        super.loadAdditional(nbt);
    }

    public void m_183515_(CompoundTag nbt) {
        nbt.m_128356_("tick", this.lastUpdateTick);
        nbt.m_128356_("lastGrowthTick", this.lastGrowthTick);
        nbt.m_128350_("growth", this.growth);
        nbt.m_128379_("hasBees", this.hasBees);
        nbt.m_128385_("soilData", this.soilData);
        super.m_183515_(nbt);
    }
}

