/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blockentities;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blockentities.ClimateReceiver;
import com.eerussianguy.firmalife.common.blockentities.ClimateType;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.items.FLFoodTraits;
import com.eerussianguy.firmalife.config.FLConfig;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodTrait;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.climate.Climate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class FoodShelfBlockEntity
extends InventoryBlockEntity<ItemStackHandler>
implements ClimateReceiver {
    private static final FoodTrait[] POSSIBLE = new FoodTrait[]{FLFoodTraits.SHELVED, FLFoodTraits.SHELVED_2, FLFoodTraits.SHELVED_3};
    private boolean climateValid = false;

    public FoodShelfBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)FLBlockEntities.FOOD_SHELF.get(), pos, state);
    }

    public FoodShelfBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, FoodShelfBlockEntity.defaultInventory((int)1), FLHelpers.blockEntityName("food_shelf"));
    }

    public void setAndUpdateSlots(int slot) {
        super.setAndUpdateSlots(slot);
        this.markForSync();
    }

    public void markForSync() {
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
        super.markForSync();
    }

    public void loadAdditional(CompoundTag nbt) {
        super.loadAdditional(nbt);
        this.climateValid = nbt.m_128471_("climateValid");
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128379_("climateValid", this.climateValid);
    }

    public boolean isClimateValid() {
        return this.climateValid;
    }

    public void onLoadAdditional() {
        this.updatePreservation(this.climateValid);
    }

    public void ejectInventory() {
        this.updatePreservation(false);
        super.ejectInventory();
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        ItemStack current = ((ItemStackHandler)this.inventory).getStackInSlot(slot);
        if (!current.m_41619_()) {
            ItemStack currentWithoutTrait = current.m_41777_();
            FoodCapability.removeTrait((ItemStack)currentWithoutTrait, (FoodTrait)this.getFoodTrait());
            return FoodCapability.areStacksStackableExceptCreationDate((ItemStack)stack, (ItemStack)currentWithoutTrait);
        }
        return stack.getCapability(FoodCapability.CAPABILITY).isPresent();
    }

    public FoodTrait getFoodTrait() {
        if (this.f_58857_ != null) {
            float temp = Climate.getAverageTemperature((Level)this.f_58857_, (BlockPos)this.m_58899_());
            if ((double)temp < (Double)FLConfig.SERVER.cellarLevel3Temperature.get()) {
                return FLFoodTraits.SHELVED_3;
            }
            if ((double)temp < (Double)FLConfig.SERVER.cellarLevel2Temperature.get()) {
                return FLFoodTraits.SHELVED_2;
            }
        }
        return FLFoodTraits.SHELVED;
    }

    public FoodTrait[] getPossibleTraits() {
        return POSSIBLE;
    }

    public InteractionResult use(Player player, InteractionHand hand) {
        assert (this.f_58857_ != null);
        InteractionResult res = InteractionResult.PASS;
        ItemStack held = player.m_21120_(hand);
        if (!held.m_41619_() && this.isItemValid(0, held)) {
            if (this.climateValid) {
                FoodCapability.applyTrait((ItemStack)held, (FoodTrait)this.getFoodTrait());
            }
            player.m_21008_(hand, Helpers.mergeInsertStack((IItemHandler)this.inventory, (int)0, (ItemStack)held));
            FoodCapability.removeTrait((ItemStack)player.m_21120_(hand), (FoodTrait)this.getFoodTrait());
            res = InteractionResult.m_19078_((boolean)this.f_58857_.f_46443_);
        } else if (held.m_41619_()) {
            ItemStack stack = ((ItemStackHandler)this.inventory).extractItem(0, player.m_6144_() ? Integer.MAX_VALUE : 1, false);
            if (stack.m_41619_()) {
                return InteractionResult.PASS;
            }
            FoodCapability.removeTrait((ItemStack)stack, (FoodTrait)this.getFoodTrait());
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
            res = InteractionResult.m_19078_((boolean)this.f_58857_.f_46443_);
        }
        this.updatePreservation(this.climateValid);
        this.markForSync();
        return res;
    }

    public void updatePreservation(boolean preserved) {
        if (preserved) {
            FoodCapability.applyTrait((ItemStack)((ItemStackHandler)this.inventory).getStackInSlot(0), (FoodTrait)this.getFoodTrait());
        } else {
            ItemStack stack = ((ItemStackHandler)this.inventory).getStackInSlot(0);
            for (FoodTrait trait : this.getPossibleTraits()) {
                FoodCapability.removeTrait((ItemStack)stack, (FoodTrait)trait);
            }
        }
    }

    @Override
    public void setValid(Level level, BlockPos pos, boolean valid, int tier, ClimateType climate) {
        if (climate == ClimateType.CELLAR) {
            this.climateValid = valid;
            this.updatePreservation(valid);
        }
        this.markForSync();
    }
}

