/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common;

import com.eerussianguy.firmalife.FirmaLife;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.dries007.tfc.common.blockentities.TickCounterBlockEntity;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodTrait;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.JsonHelpers;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class FLHelpers {
    public static final boolean ASSERTIONS_ENABLED = FLHelpers.detectAssertionsEnabled();
    public static Direction[] NOT_DOWN = new Direction[]{Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH, Direction.UP};

    public static ResourceLocation identifier(String id) {
        return FLHelpers.res("firmalife", id);
    }

    public static Vec3 vec3(BlockPos pos) {
        return new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
    }

    public static void returnItem(Player player, ItemStack stack) {
        ServerPlayer serverPlayer;
        if (player.m_6084_() && player instanceof ServerPlayer && !(serverPlayer = (ServerPlayer)player).m_9232_()) {
            player.m_150109_().m_150079_(stack);
        } else {
            player.m_36176_(stack, false);
        }
    }

    public static void resetCounter(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TickCounterBlockEntity) {
            TickCounterBlockEntity counter = (TickCounterBlockEntity)blockEntity;
            counter.resetCounter();
        }
    }

    public static void writeTraitList(List<FoodTrait> list, CompoundTag nbt, String key) {
        if (!list.isEmpty()) {
            ListTag listTag = new ListTag();
            for (FoodTrait trait : list) {
                CompoundTag newTag = new CompoundTag();
                newTag.m_128359_("trait", FoodTrait.getId((FoodTrait)trait).toString());
                listTag.add((Object)newTag);
            }
            nbt.m_128365_(key, (Tag)listTag);
        }
    }

    public static void readTraitList(List<FoodTrait> list, CompoundTag nbt, String key) {
        list.clear();
        if (nbt.m_128441_(key)) {
            ListTag excessNbt = nbt.m_128437_(key, 10);
            for (int i = 0; i < excessNbt.size(); ++i) {
                FoodTrait trait = FoodTrait.getTrait((ResourceLocation)FLHelpers.res(excessNbt.m_128728_(i).m_128461_("trait")));
                if (trait == null) continue;
                list.add(trait);
            }
        }
    }

    public static void writeItemStackList(List<ItemStack> list, CompoundTag nbt, String key) {
        if (!list.isEmpty()) {
            ListTag listTag = new ListTag();
            for (ItemStack stack : list) {
                listTag.add((Object)stack.m_41739_(new CompoundTag()));
            }
            nbt.m_128365_(key, (Tag)listTag);
        }
    }

    public static void readItemStackList(List<ItemStack> list, CompoundTag nbt, String key) {
        list.clear();
        if (nbt.m_128441_(key)) {
            ListTag excessNbt = nbt.m_128437_(key, 10);
            for (int i = 0; i < excessNbt.size(); ++i) {
                list.add(ItemStack.m_41712_((CompoundTag)excessNbt.m_128728_(i)));
            }
        }
    }

    public static <T> JsonElement codecToJson(Codec<T> codec, T instance) {
        return (JsonElement)codec.encodeStart((DynamicOps)JsonOps.INSTANCE, instance).getOrThrow(false, Util.m_137489_((String)"Error encoding: ", arg_0 -> ((Logger)FirmaLife.LOGGER).error(arg_0)));
    }

    public static Component blockEntityName(String name) {
        return Component.m_237115_((String)("firmalife.block_entity." + name));
    }

    public static <T extends BlockEntity> void readInventory(Level level, BlockPos pos, Supplier<BlockEntityType<T>> type, BiConsumer<T, IItemHandler> consumer) {
        level.m_141902_(pos, type.get()).ifPresent(be -> be.getCapability(Capabilities.ITEM).ifPresent(inv -> consumer.accept((Object)be, (IItemHandler)inv)));
    }

    public static <T extends BlockEntity> InteractionResult consumeInventory(Level level, BlockPos pos, Supplier<BlockEntityType<T>> type, BiFunction<T, IItemHandler, InteractionResult> consumer) {
        return level.m_141902_(pos, type.get()).map(be -> be.getCapability(Capabilities.ITEM).map(inv -> (InteractionResult)consumer.apply((Object)be, (IItemHandler)inv)).orElse(InteractionResult.PASS)).orElse(InteractionResult.PASS);
    }

    public static InteractionResult insertOne(Level level, ItemStack item, int slot, IItemHandler inv, Player player) {
        if (!inv.isItemValid(slot, item)) {
            return InteractionResult.PASS;
        }
        return FLHelpers.completeInsertion(level, item, inv, player, slot);
    }

    public static InteractionResult takeOne(Level level, int slot, IItemHandler inv, Player player) {
        ItemStack stack = inv.extractItem(slot, 1, false);
        if (stack.m_41619_()) {
            return InteractionResult.PASS;
        }
        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public static InteractionResult insertOneAny(Level level, ItemStack item, int start, int end, ICapabilityProvider provider, Player player) {
        return provider.getCapability(Capabilities.ITEM).map(inv -> FLHelpers.insertOneAny(level, item, start, end, inv, player)).orElse(InteractionResult.PASS);
    }

    public static InteractionResult insertOneAny(Level level, ItemStack item, int start, int end, IItemHandler inv, Player player) {
        for (int i = start; i <= end; ++i) {
            if (!inv.getStackInSlot(i).m_41619_()) continue;
            return FLHelpers.completeInsertion(level, item, inv, player, i);
        }
        return InteractionResult.PASS;
    }

    public static ItemStack mergeInsertStack(IItemHandler inventory, int slot, ItemStack stack) {
        ItemStack existing = Helpers.removeStack((IItemHandler)inventory, (int)slot);
        ItemStack remainder = stack.m_41777_();
        ItemStack merged = FoodCapability.mergeItemStacks((ItemStack)existing, (ItemStack)remainder);
        remainder.m_41769_(inventory.insertItem(slot, merged, false).m_41613_());
        return remainder;
    }

    private static InteractionResult completeInsertion(Level level, ItemStack item, IItemHandler inv, Player player, int slot) {
        ItemStack stack = inv.insertItem(slot, item.m_41620_(1), false);
        if (stack.m_41619_()) {
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public static InteractionResult takeOneAny(Level level, int start, int end, ICapabilityProvider provider, Player player) {
        return provider.getCapability(Capabilities.ITEM).map(inv -> FLHelpers.takeOneAny(level, start, end, inv, player)).orElse(InteractionResult.PASS);
    }

    public static InteractionResult takeOneAny(Level level, int start, int end, IItemHandler inv, Player player) {
        for (int i = start; i <= end; ++i) {
            ItemStack stack = inv.extractItem(i, 1, false);
            if (stack.m_41619_()) continue;
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public static <T> T ofJsonNullable(JsonObject json, Function<JsonObject, T> getter, String key) {
        return json.has(key) ? (T)getter.apply(json) : null;
    }

    public static <T> T ofJsonDefaulting(JsonObject json, Function<JsonObject, T> getter, String key, T defaultValue) {
        return json.has(key) ? getter.apply(json) : defaultValue;
    }

    public static ResourceLocation res(String string) {
        return new ResourceLocation(string);
    }

    public static ResourceLocation res(String namespace, String path) {
        return new ResourceLocation(namespace, path);
    }

    public static Iterable<BlockPos> allPositionsCentered(BlockPos center, int radius, int height) {
        return BlockPos.m_121940_((BlockPos)center.m_7918_(-radius, -height, -radius), (BlockPos)center.m_7918_(radius, height, radius));
    }

    public static MutableComponent translateEnum(Enum<?> anEnum) {
        return Component.m_237115_((String)FLHelpers.getEnumTranslationKey(anEnum));
    }

    public static String getEnumTranslationKey(Enum<?> anEnum) {
        return FLHelpers.getEnumTranslationKey(anEnum, anEnum.getDeclaringClass().getSimpleName());
    }

    public static String getEnumTranslationKey(Enum<?> anEnum, String enumName) {
        return String.join((CharSequence)".", "firmalife", "enum", enumName, anEnum.name()).toLowerCase(Locale.ROOT);
    }

    public static void roundCreationDate(ItemStack stack) {
        stack.getCapability(FoodCapability.CAPABILITY).ifPresent(cap -> cap.setCreationDate(FoodCapability.getRoundedCreationDate((long)cap.getCreationDate())));
    }

    public static ResourceLocation[] arrayOfResourceLocationsFromJson(JsonObject json, String field) {
        JsonArray array = JsonHelpers.m_13933_((JsonObject)json, (String)field);
        ResourceLocation[] textures = new ResourceLocation[array.size()];
        int i = 0;
        for (JsonElement element : array) {
            textures[i] = FLHelpers.res(element.getAsString());
            ++i;
        }
        return textures;
    }

    public static ResourceLocation[] arrayOfResourceLocationsFromNetwork(FriendlyByteBuf buffer) {
        int length = buffer.m_130242_();
        if (length == 0) {
            return new ResourceLocation[0];
        }
        ResourceLocation[] textures = new ResourceLocation[length];
        for (int i = 0; i < length; ++i) {
            textures[i] = FLHelpers.res(buffer.m_130277_());
        }
        return textures;
    }

    public static void arrayOfResourceLocationsToNetwork(FriendlyByteBuf buffer, ResourceLocation[] textures) {
        buffer.m_130130_(textures.length);
        for (ResourceLocation res : textures) {
            buffer.m_130070_(res.toString());
        }
    }

    private static boolean detectAssertionsEnabled() {
        boolean enabled = false;
        if (!$assertionsDisabled) {
            enabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return enabled;
    }
}

