/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.client.screen;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blockentities.BigBarrelBlockEntity;
import com.eerussianguy.firmalife.common.container.BigBarrelContainer;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.screen.BlockEntityScreen;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.container.BlockEntityContainer;
import net.dries007.tfc.util.Tooltips;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.fluids.FluidStack;

public class BigBarrelScreen
extends BlockEntityScreen<BigBarrelBlockEntity, BigBarrelContainer> {
    private static final ResourceLocation BACKGROUND = FLHelpers.identifier("textures/gui/big_barrel.png");

    public BigBarrelScreen(BigBarrelContainer container, Inventory playerInventory, Component name) {
        super((BlockEntityContainer)container, playerInventory, name, BACKGROUND);
        this.f_97727_ += 54;
        this.f_97731_ += 55;
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(graphics, partialTicks, mouseX, mouseY);
        ((BigBarrelBlockEntity)this.blockEntity).getCapability(Capabilities.FLUID).ifPresent(fluidHandler -> {
            FluidStack fluidStack = fluidHandler.getFluidInTank(0);
            if (!fluidStack.isEmpty()) {
                TextureAtlasSprite sprite = RenderHelpers.getAndBindFluidSprite((FluidStack)fluidStack);
                int fillHeight = (int)Math.ceil(106.0f * (float)fluidStack.getAmount() / 80000.0f);
                RenderHelpers.fillAreaWithSprite((GuiGraphics)graphics, (TextureAtlasSprite)sprite, (int)(this.f_97735_ + 8), (int)(this.f_97736_ + 124 - fillHeight), (int)16, (int)fillHeight, (int)16, (int)16);
                this.resetToBackgroundSprite();
            }
        });
        graphics.m_280218_(this.texture, this.getGuiLeft() + 7, this.getGuiTop() + 17, 176, 0, 18, 107);
    }

    protected void m_280072_(GuiGraphics graphics, int mouseX, int mouseY) {
        super.m_280072_(graphics, mouseX, mouseY);
        int relX = mouseX - this.getGuiLeft();
        int relY = mouseY - this.getGuiTop();
        if (relX >= 7 && relY >= 17 && relX < 25 && relY < 124) {
            ((BigBarrelBlockEntity)this.blockEntity).getCapability(Capabilities.FLUID).ifPresent(fluidHandler -> {
                FluidStack fluid = fluidHandler.getFluidInTank(0);
                if (!fluid.isEmpty()) {
                    graphics.m_280557_(this.f_96547_, (Component)Tooltips.fluidUnitsOf((FluidStack)fluid), mouseX, mouseY);
                }
            });
        }
    }
}

