/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.client.model;

import com.eerussianguy.firmalife.client.model.DynamicBlockModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.pipeline.QuadBakingVertexConsumer;
import org.jetbrains.annotations.NotNull;

public abstract class SimpleDynamicBlockModel<T extends BlockEntity>
extends DynamicBlockModel.Baked {
    public SimpleDynamicBlockModel(boolean isAmbientOcclusion, boolean isGui3d, boolean isSideLit, ItemOverrides overrides, BakedModel baseModel) {
        super(isAmbientOcclusion, isGui3d, isSideLit, overrides, baseModel);
    }

    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData modelData) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity != null && blockEntity.m_58903_() == this.type()) {
            return modelData.derive().with(DynamicBlockModel.StaticModelData.PROPERTY, (Object)this.render(level, pos, blockEntity)).build();
        }
        return modelData;
    }

    public DynamicBlockModel.StaticModelData render(BlockAndTintGetter level, BlockPos pos, T blockEntity) {
        int packedLight = LightTexture.m_109885_((int)level.m_45517_(LightLayer.BLOCK, pos), (int)level.m_45517_(LightLayer.SKY, pos));
        int packedOverlay = OverlayTexture.f_118083_;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(24);
        QuadBakingVertexConsumer buffer = new QuadBakingVertexConsumer(quads::add);
        PoseStack poseStack = new PoseStack();
        this.render(blockEntity, poseStack, (VertexConsumer)buffer, packedLight, packedOverlay);
        return quads.isEmpty() ? DynamicBlockModel.StaticModelData.EMPTY : new DynamicBlockModel.StaticModelData(quads);
    }

    protected abstract void render(T var1, PoseStack var2, VertexConsumer var3, int var4, int var5);

    protected abstract BlockEntityType<T> type();
}

