/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.client.model;

import com.eerussianguy.firmalife.client.model.SimpleDynamicBlockModel;
import com.eerussianguy.firmalife.client.render.RenderUtils;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.blockentities.LargePlanterBlockEntity;
import com.eerussianguy.firmalife.common.util.Plantable;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class LargePlanterBakedModel
extends SimpleDynamicBlockModel<LargePlanterBlockEntity> {
    public LargePlanterBakedModel(boolean isAmbientOcclusion, boolean isGui3d, boolean isSideLit, ItemOverrides overrides, BakedModel baseModel) {
        super(isAmbientOcclusion, isGui3d, isSideLit, overrides, baseModel);
    }

    @Override
    public void render(LargePlanterBlockEntity planter, PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay) {
        Plantable plant = planter.getPlantable(0);
        if (plant == null) {
            return;
        }
        Function atlas = Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_);
        TextureAtlasSprite sprite = (TextureAtlasSprite)atlas.apply(plant.getTexture(planter.getGrowth(0)));
        poseStack.m_85836_();
        RenderUtils.renderCross(0.125f, 0.875f, 0.3125f, 1.0625f, poseStack, buffer, packedLight, packedOverlay, sprite, 0.0f, 0.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }

    @Override
    public BlockEntityType<LargePlanterBlockEntity> type() {
        return (BlockEntityType)FLBlockEntities.LARGE_PLANTER.get();
    }
}

