/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.client.model;

import com.eerussianguy.firmalife.client.model.SimpleDynamicBlockModel;
import com.eerussianguy.firmalife.client.render.RenderUtils;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.blockentities.HangingPlanterBlockEntity;
import com.eerussianguy.firmalife.common.util.Plantable;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import net.dries007.tfc.client.RenderHelpers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class HangingPlanterBlockModel
extends SimpleDynamicBlockModel<HangingPlanterBlockEntity> {
    private static final int FRUIT_ID = 0;

    public HangingPlanterBlockModel(boolean isAmbientOcclusion, boolean isGui3d, boolean isSideLit, ItemOverrides overrides, BakedModel baseModel) {
        super(isAmbientOcclusion, isGui3d, isSideLit, overrides, baseModel);
    }

    @Override
    public void render(HangingPlanterBlockEntity planter, PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay) {
        Plantable plant = planter.getPlantable(0);
        if (plant == null) {
            return;
        }
        poseStack.m_85836_();
        Function atlas = Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_);
        TextureAtlasSprite growth = (TextureAtlasSprite)atlas.apply(plant.getTexture(planter.getGrowth(0)));
        RenderUtils.renderCross(0.0625f, 0.9375f, 0.0f, 0.8125f, poseStack, buffer, packedLight, packedOverlay, growth, 0.0625f, 0.0f, 0.9375f, 0.8125f);
        if (planter.getGrowth(0) >= 1.0f) {
            TextureAtlasSprite fruit = (TextureAtlasSprite)atlas.apply(plant.getSpecialTexture(0));
            RenderHelpers.renderTexturedCuboid((PoseStack)poseStack, (VertexConsumer)buffer, (TextureAtlasSprite)fruit, (int)packedLight, (int)packedOverlay, (float)0.25f, (float)0.1875f, (float)0.25f, (float)0.4375f, (float)0.375f, (float)0.4375f);
            RenderHelpers.renderTexturedCuboid((PoseStack)poseStack, (VertexConsumer)buffer, (TextureAtlasSprite)fruit, (int)packedLight, (int)packedOverlay, (float)0.25f, (float)0.0f, (float)0.625f, (float)0.4375f, (float)0.1875f, (float)0.8125f);
            RenderHelpers.renderTexturedCuboid((PoseStack)poseStack, (VertexConsumer)buffer, (TextureAtlasSprite)fruit, (int)packedLight, (int)packedOverlay, (float)0.5625f, (float)0.4375f, (float)0.3125f, (float)0.75f, (float)0.625f, (float)0.5f);
        }
        poseStack.m_85849_();
    }

    @Override
    public BlockEntityType<HangingPlanterBlockEntity> type() {
        return (BlockEntityType)FLBlockEntities.HANGING_PLANTER.get();
    }
}

