/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.client.model;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.dries007.tfc.client.RenderHelpers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.SeparateTransformsModel;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicBlockModel
implements IUnbakedGeometry<DynamicBlockModel> {
    private final BlockModel baseModel;
    private final BakedModelFactory bakedModelFactory;

    public DynamicBlockModel(BlockModel blockModel, BakedModelFactory bakedModelFactory) {
        this.baseModel = blockModel;
        this.bakedModelFactory = bakedModelFactory;
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        return this.bakedModelFactory.apply(context.useAmbientOcclusion(), context.isGui3d(), context.useBlockLight(), overrides, this.baseModel.m_111449_(baker, this.baseModel, spriteGetter, modelState, modelLocation, context.useBlockLight()));
    }

    public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
        this.baseModel.m_5500_(modelGetter);
    }

    public static interface BakedModelFactory {
        public Baked apply(boolean var1, boolean var2, boolean var3, ItemOverrides var4, BakedModel var5);
    }

    public static class Baked
    extends SeparateTransformsModel.Baked {
        private final BakedModel baseModel;

        public Baked(boolean isAmbientOcclusion, boolean isGui3d, boolean isSideLit, ItemOverrides overrides, BakedModel baseModel) {
            super(isAmbientOcclusion, isGui3d, isSideLit, RenderHelpers.missingTexture(), overrides, baseModel, ImmutableMap.of());
            this.baseModel = baseModel;
        }

        public TextureAtlasSprite getParticleIcon(@NotNull ModelData data) {
            return this.baseModel.getParticleIcon(data);
        }

        @NotNull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType renderType) {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(super.getQuads(state, side, rand, data, renderType));
            StaticModelData extraQuads = (StaticModelData)data.get(StaticModelData.PROPERTY);
            if (extraQuads != null && side == null) {
                quads.addAll(extraQuads.quads);
            }
            return quads;
        }
    }

    public record Loader(BakedModelFactory factory) implements IGeometryLoader<DynamicBlockModel>
    {
        public DynamicBlockModel read(JsonObject json, JsonDeserializationContext ctx) throws JsonParseException {
            BlockModel base = (BlockModel)ctx.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"base"), BlockModel.class);
            return new DynamicBlockModel(base, this.factory);
        }
    }

    record StaticModelData(List<BakedQuad> quads) {
        public static final ModelProperty<StaticModelData> PROPERTY = new ModelProperty();
        public static final StaticModelData EMPTY = new StaticModelData(new ArrayList<BakedQuad>());
    }
}

