/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.client;

import com.eerussianguy.firmalife.FirmaLife;
import com.eerussianguy.firmalife.common.FLCreativeTabs;
import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blockentities.CompostTumblerBlockEntity;
import com.eerussianguy.firmalife.common.blocks.greenhouse.PlanterType;
import com.eerussianguy.firmalife.common.util.FoodAge;
import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.dries007.tfc.common.blocks.BloomBlock;
import net.dries007.tfc.common.blocks.IcePileBlock;
import net.dries007.tfc.common.blocks.MoltenBlock;
import net.dries007.tfc.common.blocks.PouredGlassBlock;
import net.dries007.tfc.common.blocks.SnowPileBlock;
import net.dries007.tfc.common.blocks.TFCLightBlock;
import net.dries007.tfc.common.blocks.rock.RockAnvilBlock;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.SelfTests;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.Bootstrap;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.RenderShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.slf4j.Logger;

public final class FLClientSelfTests {
    private static final Logger LOGGER = FirmaLife.LOGGER;

    public static void runClientSelfTests() {
        if (FLHelpers.ASSERTIONS_ENABLED) {
            TFCConfig.COMMON.enableDatapackTests.set((Object)true);
            Stopwatch tick = Stopwatch.createStarted();
            SelfTests.throwIfAny((boolean[])new boolean[]{FLClientSelfTests.validateOwnBlockEntities(), FLClientSelfTests.validateModels(), FLClientSelfTests.validateTranslationsAndCreativeTabs()});
            MinecraftForge.EVENT_BUS.post((Event)new SelfTests.ClientSelfTestEvent());
            LOGGER.info("Client self tests passed in {}", (Object)tick.stop());
        }
    }

    public static boolean validateModels() {
        BlockModelShaper shaper = Minecraft.m_91087_().m_91289_().m_110907_();
        BakedModel missingModel = shaper.m_110881_().m_119409_();
        TextureAtlasSprite missingParticle = missingModel.m_6160_();
        List missingModelErrors = SelfTests.stream((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"firmalife").flatMap(SelfTests.states(s -> s.m_60799_() == RenderShape.MODEL && shaper.m_110893_(s) == missingModel)).toList();
        List missingParticleErrors = SelfTests.stream((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"firmalife").flatMap(SelfTests.states(s -> !s.m_60795_() && shaper.m_110882_(s) == missingParticle)).toList();
        return SelfTests.logErrors((String)"{} block states with missing models:", missingModelErrors, (Logger)FirmaLife.LOGGER) | SelfTests.logErrors((String)"{} block states with missing particles:", missingParticleErrors, (Logger)FirmaLife.LOGGER);
    }

    private static boolean validateOwnBlockEntities() {
        return SelfTests.validateBlockEntities((Stream)SelfTests.stream((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"firmalife"), (Logger)LOGGER);
    }

    private static boolean validateTranslationsAndCreativeTabs() {
        Set missingTranslations = Bootstrap.m_135886_();
        ArrayList stacks = new ArrayList();
        HashSet items = new HashSet();
        boolean error = false;
        FLCreativeTabs.fillFirmalifeTab(null, (stack, vis) -> {
            stacks.add(stack);
            items.add(stack.m_41720_());
        });
        Set<Class<PouredGlassBlock>> blocksWithNoCreativeTabItem = Set.of(SnowPileBlock.class, IcePileBlock.class, BloomBlock.class, MoltenBlock.class, TFCLightBlock.class, RockAnvilBlock.class, PouredGlassBlock.class);
        List<Item> missingItems = SelfTests.stream((IForgeRegistry)ForgeRegistries.ITEMS, (String)"firmalife").filter(item -> {
            BlockItem bi;
            return !items.contains(item) && (!(item instanceof BlockItem) || !blocksWithNoCreativeTabItem.contains((bi = (BlockItem)item).m_40614_().getClass()));
        }).toList();
        error |= SelfTests.logErrors((String)"{} items were not found in any TFC creative tab", missingItems, (Logger)LOGGER);
        for (ItemStack stack2 : stacks) {
            error |= SelfTests.validateTranslation((Logger)LOGGER, (Set)missingTranslations, (Component)stack2.m_41786_());
        }
        SoundManager soundManager = Minecraft.m_91087_().m_91106_();
        ForgeRegistries.SOUND_EVENTS.getKeys().forEach(sound -> Optional.ofNullable(soundManager.m_120384_(sound)).map(WeighedSoundEvents::m_120453_).ifPresent(subtitle -> SelfTests.validateTranslation((Logger)LOGGER, (Set)missingTranslations, (Component)subtitle)));
        for (CreativeModeTab tab : CreativeModeTabs.m_257478_()) {
            error |= SelfTests.validateTranslation((Logger)LOGGER, (Set)missingTranslations, (Component)tab.m_40786_());
        }
        return (error |= Stream.of(FoodAge.class, PlanterType.class, CompostTumblerBlockEntity.AdditionType.class).anyMatch(clazz -> SelfTests.validateTranslations((Logger)LOGGER, (Set)missingTranslations, (Class)clazz))) | SelfTests.logErrors((String)"{} missing translation keys:", (Collection)missingTranslations, (Logger)LOGGER);
    }
}

