/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.firmaciv.common.menu;

import com.alekiponi.firmaciv.common.entity.compartment.TFCBarrelCompartmentEntity;
import com.alekiponi.firmaciv.common.menu.FirmacivMenus;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.capabilities.heat.IHeat;
import net.dries007.tfc.common.container.ButtonHandlerContainer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.Nullable;

public class BarrelCompartmentMenu
extends AbstractContainerMenu
implements ButtonHandlerContainer {
    private final TFCBarrelCompartmentEntity barrelCompartment;

    public BarrelCompartmentMenu(int windowId, Inventory inventory, TFCBarrelCompartmentEntity barrelCompartment) {
        super((MenuType)FirmacivMenus.BARREL_COMPARTMENT_MENU.get(), windowId);
        this.barrelCompartment = barrelCompartment;
        barrelCompartment.getCapability(Capabilities.ITEM).ifPresent(handler -> {
            this.m_38897_((Slot)new SlotItemHandler(handler, 0, 35, 20));
            this.m_38897_((Slot)new SlotItemHandler(handler, 1, 35, 54));
            this.m_38897_((Slot)new SlotItemHandler(handler, 2, 89, 37));
        });
        this.addPlayerInventorySlots(inventory);
    }

    static BarrelCompartmentMenu fromNetwork(int windowId, Inventory inventory, FriendlyByteBuf friendlyByteBuf) {
        Entity entity = inventory.f_35978_.m_9236_().m_6815_(friendlyByteBuf.m_130242_());
        if (entity instanceof TFCBarrelCompartmentEntity) {
            TFCBarrelCompartmentEntity barrelCompartment = (TFCBarrelCompartmentEntity)entity;
            return new BarrelCompartmentMenu(windowId, inventory, barrelCompartment);
        }
        throw new IllegalStateException(String.format("%s is not a Barrel compartment", entity));
    }

    public void m_150399_(int slotIndex, int pButton, ClickType pClickType, Player pPlayer) {
        if (slotIndex >= 0 && slotIndex < 3 && this.barrelCompartment.isSealed()) {
            return;
        }
        super.m_150399_(slotIndex, pButton, pClickType, pPlayer);
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (slot.m_6657_()) {
            int containerSlot;
            ItemStack slotStack = slot.m_7993_();
            ItemStack original = slotStack.m_41777_();
            if (this.barrelCompartment.isSealed()) {
                return ItemStack.f_41583_;
            }
            @Nullable IHeat heat = HeatCapability.get((ItemStack)slotStack);
            int n = containerSlot = slotStack.getCapability(Capabilities.FLUID_ITEM).isPresent() && heat != null && heat.getTemperature() == 0.0f ? 0 : 2;
            if (slotIndex < 3 ? !this.m_38903_(slotStack, 3, this.f_38839_.size(), true) : !this.m_38903_(slotStack, containerSlot, containerSlot + 1, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            slot.m_142406_(player, slotStack);
            return original;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player player) {
        return this.barrelCompartment.m_6542_(player);
    }

    public TFCBarrelCompartmentEntity getBarrelCompartment() {
        return this.barrelCompartment;
    }

    private void addPlayerInventorySlots(Inventory inventory) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 96 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)inventory, k, 8 + k * 18, 154));
        }
    }

    public void onButtonPress(int buttonId, @Nullable CompoundTag compoundTag) {
        TFCBarrelCompartmentEntity.toggleSeal(this.barrelCompartment);
    }
}

