/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.firmaciv.common.item;

import com.alekiponi.firmaciv.Firmaciv;
import com.alekiponi.firmaciv.events.config.FirmacivConfig;
import java.text.DecimalFormat;
import net.dries007.tfc.world.ChunkGeneratorExtension;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractNavItem
extends Item {
    private static final float RANDOM_LAT_LON_SCALE = 0.1f;
    private static final int RANDOM_ALT_SCALE = 4;
    private static double temperatureScale = 20000.0;
    private static double rainfallScale = 20000.0;

    public AbstractNavItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public static void updateScales(ServerLevel level) {
        if (!((Boolean)FirmacivConfig.SERVER.changeLatitudeLongitudeBasedOnClimateConfig.get()).booleanValue()) {
            temperatureScale = 20000.0;
            rainfallScale = 20000.0;
            return;
        }
        try {
            ChunkGeneratorExtension extension = (ChunkGeneratorExtension)level.m_7726_().m_8481_();
            temperatureScale = extension.settings().temperatureScale();
            rainfallScale = extension.settings().rainfallScale();
        }
        catch (Exception e) {
            Firmaciv.LOGGER.warn("Did not successfully find temperature or rainfall scale, using defaults for nav tool coordinates.");
            temperatureScale = 20000.0;
            rainfallScale = 20000.0;
            return;
        }
    }

    public static double[] getNavLocation(Vec3 position) {
        double latitude = Math.floor(position.m_82507_(Direction.Axis.Z) - temperatureScale / 2.0) / temperatureScale * 90.0;
        double longitude = Math.floor(position.m_82507_(Direction.Axis.X)) / (rainfallScale / 2.0) * 90.0;
        double altitude = position.m_82507_(Direction.Axis.Y) - 64.0;
        return new double[]{latitude, longitude, altitude};
    }

    public static String[] createNavStrings(Vec3 position) {
        double[] navLocation = AbstractNavItem.getNavLocation(position);
        double latitude = navLocation[NavSelection.LATITUDE.ordinal()] + Math.random() * (double)0.1f;
        double longitude = navLocation[NavSelection.LONGITUDE.ordinal()] + Math.random() * (double)0.1f;
        double altitude = navLocation[NavSelection.ALTITUDE.ordinal()] + Math.random() * 4.0;
        MutableComponent latitudeComponent = Component.m_237115_((String)"latitude");
        MutableComponent longitudeComponent = Component.m_237115_((String)"longitude");
        MutableComponent altitudeComponent = Component.m_237115_((String)"altitude");
        MutableComponent degreesComponent = Component.m_237115_((String)"degrees");
        MutableComponent seaLevelComponent = Component.m_237115_((String)"sea_level");
        MutableComponent northComponent = Component.m_237115_((String)"north");
        MutableComponent southComponent = Component.m_237115_((String)"south");
        MutableComponent eastComponent = Component.m_237115_((String)"east");
        MutableComponent westComponent = Component.m_237115_((String)"west");
        MutableComponent above = Component.m_237115_((String)"above");
        MutableComponent below = Component.m_237115_((String)"below");
        MutableComponent meters = Component.m_237115_((String)"meters");
        DecimalFormat dfAlt = new DecimalFormat("###");
        DecimalFormat df = new DecimalFormat("###.##");
        String latStr = latitudeComponent.getString() + ": " + df.format(Math.abs(latitude)) + " " + degreesComponent.getString() + " " + (latitude > 0.0 ? southComponent.getString() : northComponent.getString());
        String lonStr = longitudeComponent.getString() + ": " + df.format(Math.abs(longitude)) + " " + degreesComponent.getString() + " " + (longitude > 0.0 ? eastComponent.getString() : westComponent.getString());
        String altStr = altitudeComponent.getString() + ": " + dfAlt.format(Math.abs(altitude)) + " " + meters.getString() + " " + (altitude > 0.0 ? above.getString() : below.getString()) + " " + seaLevelComponent.getString();
        String latSim = latitudeComponent.m_130668_(3) + ": " + df.format(Math.abs(latitude)) + " " + (latitude > 0.0 ? southComponent.m_130668_(1) : northComponent.m_130668_(1));
        String lonSim = longitudeComponent.m_130668_(3) + ": " + df.format(Math.abs(longitude)) + " " + (longitude > 0.0 ? eastComponent.m_130668_(1) : westComponent.m_130668_(1));
        String altSim = altitudeComponent.m_130668_(3) + ": " + dfAlt.format(altitude);
        return new String[]{latStr, lonStr, altStr, latSim, lonSim, altSim};
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pHand, NavType navType) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        pPlayer.m_36335_().m_41524_((Item)this, 200);
        if (!pLevel.f_46443_) {
            Vec3 positionClicked = pPlayer.m_146892_();
            AbstractNavItem.outputCoordinate(positionClicked, pPlayer, navType);
        }
        return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)pLevel.m_5776_());
    }

    public static int outputCoordinate(Vec3 position, Player player, NavType navType) {
        String[] navStrings = AbstractNavItem.createNavStrings(position);
        Object locationText = navStrings[NavSelection.LATITUDE.ordinal()];
        Object simpleLocationText = navStrings[NavSelection.LAT_SIMPLE.ordinal()];
        MutableComponent copyMessage = Component.m_237115_((String)"copy_latitude");
        switch (navType) {
            case LAT: {
                locationText = navStrings[NavSelection.LATITUDE.ordinal()];
                simpleLocationText = navStrings[NavSelection.LAT_SIMPLE.ordinal()];
                copyMessage = Component.m_237115_((String)"copy_latitude");
                break;
            }
            case LON: {
                locationText = navStrings[NavSelection.LONGITUDE.ordinal()];
                simpleLocationText = navStrings[NavSelection.LON_SIMPLE.ordinal()];
                copyMessage = Component.m_237115_((String)"copy_longitude");
                break;
            }
            case ALT: {
                locationText = navStrings[NavSelection.ALTITUDE.ordinal()];
                simpleLocationText = navStrings[NavSelection.ALT_SIMPLE.ordinal()];
                copyMessage = Component.m_237115_((String)"copy_altitude");
                break;
            }
            case LAT_LON: {
                locationText = navStrings[NavSelection.LATITUDE.ordinal()] + " | " + navStrings[NavSelection.LONGITUDE.ordinal()];
                simpleLocationText = navStrings[NavSelection.LAT_SIMPLE.ordinal()] + ", " + navStrings[NavSelection.LON_SIMPLE.ordinal()];
                copyMessage = Component.m_237115_((String)"copy_latlon");
                break;
            }
            case LAT_LON_ALT: {
                locationText = navStrings[NavSelection.LATITUDE.ordinal()] + " | " + navStrings[NavSelection.LONGITUDE.ordinal()] + " | " + navStrings[NavSelection.ALTITUDE.ordinal()];
                simpleLocationText = navStrings[NavSelection.LAT_SIMPLE.ordinal()] + ", " + navStrings[NavSelection.LON_SIMPLE.ordinal()] + ", " + navStrings[NavSelection.ALT_SIMPLE.ordinal()];
                copyMessage = Component.m_237115_((String)"copy_latlonalt");
            }
        }
        String finalSimpleLocationText = simpleLocationText;
        MutableComponent finalCopyMessage = copyMessage;
        MutableComponent locationMessage = Component.m_237113_((String)locationText).m_130938_(arg_0 -> AbstractNavItem.lambda$outputCoordinate$0(finalSimpleLocationText, (Component)finalCopyMessage, arg_0));
        player.m_213846_((Component)locationMessage);
        return 0;
    }

    private static /* synthetic */ Style lambda$outputCoordinate$0(String finalSimpleLocationText, Component finalCopyMessage, Style style) {
        return style.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, finalSimpleLocationText)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)finalCopyMessage));
    }

    public static enum NavSelection {
        LATITUDE,
        LONGITUDE,
        ALTITUDE,
        LAT_SIMPLE,
        LON_SIMPLE,
        ALT_SIMPLE;

    }

    public static enum NavType {
        LAT,
        LON,
        ALT,
        LAT_LON,
        LAT_LON_ALT;

    }
}

