/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.firmaciv.common.entity.vehicle;

import com.alekiponi.alekiships.common.entity.vehicle.AbstractAlekiBoatEntity;
import com.alekiponi.alekiships.common.entity.vehiclecapability.IAllowFallDamage;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.AbstractCompartmentEntity;
import com.alekiponi.alekiships.util.BoatMaterial;
import com.alekiponi.firmaciv.common.item.FirmacivItems;
import com.alekiponi.firmaciv.util.Helper;
import com.alekiponi.firmaciv.util.KayakMaterial;
import javax.annotation.Nullable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.ItemHandlerHelper;

public class KayakEntity
extends AbstractAlekiBoatEntity
implements IAllowFallDamage {
    public final int PASSENGER_NUMBER = 1;
    protected final float DAMAGE_THRESHOLD = 10.0f;
    protected final float DAMAGE_RECOVERY = 1.0f;
    public final int[] COMPARTMENTS = new int[]{0};
    protected final float PASSENGER_SIZE_LIMIT = 0.6f;
    protected final float HUNGER_FACTOR = 0.02f;

    public KayakEntity(EntityType<? extends AbstractAlekiBoatEntity> entityType, Level level) {
        super(entityType, level, (BoatMaterial)KayakMaterial.KAYAK);
    }

    public float getPassengerSizeLimit() {
        return this.PASSENGER_SIZE_LIMIT;
    }

    public int[] getCompartmentIndices() {
        return this.COMPARTMENTS;
    }

    public int[][] getCompartmentRotationsArray() {
        return new int[0][];
    }

    @Nullable
    public Entity getPilotVehiclePartAsEntity() {
        if (this.m_20160_() && this.m_20197_().size() == this.getMaxPassengers()) {
            return (Entity)this.m_20197_().get(0);
        }
        return null;
    }

    public void m_8119_() {
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - this.getDamageRecovery());
        }
        Helper.causeExhaustionWhilePaddlingRowing(this, 0.02f);
        super.m_8119_();
    }

    protected double windDriftMultiplier() {
        return 0.3;
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        boolean instantKill;
        if (this.m_6673_(damageSource)) {
            return false;
        }
        if (this.m_9236_().f_46443_ || this.m_213877_()) {
            return true;
        }
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() + amount * 10.0f);
        this.m_5834_();
        this.m_146852_(GameEvent.f_223706_, damageSource.m_7639_());
        boolean bl = instantKill = damageSource.m_7639_() instanceof Player && ((Player)damageSource.m_7639_()).m_150110_().f_35937_;
        if (instantKill || this.getDamage() > this.getDamageThreshold()) {
            if (!instantKill && this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
                Entity entity = damageSource.m_7639_();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.getDropItem().m_7968_());
                } else {
                    this.m_19998_((ItemLike)this.getDropItem());
                }
            }
            this.m_146870_();
        }
        return true;
    }

    public AbstractCompartmentEntity.RidingPose[] getRidingPoses() {
        if (this.ridingPoses.length == 0 || this.ridingPoses[0] == null) {
            AbstractCompartmentEntity.RidingPose[] poses = new AbstractCompartmentEntity.RidingPose[this.getMaxPassengers()];
            poses[0] = AbstractCompartmentEntity.RidingPose.ULTRA_COMPACT;
            this.ridingPoses = poses;
        }
        return this.ridingPoses;
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        return InteractionResult.PASS;
    }

    public int getMaxPassengers() {
        return this.PASSENGER_NUMBER;
    }

    public int[] getColliderIndices() {
        return new int[0];
    }

    public int getCompartmentRotation(int i) {
        return 0;
    }

    protected Vec3 positionRiderByIndex(int index) {
        float localX = 0.0f;
        float localZ = 0.0f;
        float localY = (float)(this.m_213877_() ? (double)0.01f : this.m_6048_());
        return new Vec3((double)localX, (double)localY, (double)localZ);
    }

    public float getDamageThreshold() {
        return this.DAMAGE_THRESHOLD;
    }

    public float getDamageRecovery() {
        return this.DAMAGE_RECOVERY;
    }

    protected float getPaddleMultiplier() {
        Player player;
        float paddleMultiplier = 1.0f;
        LivingEntity livingEntity = this.m_6688_();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).m_21055_((Item)FirmacivItems.KAYAK_PADDLE.get())) {
            paddleMultiplier = 2.0f;
        }
        return paddleMultiplier;
    }

    protected float getMomentumSubtractor() {
        return 0.0f;
    }

    public Item getDropItem() {
        return (Item)FirmacivItems.KAYAK.get();
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)FirmacivItems.KAYAK.get());
    }

    public float getStepHeight() {
        return 0.6f;
    }
}

