/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.firmaciv.common.entity.vehicle;

import com.alekiponi.alekiships.common.entity.vehicle.AbstractAlekiBoatEntity;
import com.alekiponi.alekiships.common.entity.vehiclecapability.IAllowFallDamage;
import com.alekiponi.alekiships.common.entity.vehiclecapability.IHaveCleats;
import com.alekiponi.alekiships.common.entity.vehiclecapability.IHaveColliders;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.AbstractCompartmentEntity;
import com.alekiponi.alekiships.util.BoatMaterial;
import com.alekiponi.firmaciv.common.item.FirmacivItems;
import com.alekiponi.firmaciv.util.Helper;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class CanoeEntity
extends AbstractAlekiBoatEntity
implements IHaveCleats,
IHaveColliders,
IAllowFallDamage {
    private static final EntityDataAccessor<Integer> DATA_ID_LENGTH = SynchedEntityData.m_135353_(CanoeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final int PASSENGER_NUMBER = 5;
    public final int[] CLEATS = new int[]{2};
    public final int[] COMPARTMENTS = new int[]{0, 1};
    protected final float DAMAGE_THRESHOLD = 80.0f;
    protected final float DAMAGE_RECOVERY = 2.0f;
    protected final float PASSENGER_SIZE_LIMIT = 0.9f;
    protected final float HUNGER_FACTOR = 0.02f;
    public final int[] COLLIDERS = new int[]{3, 4};

    public CanoeEntity(EntityType<? extends CanoeEntity> entityType, Level level, BoatMaterial boatMaterial) {
        super(entityType, level, boatMaterial);
    }

    public void m_8119_() {
        super.m_8119_();
        Helper.causeExhaustionWhilePaddlingRowing(this, 0.02f);
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_150930_((Item)FirmacivItems.CANOE_PADDLE.get()) && player.m_7500_() && player.m_36341_()) {
            if (this.getLength() == 5) {
                this.setLength(3);
            } else {
                this.setLength(this.getLength() + 1);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6096_(player, hand);
    }

    public AbstractCompartmentEntity.RidingPose[] getRidingPoses() {
        if (this.ridingPoses.length == 0 || this.ridingPoses[0] == null) {
            AbstractCompartmentEntity.RidingPose[] poses = new AbstractCompartmentEntity.RidingPose[this.getMaxPassengers()];
            for (int i = 0; i < this.getMaxPassengers(); ++i) {
                poses[i] = AbstractCompartmentEntity.RidingPose.COMPACT;
            }
            this.ridingPoses = poses;
        }
        return this.ridingPoses;
    }

    public float getPassengerSizeLimit() {
        return 0.9f;
    }

    public int[][] getCompartmentRotationsArray() {
        return new int[0][];
    }

    public int[] getCompartmentIndices() {
        return this.COMPARTMENTS;
    }

    public int[] getColliderIndices() {
        return this.COLLIDERS;
    }

    public int getCompartmentRotation(int i) {
        return 0;
    }

    protected float getPaddleMultiplier() {
        Player player;
        float paddleMultiplier = 1.0f;
        LivingEntity livingEntity = this.m_6688_();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).m_21055_((Item)FirmacivItems.CANOE_PADDLE.get())) {
            paddleMultiplier = 1.6f;
        }
        int i = 0;
        for (Entity entity : this.m_146897_()) {
            Player player2;
            if (!(entity instanceof Player) || !(player2 = (Player)entity).m_21055_((Item)FirmacivItems.CANOE_PADDLE.get())) continue;
            ++i;
        }
        if (i == 2) {
            paddleMultiplier = 2.0f;
        }
        return paddleMultiplier;
    }

    protected float getMomentumSubtractor() {
        return 0.01f;
    }

    @Nullable
    public Entity getPilotVehiclePartAsEntity() {
        if (this.m_20160_() && this.m_20197_().size() == this.getMaxPassengers()) {
            return (Entity)this.m_20197_().get(1);
        }
        return null;
    }

    protected Vec3 positionRiderByIndex(int index) {
        float localX = 0.0f;
        float localZ = 0.0f;
        float localY = (float)(this.m_213877_() ? (double)0.01f : this.m_6048_());
        switch (index) {
            case 0: {
                localZ = 0.0f;
                localY += 0.0625f;
                if (this.getLength() == 3) {
                    localX = 0.3f;
                    break;
                }
                if (this.getLength() == 4) {
                    localX = 0.4f;
                    break;
                }
                if (this.getLength() != 5) break;
                localX = 1.0f;
                break;
            }
            case 1: {
                localZ = 0.0f;
                localY += 0.0625f;
                if (this.getLength() == 3) {
                    localX = -0.7f;
                    break;
                }
                if (this.getLength() == 4) {
                    localX = -0.8f;
                    break;
                }
                if (this.getLength() != 5) break;
                localX = -1.3f;
                break;
            }
            case 2: {
                localZ = 0.0f;
                localY += 0.45f;
                if (this.getLength() == 3) {
                    localX = 1.0f;
                    break;
                }
                if (this.getLength() == 4) {
                    localX = 1.5f;
                    break;
                }
                if (this.getLength() != 5) break;
                localX = 2.0f;
                break;
            }
            case 3: {
                localZ = 0.0f;
                localY = (float)((double)localY + 0.0);
                if (this.getLength() == 3) {
                    localX = 0.7f;
                    break;
                }
                if (this.getLength() == 4) {
                    localX = 1.3f;
                    break;
                }
                if (this.getLength() != 5) break;
                localX = 1.7f;
                break;
            }
            case 4: {
                localZ = 0.0f;
                localY = (float)((double)localY + 0.0);
                if (this.getLength() == 3) {
                    localX = -0.7f;
                    break;
                }
                if (this.getLength() == 4) {
                    localX = -1.3f;
                    break;
                }
                if (this.getLength() != 5) break;
                localX = -1.7f;
            }
        }
        return new Vec3((double)localX, (double)localY, (double)localZ);
    }

    public Item getDropItem() {
        return super.getDropItem();
    }

    public void setLength(int length) {
        this.f_19804_.m_135381_(DATA_ID_LENGTH, (Object)Mth.m_14045_((int)length, (int)3, (int)5));
    }

    public int getLength() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_LENGTH);
    }

    public int getMaxPassengers() {
        return 5;
    }

    public float getDamageThreshold() {
        return this.DAMAGE_THRESHOLD;
    }

    public float getDamageRecovery() {
        return this.DAMAGE_RECOVERY;
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)this.getDropItem());
    }

    public float[] getDefaultColliderDimensions() {
        return new float[]{1.125f, 0.625f};
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_LENGTH, (Object)3);
    }

    protected double windDriftMultiplier() {
        return 0.5;
    }

    protected void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setLength(compoundTag.m_128451_("length"));
    }

    protected void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("length", this.getLength());
    }

    public float getStepHeight() {
        return 0.0f;
    }

    public int[] getCleatIndices() {
        return this.CLEATS;
    }

    public float getCleatMovementMultiplier() {
        return 0.0f;
    }
}

