/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.firmaciv.common.entity.compartment;

import com.alekiponi.alekiships.common.entity.vehiclehelper.CompartmentType;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.AbstractCompartmentEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.BlockCompartment;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.CompartmentCloneable;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.SimpleBlockMenuCompartment;
import com.alekiponi.alekiships.util.CommonHelper;
import com.alekiponi.firmaciv.common.menu.BarrelCompartmentMenu;
import com.alekiponi.firmaciv.network.ClientBoundBarrelCompartmentUpdatePacket;
import com.alekiponi.firmaciv.network.PacketHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.devices.BarrelBlock;
import net.dries007.tfc.common.capabilities.PartialFluidHandler;
import net.dries007.tfc.common.capabilities.PartialItemHandler;
import net.dries007.tfc.common.capabilities.SidedHandler;
import net.dries007.tfc.common.capabilities.size.IItemSize;
import net.dries007.tfc.common.capabilities.size.ItemSizeManager;
import net.dries007.tfc.common.capabilities.size.Size;
import net.dries007.tfc.common.capabilities.size.Weight;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.recipes.BarrelRecipe;
import net.dries007.tfc.common.recipes.SealedBarrelRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.inventory.BarrelInventory;
import net.dries007.tfc.common.recipes.inventory.EmptyInventory;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.CalendarTransaction;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TFCBarrelCompartmentEntity
extends AbstractCompartmentEntity
implements BlockCompartment,
CompartmentCloneable,
SimpleBlockMenuCompartment,
MenuConstructor,
Container,
IEntityAdditionalSpawnData {
    private static final byte RESET_RECIPE_EVENT = 42;
    private static final EntityDataAccessor<BlockState> DATA_ID_DISPLAY_BLOCK = SynchedEntityData.m_135353_(TFCBarrelCompartmentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135034_);
    private final BarrelCompartmentInventory inventory = new BarrelCompartmentInventory(this);
    private final SidedHandler.Builder<IItemHandler> sidedInventory = new SidedHandler.Builder((Object)this.inventory);
    private final SidedHandler.Builder<IFluidHandler> sidedFluidInventory = new SidedHandler.Builder((Object)this.inventory);
    private final NonNullList<ItemStack> itemStacks = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
    @Nullable
    private ResourceLocation recipeName;
    @Nullable
    private SealedBarrelRecipe recipe;
    private long lastUpdateTick = Integer.MIN_VALUE;
    private long sealedTick;
    private long recipeTick;
    private int soundCooldownTicks = 0;
    private boolean needsInstantRecipeUpdate;

    public TFCBarrelCompartmentEntity(CompartmentType<? extends TFCBarrelCompartmentEntity> entityType, Level level) {
        super(entityType, level);
    }

    public TFCBarrelCompartmentEntity(CompartmentType<? extends TFCBarrelCompartmentEntity> compartmentType, Level level, ItemStack itemStack) {
        super(compartmentType, level);
        CompoundTag blockEntityTag;
        Item item = itemStack.m_41720_();
        if (!(item instanceof BlockItem)) {
            return;
        }
        BlockItem blockItem = (BlockItem)item;
        this.setDisplayBlockState(blockItem.m_40614_().m_49966_());
        if (itemStack.m_41788_()) {
            this.m_6593_(itemStack.m_41786_());
        }
        if ((blockEntityTag = BlockItem.m_186336_((ItemStack)itemStack)) != null) {
            this.readCommonSaveData(blockEntityTag);
            this.setDisplayBlockState((BlockState)this.getDisplayBlockState().m_61124_((Property)BarrelBlock.SEALED, (Comparable)Boolean.valueOf(true)));
        }
    }

    public static void toggleSeal(TFCBarrelCompartmentEntity barrelCompartment) {
        boolean previousSealed = barrelCompartment.isSealed();
        if (previousSealed) {
            barrelCompartment.onUnseal();
        } else {
            barrelCompartment.onSeal();
        }
    }

    private static void trySendUpdatePacket(TFCBarrelCompartmentEntity barrelCompartment) {
        if (barrelCompartment.m_9236_().f_46443_) {
            return;
        }
        PacketHandler.send(PacketDistributor.TRACKING_ENTITY.with(() -> barrelCompartment), new ClientBoundBarrelCompartmentUpdatePacket(barrelCompartment, barrelCompartment.inventory.getFluid(), barrelCompartment.inventory.getStackInSlot(2)));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_DISPLAY_BLOCK, (Object)Blocks.f_50016_.m_49966_());
    }

    public void m_8119_() {
        List<ItemStack> excess;
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.recipeName != null) {
            this.recipe = this.m_9236_().m_7465_().m_44043_(this.recipeName).map(recipe -> {
                SealedBarrelRecipe sealedRecipe;
                return recipe instanceof SealedBarrelRecipe ? (sealedRecipe = (SealedBarrelRecipe)recipe) : null;
            }).orElse(null);
            this.recipeName = null;
        }
        this.checkForCalendarUpdate();
        if (this.m_9236_().m_46467_() % 5L == 0L) {
            this.updateFluidIOSlots();
        }
        if (!(excess = this.inventory.excess).isEmpty() && this.inventory.getStackInSlot(2).m_41619_()) {
            this.inventory.setStackInSlot(2, excess.remove(0));
        }
        SealedBarrelRecipe recipe2 = this.recipe;
        boolean sealed = this.isSealed();
        if (recipe2 != null && sealed) {
            int durationSealed = (int)(Calendars.SERVER.getTicks() - this.recipeTick);
            if (!recipe2.isInfinite() && durationSealed > recipe2.getDuration()) {
                if (recipe2.matches((BarrelInventory)this.inventory, this.m_9236_())) {
                    recipe2.assembleOutputs((BarrelInventory)this.inventory);
                    this.playSound(recipe2.getCompleteSound(), SoundSource.BLOCKS, 1.0f + this.f_19796_.m_188501_(), this.f_19796_.m_188501_() + 0.7f + 0.3f);
                }
                this.updateRecipe();
                SealedBarrelRecipe knownRecipe = this.recipe;
                if (knownRecipe != null) {
                    knownRecipe.onSealed((BarrelInventory)this.inventory);
                }
            }
        }
        if (this.needsInstantRecipeUpdate) {
            this.needsInstantRecipeUpdate = false;
            if (this.inventory.excess.isEmpty()) {
                RecipeManager recipeManager = this.m_9236_().m_7465_();
                Optional.empty().or(() -> recipeManager.m_44015_((RecipeType)TFCRecipeTypes.BARREL_INSTANT.get(), (Container)this.inventory, this.m_9236_())).or(() -> recipeManager.m_44015_((RecipeType)TFCRecipeTypes.BARREL_INSTANT_FLUID.get(), (Container)this.inventory, this.m_9236_())).ifPresent(instantRecipe -> {
                    instantRecipe.assembleOutputs((BarrelInventory)this.inventory);
                    if (this.soundCooldownTicks == 0) {
                        Level patt12025$temp;
                        this.playSound(instantRecipe.getCompleteSound(), SoundSource.BLOCKS, 1.0f + this.f_19796_.m_188501_(), this.f_19796_.m_188501_() + 0.7f + 0.3f);
                        this.soundCooldownTicks = 5;
                        if (instantRecipe.getCompleteSound() == SoundEvents.f_11937_ && (patt12025$temp = this.m_9236_()) instanceof ServerLevel) {
                            ServerLevel server = (ServerLevel)patt12025$temp;
                            server.m_8767_((ParticleOptions)((SimpleParticleType)TFCParticles.BUBBLE.get()), this.m_20185_() + (double)this.f_19796_.m_188501_() * 0.375 - 0.1875, this.m_20186_() + 0.9375, this.m_20189_() + (double)this.f_19796_.m_188501_() * 0.375 - 0.1875, 6, 0.0, 0.0, 0.0, 1.0);
                            server.m_8767_((ParticleOptions)((SimpleParticleType)TFCParticles.STEAM.get()), this.m_20185_() + (double)this.f_19796_.m_188501_() * 0.375 - 0.1875, this.m_20186_() + 0.9375, this.m_20189_() + (double)this.f_19796_.m_188501_() * 0.375 - 0.1875, 6, 0.0, 0.0, 0.0, 1.0);
                        }
                    }
                });
            }
        }
        if (this.soundCooldownTicks > 0) {
            --this.soundCooldownTicks;
        }
        if (this.m_9236_().m_46467_() % 20L == 0L && !sealed) {
            Helpers.gatherAndConsumeItems((Level)this.m_9236_(), (AABB)new AABB(0.25, 0.0625, 0.25, 0.75, 0.9375, 0.75).m_82383_(this.m_20182_()), (IItemHandler)this.inventory, (int)2, (int)2);
        }
        if (!sealed && this.m_9236_().m_46467_() % 4L == 0L && this.m_9236_().m_46758_(this.m_20183_().m_7494_())) {
            this.inventory.fill(new FluidStack((Fluid)Fluids.f_76193_, 1), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ItemStack heldStack = player.m_21120_(hand);
        if (heldStack.m_41619_() && player.m_6144_()) {
            TFCBarrelCompartmentEntity.toggleSeal(this);
            this.playSound(SoundEvents.f_12635_, SoundSource.BLOCKS, 1.0f, 0.85f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (!this.isSealed() && FluidHelpers.transferBetweenBlockHandlerAndItem((ItemStack)heldStack, (IFluidHandler)this.inventory, (Level)this.m_9236_(), (BlockPos)this.m_20183_(), (FluidHelpers.AfterTransfer)new FluidHelpers.AfterTransferWithPlayer(player, hand))) {
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (!this.m_9236_().f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)this.getMenuProvider(), friendlyByteBuf -> friendlyByteBuf.m_130130_(this.m_19879_()));
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    protected ItemStack getDropStack() {
        ItemStack dropStack = new ItemStack((ItemLike)this.getDisplayBlockState().m_60734_());
        if (!this.isSealed()) {
            return dropStack;
        }
        CompoundTag compoundTag = new CompoundTag();
        this.addCommonSaveData(compoundTag);
        if (!compoundTag.m_128456_()) {
            dropStack.m_41700_("BlockEntityTag", (Tag)compoundTag);
        }
        return dropStack;
    }

    protected void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        BlockCompartment.saveBlockstate((BlockCompartment)this, (CompoundTag)compoundTag);
        this.addCommonSaveData(compoundTag);
    }

    protected void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        BlockCompartment.readBlockstate((BlockCompartment)this, (CompoundTag)compoundTag);
        this.readCommonSaveData(compoundTag);
    }

    private void readCommonSaveData(CompoundTag compoundTag) {
        this.lastUpdateTick = compoundTag.m_128454_("lastUpdateTick");
        this.sealedTick = compoundTag.m_128454_("sealedTick");
        this.recipeTick = compoundTag.m_128454_("recipeTick");
        this.recipe = null;
        this.recipeName = null;
        if (compoundTag.m_128425_("recipe", 8)) {
            this.recipeName = new ResourceLocation(compoundTag.m_128461_("recipe"));
            this.recipe = this.m_9236_().m_7465_().m_44043_(this.recipeName).map(recipe -> {
                SealedBarrelRecipe barrelRecipe;
                return recipe instanceof SealedBarrelRecipe ? (barrelRecipe = (SealedBarrelRecipe)recipe) : null;
            }).orElse(null);
        }
        this.inventory.deserializeNBT(compoundTag.m_128469_("inventory"));
    }

    private void addCommonSaveData(CompoundTag compoundTag) {
        compoundTag.m_128356_("lastUpdateTick", this.lastUpdateTick);
        compoundTag.m_128356_("sealedTick", this.sealedTick);
        compoundTag.m_128356_("recipeTick", this.recipeTick);
        if (this.recipe != null) {
            compoundTag.m_128359_("recipe", this.recipe.m_6423_().toString());
        } else if (this.recipeName != null) {
            compoundTag.m_128359_("recipeName", this.recipeName.toString());
        }
        compoundTag.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
    }

    public CompoundTag saveForItemStack() {
        CompoundTag compoundTag = new CompoundTag();
        this.addCommonSaveData(compoundTag);
        if (this.m_8077_()) {
            compoundTag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.m_7770_()));
        }
        return compoundTag;
    }

    protected void destroy(DamageSource damageSource) {
        if (this.isSealed()) {
            super.destroy(damageSource);
            return;
        }
        CommonHelper.dropContents((Level)this.m_9236_(), (double)this.m_20185_(), (double)CommonHelper.maxHeightOfCollidableEntities((Entity)this), (double)this.m_20189_(), (Container)this);
        super.destroy(damageSource);
    }

    private void updateFluidIOSlots() {
        ItemStack input = this.inventory.getStackInSlot(0);
        if (!input.m_41619_() && this.inventory.getStackInSlot(1).m_41619_()) {
            FluidHelpers.transferBetweenBlockHandlerAndItem((ItemStack)input, (IFluidHandler)this.inventory, (Level)this.m_9236_(), (BlockPos)this.m_20183_(), (newOriginalStack, newContainerStack) -> {
                if (newContainerStack.m_41619_()) {
                    this.inventory.setStackInSlot(0, ItemStack.f_41583_);
                    this.inventory.setStackInSlot(1, newOriginalStack);
                } else {
                    this.inventory.setStackInSlot(0, newOriginalStack);
                    this.inventory.setStackInSlot(1, newContainerStack);
                }
            });
        }
    }

    private void checkForCalendarUpdate() {
        if (!this.m_9236_().f_46443_) {
            long thisTick = Calendars.SERVER.getTicks();
            long lastTick = this.getLastCalendarUpdateTick();
            long tickDelta = thisTick - lastTick;
            if (lastTick != Integer.MIN_VALUE && tickDelta != 1L) {
                this.onCalendarUpdate(tickDelta - 1L);
            }
            this.setLastCalendarUpdateTick(thisTick);
        }
    }

    private void onCalendarUpdate(long ticks) {
        try (CalendarTransaction calendarTransaction = Calendars.SERVER.transaction();){
            calendarTransaction.add(-ticks);
            this.updateRecipe();
        }
        if (!this.canModify() || this.recipe == null || this.recipe.isInfinite()) {
            return;
        }
        long currentTick = Calendars.SERVER.getTicks();
        for (long lastKnownTick = this.recipeTick + (long)this.recipe.getDuration(); lastKnownTick < currentTick; lastKnownTick += (long)this.recipe.getDuration()) {
            long offset = currentTick - lastKnownTick;
            assert (offset >= 0L);
            try (CalendarTransaction calendarTransaction = Calendars.SERVER.transaction();){
                calendarTransaction.add(-offset);
                SealedBarrelRecipe recipe = this.recipe;
                if (recipe.matches((BarrelInventory)this.inventory, null)) {
                    recipe.assembleOutputs((BarrelInventory)this.inventory);
                }
                this.updateRecipe();
            }
            SealedBarrelRecipe knownRecipe = this.recipe;
            if (knownRecipe == null) {
                return;
            }
            knownRecipe.onSealed((BarrelInventory)this.inventory);
            if (!knownRecipe.isInfinite()) continue;
            return;
        }
    }

    private void updateRecipe() {
        SealedBarrelRecipe oldRecipe = this.recipe;
        if (this.inventory.excess.isEmpty()) {
            this.recipe = this.m_9236_().m_7465_().m_44015_((RecipeType)TFCRecipeTypes.BARREL_SEALED.get(), (Container)this.inventory, this.m_9236_()).orElse(null);
            if (!(this.recipe == null || oldRecipe == this.recipe || oldRecipe != null && oldRecipe.m_6423_().equals((Object)this.recipe.m_6423_()))) {
                this.recipeTick = Calendars.get((LevelReader)this.m_9236_()).getTicks();
            }
        }
    }

    public void onSeal() {
        if (!this.m_9236_().f_46443_) {
            for (int slotIndex : new int[]{0, 1}) {
                Containers.m_18992_((Level)this.m_9236_(), (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (ItemStack)this.inventory.getStackInSlot(slotIndex));
            }
        }
        this.sealedTick = Calendars.get((LevelReader)this.m_9236_()).getTicks();
        this.updateRecipe();
        if (this.recipe != null) {
            this.recipe.onSealed((BarrelInventory)this.inventory);
            this.recipeTick = this.sealedTick;
        }
        this.setDisplayBlockState((BlockState)this.getDisplayBlockState().m_61124_((Property)BarrelBlock.SEALED, (Comparable)Boolean.valueOf(true)));
        this.playSound((SoundEvent)TFCSounds.CLOSE_BARREL.get(), SoundSource.BLOCKS, 1.0f + this.f_19796_.m_188501_(), this.f_19796_.m_188501_() + 0.7f + 0.3f);
    }

    public void onUnseal() {
        this.recipeTick = 0L;
        this.sealedTick = 0L;
        this.m_9236_().m_7605_((Entity)this, (byte)42);
        if (this.recipe != null) {
            this.recipe.onUnsealed((BarrelInventory)this.inventory);
        }
        this.updateRecipe();
        this.setDisplayBlockState((BlockState)this.getDisplayBlockState().m_61124_((Property)BarrelBlock.SEALED, (Comparable)Boolean.valueOf(false)));
        this.playSound((SoundEvent)TFCSounds.OPEN_BARREL.get(), SoundSource.BLOCKS, 1.0f + this.f_19796_.m_188501_(), this.f_19796_.m_188501_() + 0.7f + 0.3f);
    }

    public void m_7822_(byte id) {
        if (id == 42) {
            this.recipeTick = 0L;
        }
        super.m_7822_(id);
    }

    @OnlyIn(value=Dist.CLIENT)
    public final long getRemainingTicks() {
        if (!this.m_9236_().f_46443_) {
            return 0L;
        }
        if (this.recipe == null) {
            this.recipe = this.m_9236_().m_7465_().m_44015_((RecipeType)TFCRecipeTypes.BARREL_SEALED.get(), (Container)this.inventory, this.m_9236_()).orElse(null);
        }
        if (this.recipe != null) {
            return (long)this.recipe.getDuration() - (Calendars.get((LevelReader)this.m_9236_()).getTicks() - this.recipeTick);
        }
        return 0L;
    }

    @Nullable
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)this.getDisplayBlockState().m_60734_());
    }

    protected void onPlaced() {
        BlockCompartment.playPlaceSound((BlockCompartment)this);
    }

    protected void onHurt(DamageSource damageSource) {
        BlockCompartment.playHitSound((BlockCompartment)this);
    }

    protected void onBreak() {
        CommonHelper.dropContents((Level)this.m_9236_(), (double)this.m_20185_(), (double)CommonHelper.maxHeightOfCollidableEntities((Entity)this), (double)this.m_20189_(), (Container)this);
        BlockCompartment.playBreakSound((BlockCompartment)this);
    }

    @Nullable
    public final BarrelRecipe getRecipe() {
        return this.recipe;
    }

    public final long getSealedTick() {
        return this.sealedTick;
    }

    public final long getRecipeTick() {
        return this.recipeTick;
    }

    public boolean canModify() {
        return !this.isSealed();
    }

    public final boolean isSealed() {
        return (Boolean)this.getDisplayBlockState().m_61143_((Property)BarrelBlock.SEALED);
    }

    public final long getLastCalendarUpdateTick() {
        return this.lastUpdateTick;
    }

    public final void setLastCalendarUpdateTick(long tick) {
        this.lastUpdateTick = tick;
    }

    public final BlockState getDisplayBlockState() {
        return (BlockState)this.f_19804_.m_135370_(DATA_ID_DISPLAY_BLOCK);
    }

    public final void setDisplayBlockState(BlockState blockState) {
        this.f_19804_.m_135381_(DATA_ID_DISPLAY_BLOCK, (Object)blockState);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (this.m_6084_()) {
            if (capability == ForgeCapabilities.FLUID_HANDLER) {
                return this.sidedFluidInventory.getSidedHandler(facing).cast();
            }
            if (capability == ForgeCapabilities.ITEM_HANDLER) {
                return this.sidedInventory.getSidedHandler(facing).cast();
            }
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.sidedInventory.invalidate();
        this.sidedFluidInventory.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        if (((Boolean)TFCConfig.SERVER.barrelEnableAutomation.get()).booleanValue()) {
            this.sidedInventory.on((Object)new PartialItemHandler((IItemHandlerModifiable)this.inventory).insert(new int[]{0}).extract(new int[]{1}), (Predicate)Direction.Plane.HORIZONTAL).on((Object)new PartialItemHandler((IItemHandlerModifiable)this.inventory).insert(new int[]{2}), new Direction[]{Direction.UP}).on((Object)new PartialItemHandler((IItemHandlerModifiable)this.inventory).extract(new int[]{2}), new Direction[]{Direction.UP.m_122424_()});
            this.sidedFluidInventory.on((Object)new PartialFluidHandler((IFluidHandler)this.inventory).insert(), new Direction[]{Direction.UP}).on((Object)new PartialFluidHandler((IFluidHandler)this.inventory).extract(), direction -> direction != Direction.UP);
        }
    }

    public final int m_6643_() {
        return 3;
    }

    public final boolean m_7983_() {
        return this.itemStacks.stream().allMatch(ItemStack::m_41619_);
    }

    public final ItemStack m_8020_(int slotIndex) {
        return (ItemStack)this.itemStacks.get(slotIndex);
    }

    public final ItemStack m_7407_(int slotIndex, int amount) {
        return ContainerHelper.m_18969_(this.itemStacks, (int)slotIndex, (int)amount);
    }

    public final ItemStack m_8016_(int slotIndex) {
        return ContainerHelper.m_18966_(this.itemStacks, (int)slotIndex);
    }

    public final void m_6836_(int slotIndex, ItemStack itemStack) {
        this.itemStacks.set(slotIndex, (Object)itemStack);
    }

    public void m_6596_() {
        this.needsInstantRecipeUpdate = true;
        this.updateRecipe();
        TFCBarrelCompartmentEntity.trySendUpdatePacket(this);
    }

    public boolean m_6542_(Player player) {
        return !this.m_213877_() && this.m_20182_().m_82509_((Position)player.m_20182_(), 8.0);
    }

    public MenuProvider getMenuProvider() {
        return new SimpleMenuProvider((MenuConstructor)this, this.m_5446_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
        return new BarrelCompartmentMenu(id, playerInventory, this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public final void syncContents(FluidStack fluid, ItemStack visibleStack) {
        this.inventory.setFluid(fluid);
        this.inventory.setStackInSlot(2, visibleStack);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeFluidStack(this.inventory.getFluid());
        buffer.m_130055_(this.inventory.getStackInSlot(2));
        buffer.m_130103_(this.recipeTick);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.inventory.setFluid(additionalData.readFluidStack());
        this.inventory.setStackInSlot(2, additionalData.m_130267_());
        this.recipeTick = additionalData.m_130258_();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public final void m_6211_() {
        this.itemStacks.clear();
    }

    public static final class BarrelCompartmentInventory
    extends FluidTank
    implements BarrelInventory,
    EmptyInventory {
        private final TFCBarrelCompartmentEntity barrelCompartment;
        private final List<ItemStack> excess;
        private boolean mutable;

        public BarrelCompartmentInventory(TFCBarrelCompartmentEntity barrelCompartment) {
            super(((Integer)Helpers.getValueOrDefault((ForgeConfigSpec.ConfigValue)TFCConfig.SERVER.barrelCapacity)).intValue(), fluidStack -> Helpers.isFluid((Fluid)fluidStack.getFluid(), (TagKey)TFCTags.Fluids.USABLE_IN_BARREL));
            this.barrelCompartment = barrelCompartment;
            this.excess = new ArrayList<ItemStack>();
        }

        public void whileMutable(Runnable action) {
            try {
                this.mutable = true;
                action.run();
            }
            finally {
                this.mutable = false;
            }
        }

        public void insertItemWithOverflow(ItemStack itemStack) {
            ItemStack remainder = this.insertItem(2, itemStack, false);
            if (!remainder.m_41619_()) {
                this.excess.add(remainder);
            }
        }

        protected void onContentsChanged() {
            this.barrelCompartment.m_6596_();
        }

        public int fill(FluidStack fluidStack, IFluidHandler.FluidAction action) {
            return this.canModify() ? super.fill(fluidStack, action) : 0;
        }

        public FluidStack drain(FluidStack fluidStack, IFluidHandler.FluidAction action) {
            return this.canModify() ? super.drain(fluidStack, action) : FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return this.canModify() ? super.drain(maxDrain, action) : FluidStack.EMPTY;
        }

        public int getSlots() {
            return this.barrelCompartment.m_6643_();
        }

        public ItemStack getStackInSlot(int slotIndex) {
            return this.barrelCompartment.m_8020_(slotIndex);
        }

        public ItemStack insertItem(int slotIndex, ItemStack insertStack, boolean simulate) {
            boolean reachedLimit;
            if (!this.canModify()) {
                return insertStack;
            }
            if (insertStack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            if (!this.isItemValid(slotIndex, insertStack)) {
                return insertStack;
            }
            ItemStack existing = this.getStackInSlot(slotIndex);
            int extractLimit = Math.min(this.getSlotLimit(slotIndex), insertStack.m_41741_());
            if (!existing.m_41619_()) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)insertStack, (ItemStack)existing)) {
                    return insertStack;
                }
                extractLimit -= existing.m_41613_();
            }
            if (extractLimit <= 0) {
                return insertStack;
            }
            boolean bl = reachedLimit = insertStack.m_41613_() > extractLimit;
            if (!simulate) {
                if (existing.m_41619_()) {
                    this.setStackInSlot(slotIndex, reachedLimit ? insertStack.m_255036_(extractLimit) : insertStack);
                } else {
                    existing.m_41769_(reachedLimit ? extractLimit : insertStack.m_41613_());
                    this.barrelCompartment.m_6596_();
                }
            }
            return reachedLimit ? insertStack.m_255036_(insertStack.m_41613_() - extractLimit) : ItemStack.f_41583_;
        }

        public ItemStack extractItem(int slotIndex, int amount, boolean simulate) {
            if (!this.canModify()) {
                return ItemStack.f_41583_;
            }
            if (amount == 0) {
                return ItemStack.f_41583_;
            }
            ItemStack existing = this.getStackInSlot(slotIndex);
            if (existing.m_41619_()) {
                return ItemStack.f_41583_;
            }
            int toExtract = Math.min(amount, existing.m_41741_());
            if (existing.m_41613_() <= toExtract) {
                if (!simulate) {
                    this.setStackInSlot(slotIndex, ItemStack.f_41583_);
                    return existing;
                }
                return existing.m_41777_();
            }
            if (!simulate) {
                this.setStackInSlot(slotIndex, existing.m_255036_(existing.m_41613_() - toExtract));
            }
            return existing.m_255036_(toExtract);
        }

        public int getSlotLimit(int slotIndex) {
            return this.barrelCompartment.m_6893_();
        }

        public boolean isItemValid(int slotIndex, ItemStack itemStack) {
            return switch (slotIndex) {
                case 0 -> Helpers.mightHaveCapability((ItemStack)itemStack, (Capability)ForgeCapabilities.FLUID_HANDLER);
                case 2 -> {
                    IItemSize size = ItemSizeManager.get((ItemStack)itemStack);
                    if (size.getSize(itemStack).isSmallerThan(Size.HUGE) || size.getWeight(itemStack).isSmallerThan(Weight.VERY_HEAVY)) {
                        yield true;
                    }
                    yield false;
                }
                default -> true;
            };
        }

        public void setStackInSlot(int slotIndex, ItemStack itemStack) {
            this.barrelCompartment.m_6836_(slotIndex, itemStack);
            this.barrelCompartment.m_6596_();
        }

        public CompoundTag serializeNBT() {
            CompoundTag compoundTag = new CompoundTag();
            ListTag nbtTagList = new ListTag();
            for (int slotIndex = 0; slotIndex < this.barrelCompartment.m_6643_(); ++slotIndex) {
                ItemStack slotStack = this.barrelCompartment.m_8020_(slotIndex);
                if (slotStack.m_41619_()) continue;
                CompoundTag itemTag = new CompoundTag();
                itemTag.m_128405_("Slot", slotIndex);
                slotStack.m_41739_(itemTag);
                nbtTagList.add((Object)itemTag);
            }
            CompoundTag itemStacks = new CompoundTag();
            itemStacks.m_128365_("Items", (Tag)nbtTagList);
            compoundTag.m_128365_("inventory", (Tag)itemStacks);
            compoundTag.m_128365_("tank", (Tag)this.fluid.writeToNBT(new CompoundTag()));
            if (!this.excess.isEmpty()) {
                ListTag excessStacks = new ListTag();
                for (ItemStack itemStack : this.excess) {
                    excessStacks.add((Object)itemStack.m_41739_(new CompoundTag()));
                }
                compoundTag.m_128365_("excess", (Tag)excessStacks);
            }
            return compoundTag;
        }

        public void deserializeNBT(CompoundTag compoundTag) {
            int i;
            ListTag tagList = compoundTag.m_128469_("inventory").m_128437_("Items", 10);
            for (i = 0; i < tagList.size(); ++i) {
                CompoundTag itemTags = tagList.m_128728_(i);
                int slotIndex = itemTags.m_128451_("Slot");
                if (slotIndex < 0 || slotIndex >= this.barrelCompartment.m_6643_()) continue;
                this.barrelCompartment.m_6836_(slotIndex, ItemStack.m_41712_((CompoundTag)itemTags));
            }
            this.fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)compoundTag.m_128469_("tank"));
            this.excess.clear();
            if (compoundTag.m_128441_("excess")) {
                ListTag excessNbt = compoundTag.m_128437_("excess", 10);
                for (i = 0; i < excessNbt.size(); ++i) {
                    this.excess.add(ItemStack.m_41712_((CompoundTag)excessNbt.m_128728_(i)));
                }
            }
        }

        private boolean canModify() {
            return this.mutable || this.barrelCompartment.canModify();
        }
    }
}

