/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.firmaciv.common.entity;

import com.alekiponi.alekiships.common.entity.vehicle.RowboatEntity;
import com.alekiponi.alekiships.common.entity.vehicle.SloopEntity;
import com.alekiponi.alekiships.common.entity.vehicle.SloopUnderConstructionEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.CompartmentType;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.AbstractCompartmentEntity;
import com.alekiponi.alekiships.util.BoatMaterial;
import com.alekiponi.alekiships.util.CommonHelper;
import com.alekiponi.firmaciv.common.entity.FirmacivCannonEntity;
import com.alekiponi.firmaciv.common.entity.compartment.LargeVesselCompartmentEntity;
import com.alekiponi.firmaciv.common.entity.compartment.TFCBarrelCompartmentEntity;
import com.alekiponi.firmaciv.common.entity.compartment.TFCChestCompartmentEntity;
import com.alekiponi.firmaciv.common.entity.vehicle.CanoeEntity;
import com.alekiponi.firmaciv.common.entity.vehicle.FirmacivRowboatEntity;
import com.alekiponi.firmaciv.common.entity.vehicle.FirmacivSloopEntity;
import com.alekiponi.firmaciv.common.entity.vehicle.FirmacivSloopUnderConstructionEntity;
import com.alekiponi.firmaciv.common.entity.vehicle.KayakEntity;
import com.alekiponi.firmaciv.util.FirmacivTags;
import com.alekiponi.firmaciv.util.TFCWood;
import java.util.EnumMap;
import java.util.Locale;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public final class FirmacivEntities {
    private static final int LARGE_VEHICLE_TRACKING = 20;
    private static final int VEHICLE_HELPER_TRACKING = 21;
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"firmaciv");
    public static final EnumMap<TFCWood, RegistryObject<EntityType<FirmacivRowboatEntity>>> TFC_ROWBOATS = CommonHelper.mapOfKeys(TFCWood.class, tfcWood -> FirmacivEntities.registerRowboat(tfcWood, EntityType.Builder.m_20704_((entityType, level) -> new FirmacivRowboatEntity((EntityType<? extends FirmacivRowboatEntity>)entityType, level, (BoatMaterial)tfcWood), (MobCategory)MobCategory.MISC)));
    public static final EnumMap<TFCWood, RegistryObject<EntityType<FirmacivSloopEntity>>> TFC_SLOOPS = CommonHelper.mapOfKeys(TFCWood.class, tfcWood -> FirmacivEntities.registerSloop(tfcWood, EntityType.Builder.m_20704_((entityType, level) -> new FirmacivSloopEntity((EntityType<? extends FirmacivSloopEntity>)entityType, level, (BoatMaterial)tfcWood), (MobCategory)MobCategory.MISC)));
    public static final EnumMap<TFCWood, RegistryObject<EntityType<FirmacivSloopUnderConstructionEntity>>> TFC_SLOOPS_UNDER_CONSTRUCTION = CommonHelper.mapOfKeys(TFCWood.class, tfcWood -> FirmacivEntities.registerSloopConstruction(tfcWood, EntityType.Builder.m_20704_((entityType, level) -> new FirmacivSloopUnderConstructionEntity((EntityType<? extends FirmacivSloopUnderConstructionEntity>)entityType, level, (BoatMaterial)tfcWood), (MobCategory)MobCategory.MISC)));
    public static final EnumMap<TFCWood, RegistryObject<EntityType<CanoeEntity>>> TFC_CANOES = CommonHelper.mapOfKeys(TFCWood.class, tfcWood -> FirmacivEntities.registerCanoe(tfcWood, EntityType.Builder.m_20704_((entityType, level) -> new CanoeEntity((EntityType<? extends CanoeEntity>)entityType, level, (BoatMaterial)tfcWood), (MobCategory)MobCategory.MISC)));
    public static final RegistryObject<EntityType<KayakEntity>> KAYAK_ENTITY = FirmacivEntities.register("kayak", EntityType.Builder.m_20704_(KayakEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.79f, 0.625f));
    public static final RegistryObject<EntityType<FirmacivCannonEntity>> FIRMACIV_CANNON_ENTITY = FirmacivEntities.register("cannon", EntityType.Builder.m_20704_(FirmacivCannonEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.8f, 0.8f).m_20719_());
    public static final RegistryObject<CompartmentType<TFCChestCompartmentEntity>> TFC_CHEST_COMPARTMENT_ENTITY = (RegistryObject)CompartmentType.register(FirmacivEntities.registerCompartment("compartment_tfc_chest", CompartmentType.Builder.of(TFCChestCompartmentEntity::new, TFCChestCompartmentEntity::new, (MobCategory)MobCategory.MISC)), (T itemStack) -> itemStack.m_204117_(FirmacivTags.Items.CHESTS));
    public static final RegistryObject<CompartmentType<TFCBarrelCompartmentEntity>> TFC_BARREL_COMPARTMENT_ENTITY = (RegistryObject)CompartmentType.register(FirmacivEntities.registerCompartment("compartment_tfc_barrel", CompartmentType.Builder.of(TFCBarrelCompartmentEntity::new, TFCBarrelCompartmentEntity::new)), (T itemStack) -> itemStack.m_204117_(FirmacivTags.Items.BARRELS));
    public static final RegistryObject<CompartmentType<LargeVesselCompartmentEntity>> LARGE_VESSEL_COMPARTMENT_ENTITY = (RegistryObject)CompartmentType.register(FirmacivEntities.registerCompartment("compartment_large_vessel", CompartmentType.Builder.of(LargeVesselCompartmentEntity::new, LargeVesselCompartmentEntity::new)), (T itemStack) -> itemStack.m_204117_(FirmacivTags.Items.FIRED_LARGE_VESSELS));

    private static <E extends RowboatEntity> RegistryObject<EntityType<E>> registerRowboat(TFCWood tfcWood, EntityType.Builder<E> builder) {
        return FirmacivEntities.register("rowboat/" + tfcWood.m_7912_(), builder.m_20699_(1.875f, 0.625f));
    }

    private static <E extends CanoeEntity> RegistryObject<EntityType<E>> registerCanoe(TFCWood tfcWood, EntityType.Builder<E> builder) {
        return FirmacivEntities.register("dugout_canoe/" + tfcWood.m_7912_(), builder.m_20699_(1.125f, 0.625f));
    }

    private static <E extends SloopEntity> RegistryObject<EntityType<E>> registerSloop(TFCWood tfcWood, EntityType.Builder<E> builder) {
        return FirmacivEntities.register("sloop/" + tfcWood.m_7912_(), builder.m_20699_(3.0f, 0.75f).setTrackingRange(20).m_20719_());
    }

    private static <E extends SloopUnderConstructionEntity> RegistryObject<EntityType<E>> registerSloopConstruction(TFCWood bopWood, EntityType.Builder<E> builder) {
        return FirmacivEntities.register("sloop_construction/" + bopWood.m_7912_(), builder.m_20699_(4.0f, 0.75f).setTrackingRange(20).m_20719_().m_20698_());
    }

    private static <E extends AbstractCompartmentEntity> RegistryObject<CompartmentType<E>> registerCompartment(String name, CompartmentType.Builder<E> builder) {
        return FirmacivEntities.register(name, builder.sized(0.6f, 0.7f).fireImmune().noSummon(), true);
    }

    private static <E extends AbstractCompartmentEntity> RegistryObject<CompartmentType<E>> register(String name, CompartmentType.Builder<E> builder, boolean serialize) {
        String id = name.toLowerCase(Locale.ROOT);
        return ENTITY_TYPES.register(id, () -> {
            if (!serialize) {
                builder.noSave();
            }
            return builder.build("firmaciv:" + id);
        });
    }

    private static <E extends Entity> RegistryObject<EntityType<E>> register(String name, EntityType.Builder<E> builder) {
        return FirmacivEntities.register(name, builder, true);
    }

    private static <E extends Entity> RegistryObject<EntityType<E>> register(String name, EntityType.Builder<E> builder, boolean serialize) {
        String id = name.toLowerCase(Locale.ROOT);
        return ENTITY_TYPES.register(id, () -> {
            if (!serialize) {
                builder.m_20716_();
            }
            return builder.m_20712_("firmaciv:" + id);
        });
    }
}

