/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.firmaciv.common.block;

import com.alekiponi.firmaciv.common.block.FirmacivBlockStateProperties;
import com.alekiponi.firmaciv.common.blockentity.CanoeComponentBlockEntity;
import com.alekiponi.firmaciv.common.blockentity.FirmacivBlockEntities;
import com.alekiponi.firmaciv.common.entity.vehicle.CanoeEntity;
import com.alekiponi.firmaciv.util.CanoeMaterial;
import java.util.IdentityHashMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CanoeComponentBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61365_;
    public static final IntegerProperty CANOE_CARVED = FirmacivBlockStateProperties.CANOE_CARVED_13;
    public static final BooleanProperty END = FirmacivBlockStateProperties.END;
    private static final IdentityHashMap<RotatedPillarBlock, CanoeComponentBlock> CANOE_COMPONENTS = new IdentityHashMap();
    private static final VoxelShape SHAPE_FINAL = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape SHAPE_1 = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private final CanoeMaterial TFCWoodMaterial;

    public CanoeComponentBlock(BlockBehaviour.Properties properties, CanoeMaterial TFCWoodMaterial) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(AXIS, (Comparable)Direction.Axis.Z)).m_61124_((Property)CANOE_CARVED, (Comparable)Integer.valueOf(1))).m_61124_((Property)END, (Comparable)Boolean.valueOf(false)));
        this.TFCWoodMaterial = TFCWoodMaterial;
    }

    public static void registerCanoeComponent(RotatedPillarBlock strippedWoodenLog, CanoeComponentBlock canoeComponentBlock) {
        CANOE_COMPONENTS.put(strippedWoodenLog, canoeComponentBlock);
    }

    @Nullable
    public static CanoeComponentBlock getCanoeComponent(RotatedPillarBlock strippedWoodenLog) {
        return CANOE_COMPONENTS.get(strippedWoodenLog);
    }

    public static boolean isValidCanoeShape(LevelAccessor world, RotatedPillarBlock strippedLogBlock, BlockPos pPos) {
        Direction.Axis axis = (Direction.Axis)world.m_8055_(pPos).m_61143_(AXIS);
        CanoeComponentBlock canoeComponentBlock = CanoeComponentBlock.getCanoeComponent(strippedLogBlock);
        if (canoeComponentBlock == null) {
            return false;
        }
        BlockPos blockPos0 = pPos;
        int row = 0;
        for (int i = -2; i <= 2; ++i) {
            blockPos0 = pPos.m_5487_(axis, i);
            if (world.m_8055_(blockPos0).m_60713_((Block)strippedLogBlock) || world.m_8055_(blockPos0).m_60713_((Block)canoeComponentBlock)) {
                if (world.m_8055_(blockPos0).m_61143_(AXIS) == axis) {
                    if (++row != 3) continue;
                    return true;
                }
                row = 0;
                continue;
            }
            row = 0;
        }
        return false;
    }

    private static BlockPos getMiddleBlockPos(Level pLevel, BlockPos pPos, Block canoeComponentBlock) {
        Direction.Axis axis = (Direction.Axis)pLevel.m_8055_(pPos).m_61143_(AXIS);
        BlockPos blockPos0 = pPos.m_5487_(axis, 2);
        BlockPos blockPos1 = pPos.m_5487_(axis, 1);
        BlockPos blockPos2 = pPos.m_5487_(axis, -1);
        BlockPos blockPos3 = pPos.m_5487_(axis, -2);
        if (pLevel.m_8055_(blockPos0).m_60713_(canoeComponentBlock) && pLevel.m_8055_(blockPos1).m_60713_(canoeComponentBlock)) {
            return pPos.m_5487_(axis, 1);
        }
        if (pLevel.m_8055_(blockPos1).m_60713_(canoeComponentBlock) && pLevel.m_8055_(blockPos2).m_60713_(canoeComponentBlock)) {
            return pPos;
        }
        if (pLevel.m_8055_(blockPos2).m_60713_(canoeComponentBlock) && pLevel.m_8055_(blockPos3).m_60713_(canoeComponentBlock)) {
            return pPos.m_5487_(axis, -1);
        }
        return pPos;
    }

    public static BlockState getStateForPlacement(Level pLevel, RotatedPillarBlock strippedLogBlock, BlockPos pPos) {
        Direction.Axis axis = (Direction.Axis)pLevel.m_8055_(pPos).m_61143_(AXIS);
        CanoeComponentBlock canoeComponentBlock = CanoeComponentBlock.getCanoeComponent(strippedLogBlock);
        assert (canoeComponentBlock != null);
        BlockState finalBlockState = (BlockState)((BlockState)((BlockState)((BlockState)canoeComponentBlock.m_49966_().m_61124_((Property)CANOE_CARVED, (Comparable)Integer.valueOf(1))).m_61124_((Property)END, (Comparable)Boolean.valueOf(true))).m_61124_(AXIS, (Comparable)axis)).m_61124_((Property)FACING, (Comparable)(axis == Direction.Axis.X ? Direction.EAST : Direction.SOUTH));
        BlockPos blockPos1 = pPos.m_5487_(axis, 1);
        if (pLevel.m_8055_(blockPos1).m_60713_((Block)canoeComponentBlock) || pLevel.m_8055_(blockPos1).m_60713_((Block)strippedLogBlock) && pLevel.m_8055_(blockPos1).m_61143_(AXIS) == axis) {
            finalBlockState = (BlockState)finalBlockState.m_61124_((Property)FACING, (Comparable)(axis == Direction.Axis.X ? Direction.WEST : Direction.NORTH));
        }
        return finalBlockState;
    }

    public static void setEndPieces(Level pLevel, BlockPos pPos, Block canoeComponentBlock, boolean positiveDir) {
        if (!pLevel.m_8055_(pPos).m_60713_(canoeComponentBlock)) {
            return;
        }
        BlockState thisBlockState = pLevel.m_8055_(pPos);
        Direction.Axis axis = (Direction.Axis)pLevel.m_8055_(pPos).m_61143_(AXIS);
        BlockPos blockPos1 = pPos.m_5487_(axis, positiveDir ? 1 : -1);
        if (pLevel.m_8055_(blockPos1).m_60713_(canoeComponentBlock) && pLevel.m_8055_(blockPos1).m_61143_(AXIS) == axis) {
            thisBlockState = (BlockState)thisBlockState.m_61124_((Property)END, (Comparable)Boolean.valueOf(false));
            pLevel.m_7731_(pPos, thisBlockState, 4);
            CanoeComponentBlock.setEndPieces(pLevel, blockPos1, canoeComponentBlock, positiveDir);
        } else {
            thisBlockState = (BlockState)thisBlockState.m_61124_((Property)END, (Comparable)Boolean.valueOf(true));
            thisBlockState = positiveDir ? (BlockState)thisBlockState.m_61124_((Property)FACING, (Comparable)(axis == Direction.Axis.X ? Direction.EAST : Direction.SOUTH)) : (BlockState)thisBlockState.m_61124_((Property)FACING, (Comparable)(axis == Direction.Axis.X ? Direction.WEST : Direction.NORTH));
            pLevel.m_7731_(pPos, thisBlockState, 4);
        }
    }

    private static boolean areValidBlockStates(Level pLevel, BlockPos pPos, Block canoeComponentBlock) {
        Direction.Axis axis = (Direction.Axis)pLevel.m_8055_(pPos).m_61143_(AXIS);
        BlockPos blockPos0 = pPos.m_5487_(axis, 2);
        BlockPos blockPos1 = pPos.m_5487_(axis, 1);
        BlockPos blockPos2 = pPos.m_5487_(axis, -1);
        BlockPos blockPos3 = pPos.m_5487_(axis, -2);
        if (pLevel.m_8055_(blockPos0).m_60713_(canoeComponentBlock) && pLevel.m_8055_(blockPos1).m_60713_(canoeComponentBlock) && (Integer)pLevel.m_8055_(blockPos0).m_61143_((Property)CANOE_CARVED) == 13 && (Integer)pLevel.m_8055_(blockPos1).m_61143_((Property)CANOE_CARVED) == 13) {
            return true;
        }
        if (pLevel.m_8055_(blockPos1).m_60713_(canoeComponentBlock) && pLevel.m_8055_(blockPos2).m_60713_(canoeComponentBlock) && (Integer)pLevel.m_8055_(blockPos1).m_61143_((Property)CANOE_CARVED) == 13 && (Integer)pLevel.m_8055_(blockPos2).m_61143_((Property)CANOE_CARVED) == 13) {
            return true;
        }
        if (pLevel.m_8055_(blockPos2).m_60713_(canoeComponentBlock) && pLevel.m_8055_(blockPos3).m_60713_(canoeComponentBlock)) {
            return (Integer)pLevel.m_8055_(blockPos2).m_61143_((Property)CANOE_CARVED) == 13 && (Integer)pLevel.m_8055_(blockPos3).m_61143_((Property)CANOE_CARVED) == 13;
        }
        return false;
    }

    public static void trySpawnCanoe(Level pLevel, BlockPos pPos, CanoeComponentBlock canoeComponentBlock) {
        if (!CanoeComponentBlock.areValidBlockStates(pLevel, pPos, (Block)canoeComponentBlock)) {
            return;
        }
        BlockPattern.BlockPatternMatch blockpattern$blockpatternmatch = CanoeComponentBlock.createCanoeFull((Block)canoeComponentBlock).m_61184_((LevelReader)pLevel, pPos);
        if (blockpattern$blockpatternmatch == null) {
            return;
        }
        Direction.Axis axis = (Direction.Axis)pLevel.m_8055_(pPos).m_61143_(AXIS);
        BlockPos middleblockpos = CanoeComponentBlock.getMiddleBlockPos(pLevel, pPos, (Block)canoeComponentBlock);
        for (int i = 0; i < CanoeComponentBlock.createCanoeFull((Block)canoeComponentBlock).m_61202_(); ++i) {
            BlockInWorld blockinworld = blockpattern$blockpatternmatch.m_61229_(0, i, 0);
            pLevel.m_7731_(blockinworld.m_61176_(), Blocks.f_50016_.m_49966_(), 2);
            pLevel.m_46796_(2001, blockinworld.m_61176_(), Block.m_49956_((BlockState)blockinworld.m_61168_()));
        }
        canoeComponentBlock.TFCWoodMaterial.getCanoeType().ifPresent(entityType -> {
            CanoeEntity canoeEntity = (CanoeEntity)entityType.m_20615_(pLevel);
            if (canoeEntity == null) {
                return;
            }
            if (axis == Direction.Axis.X) {
                canoeEntity.m_7678_((double)middleblockpos.m_123341_() + 0.5, (double)middleblockpos.m_123342_() + 0.05, (double)middleblockpos.m_123343_() + 0.5, 90.0f, 0.0f);
            } else {
                canoeEntity.m_7678_((double)middleblockpos.m_123341_() + 0.5, (double)middleblockpos.m_123342_() + 0.05, (double)middleblockpos.m_123343_() + 0.5, 0.0f, 0.0f);
            }
            pLevel.m_7967_((Entity)canoeEntity);
            for (ServerPlayer serverplayer : pLevel.m_45976_(ServerPlayer.class, canoeEntity.m_20191_().m_82400_(5.0))) {
                CriteriaTriggers.f_10580_.m_68256_(serverplayer, (Entity)canoeEntity);
            }
            for (int l = 0; l < CanoeComponentBlock.createCanoeFull((Block)canoeComponentBlock).m_61202_(); ++l) {
                BlockInWorld blockinworld3 = blockpattern$blockpatternmatch.m_61229_(0, l, 0);
                pLevel.m_6289_(blockinworld3.m_61176_(), Blocks.f_50016_);
            }
        });
    }

    private static BlockPattern createCanoeFull(Block canoeComponentBlock) {
        BlockPattern canoeFull = BlockPatternBuilder.m_61243_().m_61247_(new String[]{"#", "#", "#"}).m_61244_('#', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)canoeComponentBlock))).m_61249_();
        return canoeFull;
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        if ((Integer)pState.m_61143_((Property)CANOE_CARVED) == 12) {
            double x = (float)pPos.m_123341_() + pRandom.m_188501_();
            double y = (float)pPos.m_123342_() + pRandom.m_188501_();
            double z = (float)pPos.m_123343_() + pRandom.m_188501_();
            for (int i = 0; i < pRandom.m_188503_(3); ++i) {
                pLevel.m_7107_((ParticleOptions)ParticleTypes.f_123778_, x, y, z, 0.0, (double)(0.1f + pRandom.m_188501_() / 8.0f), 0.0);
            }
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new CanoeComponentBlockEntity(pPos, pState);
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return CanoeComponentBlock.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)FirmacivBlockEntities.CANOE_COMPONENT_BLOCK_ENTITY.get()), CanoeComponentBlockEntity::serverTick);
    }

    public boolean isFlammable(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return false;
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 5;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 5;
    }

    public VoxelShape m_5940_(BlockState pstate, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        int canoeCarvedState = (Integer)pstate.m_61143_((Property)CANOE_CARVED);
        return switch (canoeCarvedState) {
            case 1, 2, 3, 4 -> SHAPE_1;
            default -> SHAPE_FINAL;
        };
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_())).m_61124_(AXIS, (Comparable)pContext.m_8125_().m_122434_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING});
        pBuilder.m_61104_(new Property[]{AXIS});
        pBuilder.m_61104_(new Property[]{CANOE_CARVED});
        pBuilder.m_61104_(new Property[]{END});
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!(!pState.m_155947_() || pState.m_60713_(pNewState.m_60734_()) && pNewState.m_155947_())) {
            pLevel.m_46747_(pPos);
        }
        if (!pNewState.m_60713_(pState.m_60734_()) && (Integer)pState.m_61143_((Property)CANOE_CARVED) < 13) {
            Block ccb = pState.m_60734_();
            Direction.Axis axis = (Direction.Axis)pState.m_61143_(AXIS);
            if (pLevel.m_8055_(pPos.m_5487_(axis, 1)).m_60713_(ccb) && pLevel.m_8055_(pPos.m_5487_(axis, 1)).m_61143_(AXIS) == axis) {
                pLevel.m_46961_(pPos.m_5487_(axis, 1), true);
            }
            if (pLevel.m_8055_(pPos.m_5487_(axis, -1)).m_60713_(ccb) && pLevel.m_8055_(pPos.m_5487_(axis, -1)).m_61143_(AXIS) == axis) {
                pLevel.m_46961_(pPos.m_5487_(axis, -1), true);
            }
        }
    }
}

