/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.firmaciv.client.screen;

import com.alekiponi.firmaciv.client.screen.button.BarrelCompartmentSealButton;
import com.alekiponi.firmaciv.common.entity.compartment.TFCBarrelCompartmentEntity;
import com.alekiponi.firmaciv.common.menu.BarrelCompartmentMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.screen.BarrelScreen;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.recipes.BarrelRecipe;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Tooltips;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendar;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

@OnlyIn(value=Dist.CLIENT)
public class BarrelCompartmentScreen
extends AbstractContainerScreen<BarrelCompartmentMenu> {
    public static final int TEXT_COLOR = 0x404040;
    private static final Component SEAL = Component.m_237115_((String)"tfc.tooltip.seal_barrel");
    private static final Component UNSEAL = Component.m_237115_((String)"tfc.tooltip.unseal_barrel");
    private static final int MAX_RECIPE_NAME_LENGTH = 100;
    private final TFCBarrelCompartmentEntity barrelCompartment;

    public BarrelCompartmentScreen(BarrelCompartmentMenu compartmentMenu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)compartmentMenu, inventory, title);
        this.barrelCompartment = compartmentMenu.getBarrelCompartment();
        this.f_97731_ += 12;
        this.f_97727_ += 12;
    }

    public void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new BarrelCompartmentSealButton(this.barrelCompartment, this.f_97735_, this.f_97736_, this.barrelCompartment.isSealed() ? UNSEAL : SEAL));
    }

    public void m_88315_(GuiGraphics poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(poseStack);
        super.m_88315_(poseStack, mouseX, mouseY, partialTicks);
        this.m_280072_(poseStack, mouseX, mouseY);
    }

    protected void m_280072_(GuiGraphics graphics, int mouseX, int mouseY) {
        super.m_280072_(graphics, mouseX, mouseY);
        int relX = mouseX - this.f_97735_;
        int relY = mouseY - this.f_97736_;
        if (relX >= 7 && relY >= 19 && relX < 25 && relY < 71) {
            this.barrelCompartment.getCapability(Capabilities.FLUID).ifPresent(fluidHandler -> {
                FluidStack fluid = fluidHandler.getFluidInTank(0);
                if (!fluid.isEmpty()) {
                    graphics.m_280557_(this.f_96547_, (Component)Tooltips.fluidUnitsOf((FluidStack)fluid), mouseX, mouseY);
                }
            });
        }
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        super.m_280003_(graphics, mouseX, mouseY);
        if (this.barrelCompartment.isSealed()) {
            this.drawDisabled(graphics, 0, 2);
            BarrelRecipe recipe = this.barrelCompartment.getRecipe();
            if (recipe != null) {
                MutableComponent resultText = recipe.getTranslationComponent();
                if (this.f_96547_.m_92852_((FormattedText)resultText) > 100) {
                    int line = 0;
                    for (FormattedCharSequence text : this.f_96547_.m_92923_((FormattedText)resultText, 100)) {
                        int n = 70 + Math.floorDiv(100 - this.f_96547_.m_92724_(text), 2);
                        Objects.requireNonNull(this.f_96547_);
                        graphics.m_280649_(this.f_96547_, text, n, this.f_97729_ + line * 9, 0x404040, false);
                        ++line;
                    }
                } else {
                    graphics.m_280056_(this.f_96547_, resultText.getString(), 70 + Math.floorDiv(100 - this.f_96547_.m_92852_((FormattedText)resultText), 2), 61, 0x404040, false);
                }
            }
            String date = ICalendar.getTimeAndDate((long)Calendars.CLIENT.ticksToCalendarTicks(this.barrelCompartment.getSealedTick()), (long)Calendars.CLIENT.getCalendarDaysInMonth()).getString();
            graphics.m_280056_(this.f_96547_, date, this.f_97726_ / 2 - this.f_96547_.m_92895_(date) / 2, 74, 0x404040, false);
        }
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        this.drawDefaultBackground(graphics);
        if (Helpers.isJEIEnabled()) {
            graphics.m_280218_(BarrelScreen.BACKGROUND, this.getGuiLeft() + 92, this.getGuiTop() + 21, 227, 0, 9, 14);
        }
        this.barrelCompartment.getCapability(Capabilities.FLUID).ifPresent(fluidHandler -> {
            FluidStack fluidStack = fluidHandler.getFluidInTank(0);
            if (!fluidStack.isEmpty()) {
                TextureAtlasSprite sprite = RenderHelpers.getAndBindFluidSprite((FluidStack)fluidStack);
                int fillHeight = (int)Math.ceil(50.0f * (float)fluidStack.getAmount() / (float)((Integer)TFCConfig.SERVER.barrelCapacity.get()).intValue());
                RenderHelpers.fillAreaWithSprite((GuiGraphics)graphics, (TextureAtlasSprite)sprite, (int)(this.f_97735_ + 8), (int)(this.f_97736_ + 70 - fillHeight), (int)16, (int)fillHeight, (int)16, (int)16);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)BarrelScreen.BACKGROUND);
            }
        });
        graphics.m_280218_(BarrelScreen.BACKGROUND, this.f_97735_ + 7, this.f_97736_ + 19, 176, 0, 18, 52);
    }

    protected void drawDefaultBackground(GuiGraphics graphics) {
        graphics.m_280163_(BarrelScreen.BACKGROUND, this.f_97735_, this.f_97736_, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 256, 256);
    }

    public void drawDisabled(GuiGraphics graphics, int start, int end) {
        this.barrelCompartment.getCapability(Capabilities.ITEM).ifPresent(inventory -> ((BarrelCompartmentMenu)this.f_97732_).f_38839_.stream().filter(slot -> slot.f_40219_ <= end && slot.f_40219_ >= start).forEach(slot -> BarrelCompartmentScreen.m_280359_((GuiGraphics)graphics, (int)slot.f_40220_, (int)slot.f_40221_, (int)1)));
    }
}

