/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.firmaciv.client.render.entity.vehicle;

import com.alekiponi.firmaciv.client.model.entity.KayakEntityModel;
import com.alekiponi.firmaciv.common.entity.vehicle.KayakEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class KayakRenderer
extends EntityRenderer<KayakEntity> {
    private static final ResourceLocation KAYAK = new ResourceLocation("firmaciv", "textures/entity/watercraft/kayak.png");
    private final Pair<ResourceLocation, KayakEntityModel> kayakResources;

    public KayakRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
        this.f_114477_ = 0.4f;
        this.kayakResources = Pair.of((Object)new ResourceLocation("firmaciv", "textures/entity/watercraft/kayak.png"), new KayakEntityModel());
    }

    public void render(KayakEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        VertexConsumer vertexconsumer1;
        pMatrixStack.m_85836_();
        pMatrixStack.m_85837_(0.0, 0.5, 0.0);
        pMatrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - pEntityYaw));
        float f = (float)pEntity.getHurtTime() - pPartialTicks;
        float f1 = pEntity.getDamage() - pPartialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            pMatrixStack.m_252781_(Axis.f_252403_.m_252977_(Mth.m_14031_((float)f) * f * f1 / 10.0f * (float)pEntity.getHurtDir()));
        }
        Pair<ResourceLocation, KayakEntityModel> pair = this.kayakResources;
        ResourceLocation resourcelocation = (ResourceLocation)pair.getFirst();
        KayakEntityModel kayakModel = (KayakEntityModel)((Object)pair.getSecond());
        pMatrixStack.m_252880_(0.0f, 1.0625f, 0.0f);
        pMatrixStack.m_85841_(-1.0f, -1.0f, 1.0f);
        pMatrixStack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
        kayakModel.m_6973_(pEntity, pPartialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = pBuffer.m_6299_(kayakModel.m_103119_(resourcelocation));
        kayakModel.m_7695_(pMatrixStack, vertexconsumer, pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!pEntity.m_5842_()) {
            vertexconsumer1 = pBuffer.m_6299_(RenderType.m_110478_());
            kayakModel.getWaterocclusion().m_104301_(pMatrixStack, vertexconsumer1, pPackedLight, OverlayTexture.f_118083_);
        }
        if (pEntity.m_6688_() != null) {
            vertexconsumer1 = pBuffer.m_6299_(kayakModel.m_103119_(resourcelocation));
            kayakModel.getCockpitCover().m_104301_(pMatrixStack, vertexconsumer1, pPackedLight, OverlayTexture.f_118083_);
        }
        pMatrixStack.m_85849_();
        super.m_7392_((Entity)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }

    public ResourceLocation getTextureLocation(KayakEntity pEntity) {
        return new ResourceLocation("firmaciv", "textures/entity/watercraft/kayak.png");
    }
}

