/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.firmaciv.client.render.entity.vehicle;

import com.alekiponi.firmaciv.client.model.entity.CanoeEntityModel;
import com.alekiponi.firmaciv.common.entity.vehicle.CanoeEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CanoeRenderer
extends EntityRenderer<CanoeEntity> {
    public static final ResourceLocation DAMAGE_OVERLAY = new ResourceLocation("firmaciv", "textures/entity/watercraft/dugout_canoe/damage_overlay.png");
    protected final CanoeEntityModel canoeModel = new CanoeEntityModel();
    protected final ResourceLocation canoeTexture;

    public CanoeRenderer(EntityRendererProvider.Context context, ResourceLocation canoeTexture) {
        super(context);
        this.f_114477_ = 0.7f;
        this.canoeTexture = canoeTexture;
    }

    public void render(CanoeEntity canoeEntity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.4375, 0.0);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - entityYaw));
        poseStack.m_252880_(0.0f, 1.0625f, 0.0f);
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
        this.canoeModel.setupAnim(canoeEntity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = bufferSource.m_6299_(this.canoeModel.m_103119_(this.getTextureLocation(canoeEntity)));
        if (canoeEntity.f_19797_ < 1) {
            poseStack.m_85849_();
            super.m_7392_((Entity)canoeEntity, entityYaw, partialTicks, poseStack, bufferSource, packedLight);
            return;
        }
        this.canoeModel.m_7695_(poseStack, vertexconsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (canoeEntity.getLength() >= 4) {
            this.canoeModel.getMiddleMid().m_104301_(poseStack, vertexconsumer, packedLight, OverlayTexture.f_118083_);
        }
        if (canoeEntity.getLength() == 5) {
            this.canoeModel.getMiddleStern().m_104301_(poseStack, vertexconsumer, packedLight, OverlayTexture.f_118083_);
            this.canoeModel.getBars().m_104301_(poseStack, vertexconsumer, packedLight, OverlayTexture.f_118083_);
        }
        if (!canoeEntity.m_5842_() && (double)canoeEntity.getDamage() < (double)canoeEntity.getDamageThreshold() * 0.9) {
            VertexConsumer vertexconsumer1 = bufferSource.m_6299_(RenderType.m_110478_());
            if (canoeEntity.getLength() == 3) {
                this.canoeModel.getWaterocclusion3().m_104301_(poseStack, vertexconsumer1, packedLight, OverlayTexture.f_118083_);
            } else if (canoeEntity.getLength() == 4) {
                this.canoeModel.getWaterocclusion4().m_104301_(poseStack, vertexconsumer1, packedLight, OverlayTexture.f_118083_);
            } else if (canoeEntity.getLength() == 5) {
                this.canoeModel.getWaterocclusion5().m_104301_(poseStack, vertexconsumer1, packedLight, OverlayTexture.f_118083_);
            }
        }
        if (canoeEntity.getDamage() > 0.0f) {
            VertexConsumer damageVertexConsumer = bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)DAMAGE_OVERLAY));
            float alpha = Mth.m_14036_((float)(canoeEntity.getDamage() / canoeEntity.getDamageThreshold() * 0.75f), (float)0.0f, (float)0.5f);
            this.canoeModel.m_7695_(poseStack, damageVertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, alpha);
        }
        poseStack.m_85849_();
        super.m_7392_((Entity)canoeEntity, entityYaw, partialTicks, poseStack, bufferSource, packedLight);
    }

    public ResourceLocation getTextureLocation(CanoeEntity canoeEntity) {
        return this.canoeTexture;
    }
}

