/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.firmaciv.client;

import com.alekiponi.alekiships.client.resources.PaintedTextureGenerator;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.EmptyCompartmentEntity;
import com.alekiponi.firmaciv.client.screen.BarrelCompartmentScreen;
import com.alekiponi.firmaciv.client.screen.LargeVesselCompartmentScreen;
import com.alekiponi.firmaciv.common.item.AbstractNavItem;
import com.alekiponi.firmaciv.common.item.FirmacivItems;
import com.alekiponi.firmaciv.common.menu.FirmacivMenus;
import com.alekiponi.firmaciv.util.TFCWood;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public final class FirmacivClientEvents {
    public static void init() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(FirmacivClientEvents::clientSetup);
        bus.addListener(FirmacivClientEvents::onRegisterReloadListeners);
    }

    private static void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            MenuScreens.m_96206_((MenuType)((MenuType)FirmacivMenus.BARREL_COMPARTMENT_MENU.get()), BarrelCompartmentScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)FirmacivMenus.LARGE_VESSEL_COMPARTMENT_MENU.get()), LargeVesselCompartmentScreen::new);
            ItemProperties.register((Item)((Item)FirmacivItems.BAROMETER.get()), (ResourceLocation)new ResourceLocation("firmaciv", "altitude"), (ItemPropertyFunction)new ClampedItemPropertyFunction(){

                public float m_142187_(ItemStack pStack, @Nullable ClientLevel pLevel, @Nullable LivingEntity livingEntity, int p_174668_) {
                    double height;
                    LivingEntity entity;
                    Object object = entity = livingEntity != null ? livingEntity : pStack.m_41609_();
                    if (entity == null) {
                        return 0.0f;
                    }
                    if (pLevel == null && entity.m_9236_() instanceof ClientLevel) {
                        pLevel = (ClientLevel)entity.m_9236_();
                    }
                    if (pLevel == null) {
                        return 0.0f;
                    }
                    if (pLevel.m_6042_().f_63858_()) {
                        assert (livingEntity != null);
                        height = (entity.m_20186_() + 64.0) / (double)pLevel.m_141928_();
                    } else {
                        height = Math.random();
                    }
                    return (float)height;
                }
            });
            ItemProperties.register((Item)((Item)FirmacivItems.FIRMACIV_COMPASS.get()), (ResourceLocation)new ResourceLocation("firmaciv", "firmaciv_compass_direction"), (ItemPropertyFunction)new ClampedItemPropertyFunction(){

                public float m_142187_(ItemStack pStack, @Nullable ClientLevel pLevel, @Nullable LivingEntity livingEntity, int p_174668_) {
                    double direction;
                    LivingEntity entity;
                    float rotation = 0.0f;
                    Object object = entity = livingEntity != null ? livingEntity : pStack.m_41609_();
                    if (entity == null) {
                        return 0.0f;
                    }
                    if (pLevel == null && entity.m_9236_() instanceof ClientLevel) {
                        pLevel = (ClientLevel)entity.m_9236_();
                    }
                    if (pLevel == null) {
                        return 0.0f;
                    }
                    if (pLevel.m_6042_().f_63858_()) {
                        assert (livingEntity != null);
                        rotation = livingEntity instanceof Player && pLevel.m_5776_() && livingEntity.m_20202_() instanceof EmptyCompartmentEntity ? Minecraft.m_91087_().m_91288_().m_146908_() : entity.m_146908_();
                        direction = (Mth.m_14177_((float)(-rotation)) + 180.0f) % 360.0f / 360.0f;
                    } else {
                        direction = Math.random();
                    }
                    return (float)direction;
                }
            });
            ItemProperties.register((Item)((Item)FirmacivItems.NAV_CLOCK.get()), (ResourceLocation)new ResourceLocation("firmaciv", "pm_time"), (ItemPropertyFunction)new ClampedItemPropertyFunction(){
                private double rotation;
                private double rota;
                private long lastUpdateTick;

                public float m_142187_(ItemStack stack, @Nullable ClientLevel clientLevel, @Nullable LivingEntity livingEntity, int p_174668_) {
                    double time;
                    LivingEntity entity;
                    Object object = entity = livingEntity != null ? livingEntity : stack.m_41609_();
                    if (entity == null) {
                        return 0.0f;
                    }
                    if (clientLevel == null && entity.m_9236_() instanceof ClientLevel) {
                        clientLevel = (ClientLevel)entity.m_9236_();
                    }
                    double longitude = Math.abs(AbstractNavItem.getNavLocation(entity.m_146892_())[AbstractNavItem.NavSelection.LONGITUDE.ordinal()] % 180.0 / 180.0);
                    if (clientLevel == null) {
                        return 0.0f;
                    }
                    if (clientLevel.m_6042_().f_63858_()) {
                        time = clientLevel.m_46942_(1.0f);
                        time += longitude;
                        time %= 1.0;
                    } else {
                        time = Math.random();
                    }
                    time = this.wobble((Level)clientLevel, time);
                    return (float)time;
                }

                private double wobble(Level level, double p_117905_) {
                    if (level.m_46467_() != this.lastUpdateTick) {
                        this.lastUpdateTick = level.m_46467_();
                        double d0 = p_117905_ - this.rotation;
                        d0 = Mth.m_14109_((double)(d0 + 0.5), (double)1.0) - 0.5;
                        this.rota += d0 * 0.1;
                        this.rota *= 0.9;
                        this.rotation = Mth.m_14109_((double)(this.rotation + this.rota), (double)1.0);
                    }
                    return this.rotation;
                }
            });
        });
    }

    private static void onRegisterReloadListeners(RegisterClientReloadListenersEvent event) {
        ResourceLocation rowboatPaint = new ResourceLocation("alekiships", "entity/watercraft/rowboat/paint");
        ResourceLocation sloopPaint = new ResourceLocation("alekiships", "entity/watercraft/sloop/paint");
        for (TFCWood wood : TFCWood.values()) {
            event.registerReloadListener((PreparableReloadListener)new PaintedTextureGenerator(new ResourceLocation("firmaciv", "entity/watercraft/rowboat/" + wood.m_7912_()), rowboatPaint));
            event.registerReloadListener((PreparableReloadListener)new PaintedTextureGenerator(new ResourceLocation("firmaciv", "entity/watercraft/sloop/" + wood.m_7912_()), sloopPaint));
        }
    }
}

