/*
 * Decompiled with CFR 0.152.
 */
package dev.arbor.extrasoundsnext.mapping;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import dev.arbor.extrasoundsnext.ExtraSoundsNext;
import dev.arbor.extrasoundsnext.annotation.AddonFinder;
import dev.arbor.extrasoundsnext.debug.DebugUtils;
import dev.arbor.extrasoundsnext.json.SoundEntrySerializer;
import dev.arbor.extrasoundsnext.json.SoundSerializer;
import dev.arbor.extrasoundsnext.mapping.SoundDefinition;
import dev.arbor.extrasoundsnext.mapping.SoundGenerator;
import dev.arbor.extrasoundsnext.sounds.SoundType;
import dev.arbor.extrasoundsnext.sounds.Sounds;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundEventRegistration;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SoundPackLoader {
    public static JsonObject GENERATED_SOUNDS;
    private static final Logger LOGGER;
    private static final String CACHE_FNAME = "extrasounds.cache";
    private static final Path CACHE_PATH_FILE;
    public static final Map<ResourceLocation, SoundEvent> CUSTOM_SOUND_EVENT;
    private static final Gson GSON;

    public static void init() {
        long tookMillis;
        long start = System.currentTimeMillis();
        HashMap<String, SoundGenerator> soundGenMappers = new HashMap<String, SoundGenerator>();
        for (SoundGenerator generator : AddonFinder.getSoundGenerators()) {
            soundGenMappers.put(generator.namespace, generator);
        }
        try {
            Files.createDirectories(CACHE_PATH_FILE.getParent(), new FileAttribute[0]);
            Files.deleteIfExists(CACHE_PATH_FILE);
        }
        catch (Throwable ex) {
            DebugUtils.genericLog(ex.getMessage());
        }
        try {
            if (!Files.exists(CACHE_PATH_FILE, new LinkOption[0])) {
                throw new FileNotFoundException("Cache does not exist.");
            }
            if (DebugUtils.NO_CACHE) {
                throw new RuntimeException("JVM arg '%s' is detected.".formatted("extrasounds.nocache"));
            }
        }
        catch (Throwable ex) {
            DebugUtils.genericLog(ex.getMessage());
            LOGGER.info("[{}] Regenerating cache...", (Object)ExtraSoundsNext.class.getSimpleName());
            HashMap<String, SoundEventRegistration> resourceMapper = new HashMap<String, SoundEventRegistration>();
            SoundPackLoader.processSounds(soundGenMappers, resourceMapper);
            CacheData.create(resourceMapper);
        }
        try {
            CacheData cacheData = CacheData.read();
            JsonObject jsonObject = cacheData.asJsonObject();
            jsonObject.keySet().forEach(key -> SoundPackLoader.putSoundEvent(new ResourceLocation("extrasounds", key)));
            GENERATED_SOUNDS = jsonObject;
        }
        catch (JsonParseException e) {
            DebugUtils.genericLog(e.getMessage());
        }
        if (DebugUtils.DEBUG) {
            DebugUtils.exportSoundsJson(CacheData.read().asJsonBytes());
            DebugUtils.exportGenerators(soundGenMappers);
        }
        if ((tookMillis = System.currentTimeMillis() - start) >= 1000L) {
            LOGGER.warn("[{}] init took too long; {}ms.", (Object)ExtraSoundsNext.class.getSimpleName(), (Object)tookMillis);
        } else {
            DebugUtils.genericLog("%s init finished; took %dms.".formatted(SoundPackLoader.class.getSimpleName(), tookMillis));
        }
        LOGGER.info("[{}] sound pack successfully loaded; {} entries.", (Object)ExtraSoundsNext.class.getSimpleName(), (Object)CUSTOM_SOUND_EVENT.keySet().size());
    }

    private static void processSounds(Map<String, SoundGenerator> soundGenerator, Map<String, SoundEventRegistration> resource) {
        SoundEventRegistration fallbackSoundEntry = Sounds.aliased(Sounds.ITEM_PICK);
        ArrayList inSoundsJsonIds = Lists.newArrayList();
        String fallbackSoundJson = GSON.toJson((Object)fallbackSoundEntry);
        if (DebugUtils.SEARCH_UNDEF_SOUND) {
            try (InputStream stream = SoundPackLoader.class.getClassLoader().getResourceAsStream("assets/extrasoundsnext/sounds.json");){
                Objects.requireNonNull(stream);
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                JsonObject jsonObject = JsonParser.parseString((String)reader.lines().collect(Collectors.joining())).getAsJsonObject();
                inSoundsJsonIds.addAll(jsonObject.keySet());
            }
            catch (Throwable ex) {
                LOGGER.warn("cannot open ExtraSounds' sounds.json.", ex);
            }
        }
        for (Item item : BuiltInRegistries.f_257033_) {
            boolean notIncludeSoundsJson;
            SoundDefinition definition;
            ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)item);
            if (soundGenerator.containsKey(Objects.requireNonNull(itemId).m_135827_())) {
                definition = soundGenerator.get((Object)itemId.m_135827_()).itemSoundGenerator.apply(item);
            } else if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                SoundDefinition blockSoundDef = SoundDefinition.of(fallbackSoundEntry);
                try {
                    Block block = blockItem.m_40614_();
                    SoundEvent blockSound = SoundGenerator.getSoundType(block).m_56777_();
                    blockSoundDef = SoundDefinition.of(Sounds.aliased(blockSound));
                }
                catch (Throwable block) {
                    // empty catch block
                }
                definition = blockSoundDef;
            } else {
                definition = SoundDefinition.of(fallbackSoundEntry);
            }
            ResourceLocation pickupSoundId = ExtraSoundsNext.getClickId(itemId, SoundType.PICKUP);
            SoundEventRegistration pickupSoundEntry = Sounds.aliased(ExtraSoundsNext.createEvent(pickupSoundId));
            SoundPackLoader.generateSoundEntry(itemId, SoundType.PICKUP, definition.pickup, pickupSoundEntry, resource);
            SoundPackLoader.generateSoundEntry(itemId, SoundType.PLACE, definition.place, pickupSoundEntry, resource);
            SoundPackLoader.generateSoundEntry(itemId, SoundType.HOTBAR, definition.hotbar, pickupSoundEntry, resource);
            if (!DebugUtils.SEARCH_UNDEF_SOUND) continue;
            boolean isFallbackSoundEntry = Objects.equals(GSON.toJson((Object)definition.pickup), fallbackSoundJson);
            boolean bl = notIncludeSoundsJson = !inSoundsJsonIds.contains(pickupSoundId.m_135815_());
            if (!isFallbackSoundEntry || !notIncludeSoundsJson) continue;
            LOGGER.warn("unregistered sound was found: '{}'", (Object)itemId);
        }
    }

    private static void generateSoundEntry(ResourceLocation itemId, SoundType type, SoundEventRegistration entry, SoundEventRegistration defaultEntry, Map<String, SoundEventRegistration> resource) {
        SoundEventRegistration soundEntry = entry == null ? defaultEntry : entry;
        ResourceLocation id = ExtraSoundsNext.getClickId(itemId, type);
        resource.put(id.m_135815_(), soundEntry);
        SoundPackLoader.putSoundEvent(id);
    }

    private static void putSoundEvent(ResourceLocation clickId) {
        CUSTOM_SOUND_EVENT.put(clickId, ExtraSoundsNext.createEvent(clickId));
    }

    static {
        LOGGER = LogManager.getLogger();
        CACHE_PATH_FILE = Path.of(System.getProperty("java.io.tmpdir"), ".minecraft", CACHE_FNAME);
        CUSTOM_SOUND_EVENT = new HashMap<ResourceLocation, SoundEvent>();
        GSON = new GsonBuilder().registerTypeAdapter(SoundEventRegistration.class, (Object)new SoundEntrySerializer()).registerTypeAdapter(Sound.class, (Object)new SoundSerializer()).create();
    }

    protected static class CacheData {
        private final CharSequence json;

        private CacheData(CharSequence json) {
            this.json = json;
        }

        static CacheData read() {
            CacheData cacheData;
            block9: {
                BufferedReader reader = Files.newBufferedReader(CACHE_PATH_FILE);
                try {
                    String line;
                    StringBuilder builder = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        builder.append(line);
                    }
                    cacheData = new CacheData(builder);
                    if (reader == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable ex) {
                        LOGGER.error("[%s] Failed to load ExtraSounds cache.".formatted(ExtraSoundsNext.class.getSimpleName()), ex);
                        return new CacheData("{}");
                    }
                }
                reader.close();
            }
            return cacheData;
        }

        static void create(Map<String, SoundEventRegistration> map) {
            try (BufferedWriter writer = Files.newBufferedWriter(CACHE_PATH_FILE, new OpenOption[0]);){
                GSON.toJson(map, (Appendable)writer);
                writer.flush();
                DebugUtils.genericLog("Cache saved at %s".formatted(CACHE_PATH_FILE.toAbsolutePath()));
            }
            catch (Throwable ex) {
                LOGGER.error("[%s] Failed to save the cache.".formatted(ExtraSoundsNext.class.getSimpleName()), ex);
            }
        }

        public JsonObject asJsonObject() throws JsonParseException {
            return JsonParser.parseString((String)this.json.toString()).getAsJsonObject();
        }

        public byte[] asJsonBytes() {
            return this.json.toString().getBytes();
        }
    }
}

