/*
 * Decompiled with CFR 0.152.
 */
package mod.trasiter101.esc.common.capability;

import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;

public class ExtendedSlotCapacityHandler
extends ItemStackHandler {
    protected final int slotStackLimit;

    public ExtendedSlotCapacityHandler(int slotCount, int slotStackLimit) {
        super(slotCount);
        this.slotStackLimit = slotStackLimit;
    }

    public ExtendedSlotCapacityHandler(NonNullList<ItemStack> stacks, int slotStackLimit) {
        super(stacks);
        this.slotStackLimit = slotStackLimit;
    }

    public int getSlotLimit(int slotIndex) {
        return this.slotStackLimit;
    }

    public int getStackLimit(int slotIndex, ItemStack itemStack) {
        return this.slotStackLimit;
    }

    public CompoundTag serializeNBT() {
        ListTag nbtTagList = new ListTag();
        for (int slotIndex = 0; slotIndex < this.stacks.size(); ++slotIndex) {
            ItemStack slotStack = (ItemStack)this.stacks.get(slotIndex);
            if (slotStack.m_41619_()) continue;
            int realCount = Math.min(this.slotStackLimit, slotStack.m_41613_());
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128405_("Slot", slotIndex);
            slotStack.m_41739_(itemTag);
            itemTag.m_128405_("ExtendedCount", realCount);
            nbtTagList.add((Object)itemTag);
        }
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("Items", (Tag)nbtTagList);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        ListTag tagList = nbt.m_128437_("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTag = tagList.m_128728_(i);
            int slotIdex = itemTag.m_128451_("Slot");
            if (0 > slotIdex || this.stacks.size() <= slotIdex) continue;
            ItemStack itemStack = ItemStack.m_41712_((CompoundTag)itemTag);
            itemStack.m_41764_(itemTag.m_128451_("ExtendedCount"));
            this.stacks.set(slotIdex, (Object)itemStack);
        }
        this.onLoad();
    }
}

