/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.gui.updater;

import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.jar.installer.MarkdownFormatter;
import com.seibel.distanthorizons.core.jar.installer.ModrinthGetter;
import com.seibel.distanthorizons.core.wrapperInterfaces.IVersionConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.gui.DhScreen;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.gui.GuiHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ChangelogScreen
extends DhScreen {
    private Screen parent;
    private String versionID;
    private List<String> changelog;
    private TextArea changelogArea;
    public boolean usable = false;

    public ChangelogScreen(Screen parent) {
        this(parent, null);
        if (!ModrinthGetter.initted) {
            ModrinthGetter.init();
        }
        if (!ModrinthGetter.initted) {
            return;
        }
        if (!ModrinthGetter.mcVersions.contains(SingletonInjector.INSTANCE.get(IVersionConstants.class).getMinecraftVersion())) {
            return;
        }
        String versionID = ModrinthGetter.getLatestIDForVersion(SingletonInjector.INSTANCE.get(IVersionConstants.class).getMinecraftVersion());
        if (versionID == null) {
            return;
        }
        try {
            this.setupChangelog(versionID);
            this.usable = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ChangelogScreen(Screen parent, String versionID) {
        super((Component)GuiHelper.Translatable("distanthorizons.updater.title", new Object[0]));
        this.parent = parent;
        this.versionID = versionID;
        if (versionID == null) {
            return;
        }
        try {
            this.setupChangelog(versionID);
            this.usable = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setupChangelog(String versionID) {
        String[] unwrappedChangelog;
        this.changelog = new ArrayList<String>();
        this.changelog.add("\u00a7lChangelog for " + ModrinthGetter.releaseNames.get(versionID) + "\u00a7r");
        this.changelog.add("");
        this.changelog.add("");
        String changelog = ModrinthGetter.changeLogs.get(versionID);
        if (changelog == null) {
            changelog = "";
        }
        for (String str : unwrappedChangelog = new MarkdownFormatter.MinecraftFormat().convertTo(changelog).split("\\n")) {
            this.changelog.addAll(MarkdownFormatter.splitString(str, 75));
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        if (!this.usable) {
            return;
        }
        this.addBtn(GuiHelper.MakeBtn((Component)GuiHelper.Translatable("distanthorizons.general.back", new Object[0]), 5, this.f_96544_ - 25, 100, 20, btn -> this.m_7379_()));
        this.changelogArea = new TextArea(this.f_96541_, this.f_96543_ * 2, this.f_96544_, 32, 32, 10);
        for (int i = 0; i < this.changelog.size(); ++i) {
            this.changelogArea.addButton((Component)GuiHelper.TextOrLiteral(this.changelog.get(i)));
        }
    }

    public void m_88315_(GuiGraphics matrices, int mouseX, int mouseY, float delta) {
        double scrollAmount;
        this.m_280273_(matrices);
        if (!this.usable) {
            return;
        }
        this.changelogArea.f_93396_ = scrollAmount = (double)mouseY / (double)this.f_96544_ * 1.1 * (double)this.changelogArea.m_93518_();
        super.m_88315_(matrices, mouseX, mouseY, delta);
        this.changelogArea.m_88315_(matrices, mouseX, mouseY, delta);
        this.DhDrawCenteredString(matrices, this.f_96547_, this.f_96539_, this.f_96543_ / 2, 15, 0xFFFFFF);
    }

    public void m_7379_() {
        Objects.requireNonNull(this.f_96541_).m_91152_(this.parent);
    }

    public static class TextArea
    extends ContainerObjectSelectionList<ButtonEntry> {
        Font textRenderer;

        public TextArea(Minecraft minecraftClient, int canvasWidth, int canvasHeight, int topMargin, int botMargin, int itemSpacing) {
            super(minecraftClient, canvasWidth, canvasHeight, topMargin, canvasHeight - botMargin, itemSpacing);
            this.f_93394_ = false;
            this.textRenderer = minecraftClient.f_91062_;
        }

        public void addButton(Component text) {
            this.m_7085_((AbstractSelectionList.Entry)ButtonEntry.create(text));
        }

        public int m_5759_() {
            return 10000;
        }
    }

    public static class ButtonEntry
    extends ContainerObjectSelectionList.Entry<ButtonEntry> {
        private static final Font textRenderer = Minecraft.m_91087_().f_91062_;
        private final Component text;
        private final List<AbstractWidget> children = new ArrayList<AbstractWidget>();

        private ButtonEntry(Component text) {
            this.text = text;
        }

        public static ButtonEntry create(Component text) {
            return new ButtonEntry(text);
        }

        public void m_6311_(GuiGraphics matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            matrices.m_280430_(textRenderer, this.text, 12, y + 5, 0xFFFFFF);
        }

        public List<? extends GuiEventListener> m_6702_() {
            return this.children;
        }

        public List<? extends NarratableEntry> m_142437_() {
            return this.children;
        }
    }
}

