/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration;

import com.google.common.collect.ImmutableMap;
import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiDistantGeneratorMode;
import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiWorldGenerationStep;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.transformers.FullDataToRenderDataTransformer;
import com.seibel.distanthorizons.core.generation.DhLightingEngine;
import com.seibel.distanthorizons.core.level.IDhServerLevel;
import com.seibel.distanthorizons.core.logging.ConfigBasedLogger;
import com.seibel.distanthorizons.core.logging.ConfigBasedSpamLogger;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.gridList.ArrayGridList;
import com.seibel.distanthorizons.core.util.objects.EventTimer;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.ChunkLightStorage;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.worldGeneration.AbstractBatchGenerationEnvironmentWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.DependencySetupDoneCheck;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.world.ServerLevelWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.GenerationEvent;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.GlobalParameters;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.Rolling;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.mimicObject.ChunkLoader;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.mimicObject.DhLitWorldGenRegion;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.mimicObject.DummyLightEngine;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.mimicObject.LightGetterAdaptor;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.mimicObject.RegionFileStorageExternalCache;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.step.StepBiomes;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.step.StepFeatures;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.step.StepNoise;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.step.StepStructureReference;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.step.StepStructureStart;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.step.StepSurface;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2839;
import net.minecraft.class_2843;
import net.minecraft.class_2867;
import net.minecraft.class_2891;
import net.minecraft.class_2897;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3754;
import net.minecraft.class_4538;
import net.minecraft.class_4698;
import net.minecraft.class_5281;
import net.minecraft.class_5539;
import net.minecraft.class_7924;
import org.apache.logging.log4j.LogManager;

public final class BatchGenerationEnvironment
extends AbstractBatchGenerationEnvironmentWrapper {
    public static final ConfigBasedSpamLogger PREF_LOGGER = new ConfigBasedSpamLogger(LogManager.getLogger((String)"LodWorldGen"), () -> Config.Client.Advanced.Logging.logWorldGenPerformance.get(), 1);
    public static final ConfigBasedLogger EVENT_LOGGER = new ConfigBasedLogger(LogManager.getLogger((String)"LodWorldGen"), () -> Config.Client.Advanced.Logging.logWorldGenEvent.get());
    public static final ConfigBasedLogger LOAD_LOGGER = new ConfigBasedLogger(LogManager.getLogger((String)"LodWorldGen"), () -> Config.Client.Advanced.Logging.logWorldGenLoadEvent.get());
    private final IDhServerLevel serverlevel;
    public final LinkedBlockingQueue<GenerationEvent> generationEventList = new LinkedBlockingQueue();
    public final GlobalParameters params;
    public final StepStructureStart stepStructureStart = new StepStructureStart(this);
    public final StepStructureReference stepStructureReference = new StepStructureReference(this);
    public final StepBiomes stepBiomes = new StepBiomes(this);
    public final StepNoise stepNoise = new StepNoise(this);
    public final StepSurface stepSurface = new StepSurface(this);
    public final StepFeatures stepFeatures = new StepFeatures(this);
    public boolean unsafeThreadingRecorded = false;
    public static final long EXCEPTION_TIMER_RESET_TIME = TimeUnit.NANOSECONDS.convert(1L, TimeUnit.SECONDS);
    public static final int EXCEPTION_COUNTER_TRIGGER = 20;
    public static final int RANGE_TO_RANGE_EMPTY_EXTENSION = 1;
    public int unknownExceptionCount = 0;
    public long lastExceptionTriggerTime = 0L;
    private AtomicReference<RegionFileStorageExternalCache> regionFileStorageCacheRef = new AtomicReference();
    public static ThreadLocal<Boolean> isDistantGeneratorThread = new ThreadLocal();
    public static ThreadLocal<Object> onDistantGenerationMixinData = new ThreadLocal();
    public static final ImmutableMap<EDhApiWorldGenerationStep, Integer> WORLD_GEN_CHUNK_BORDER_NEEDED_BY_GEN_STEP;
    public static final int MAX_WORLD_GEN_CHUNK_BORDER_NEEDED;

    public RegionFileStorageExternalCache getOrCreateRegionFileCache(class_2867 storage) {
        RegionFileStorageExternalCache cache = this.regionFileStorageCacheRef.get();
        if (cache == null && !this.regionFileStorageCacheRef.compareAndSet(null, cache = new RegionFileStorageExternalCache(storage))) {
            cache = this.regionFileStorageCacheRef.get();
        }
        return cache;
    }

    public static boolean isCurrentThreadDistantGeneratorThread() {
        return isDistantGeneratorThread.get() != null;
    }

    public static void putDistantGenerationMixinData(Object data) {
        LodUtil.assertTrue(BatchGenerationEnvironment.isCurrentThreadDistantGeneratorThread());
        onDistantGenerationMixinData.set(data);
    }

    public static Object getDistantGenerationMixinData() {
        LodUtil.assertTrue(BatchGenerationEnvironment.isCurrentThreadDistantGeneratorThread());
        return onDistantGenerationMixinData.get();
    }

    public static void clearDistantGenerationMixinData() {
        LodUtil.assertTrue(BatchGenerationEnvironment.isCurrentThreadDistantGeneratorThread());
        onDistantGenerationMixinData.remove();
    }

    public BatchGenerationEnvironment(IDhServerLevel serverlevel) {
        super(serverlevel);
        this.serverlevel = serverlevel;
        EVENT_LOGGER.info("================WORLD_GEN_STEP_INITING=============", new Object[0]);
        serverlevel.getServerLevelWrapper().getDimensionType();
        class_2794 generator = ((ServerLevelWrapper)serverlevel.getServerLevelWrapper()).getLevel().method_14178().method_12129();
        if (!(generator instanceof class_3754 || generator instanceof class_2891 || generator instanceof class_2897)) {
            if (generator.getClass().toString().equals("class com.terraforged.mod.chunk.TFChunkGenerator")) {
                EVENT_LOGGER.info("TerraForge Chunk Generator detected: [" + String.valueOf(generator.getClass()) + "], Distant Generation will try its best to support it.", new Object[0]);
                EVENT_LOGGER.info("If it does crash, turn Distant Generation off or set it to to [" + String.valueOf((Object)EDhApiDistantGeneratorMode.PRE_EXISTING_ONLY) + "].", new Object[0]);
            } else if (generator.getClass().toString().equals("class net.dries007.tfc.world.TFCChunkGenerator")) {
                EVENT_LOGGER.info("TerraFirmaCraft Chunk Generator detected: [" + String.valueOf(generator.getClass()) + "], Distant Generation will try its best to support it.", new Object[0]);
                EVENT_LOGGER.info("If it does crash, turn Distant Generation off or set it to to [" + String.valueOf((Object)EDhApiDistantGeneratorMode.PRE_EXISTING_ONLY) + "].", new Object[0]);
            } else {
                EVENT_LOGGER.warn("Unknown Chunk Generator detected: [" + String.valueOf(generator.getClass()) + "], Distant Generation May Fail!", new Object[0]);
                EVENT_LOGGER.warn("If it does crash, disable Distant Generation or set the Generation Mode to [" + String.valueOf((Object)EDhApiDistantGeneratorMode.PRE_EXISTING_ONLY) + "].", new Object[0]);
            }
        }
        this.params = new GlobalParameters(serverlevel);
    }

    public <T> T joinSync(CompletableFuture<T> future) {
        if (!this.unsafeThreadingRecorded && !future.isDone()) {
            EVENT_LOGGER.error("Unsafe MultiThreading in Chunk Generator: ", new RuntimeException("Concurrent future"));
            EVENT_LOGGER.error("To increase stability, it is recommended to set world generation threads count to 1.", new Object[0]);
            this.unsafeThreadingRecorded = true;
        }
        return future.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAllFutures() {
        if (this.unknownExceptionCount > 0 && System.nanoTime() - this.lastExceptionTriggerTime >= EXCEPTION_TIMER_RESET_TIME) {
            this.unknownExceptionCount = 0;
        }
        Iterator<GenerationEvent> iter = this.generationEventList.iterator();
        while (iter.hasNext()) {
            GenerationEvent event = iter.next();
            if (event.future.isDone()) {
                if (event.future.isCompletedExceptionally() && !event.future.isCancelled()) {
                    try {
                        event.future.get();
                        LodUtil.assertNotReach();
                    }
                    catch (Exception e) {
                        ++this.unknownExceptionCount;
                        this.lastExceptionTriggerTime = System.nanoTime();
                        EVENT_LOGGER.error("Batching World Generator event [" + String.valueOf(event) + "] threw an exception: " + e.getMessage(), e);
                    }
                }
                iter.remove();
                continue;
            }
            if (!event.hasTimeout(Config.Client.Advanced.WorldGenerator.worldGenerationTimeoutLengthInSeconds.get(), TimeUnit.SECONDS)) continue;
            EVENT_LOGGER.warn("Batching World Generator: [" + String.valueOf(event) + "] timed out and terminated after [" + String.valueOf(Config.Client.Advanced.WorldGenerator.worldGenerationTimeoutLengthInSeconds.get()) + "] seconds. \nYour computer might be overloaded or your world gen mods might be causing world gen to take longer than expected. \nEither increase DH's world gen timeout or reduce your computer's CPU load.", new Object[0]);
            EVENT_LOGGER.debug("Dump PrefEvent: " + String.valueOf(event.timer), new Object[0]);
            try {
                if (event.terminate()) continue;
                EVENT_LOGGER.error("Failed to terminate the stuck generation event!", new Object[0]);
            }
            finally {
                iter.remove();
            }
        }
        if (this.unknownExceptionCount > 20) {
            EVENT_LOGGER.error("Too many exceptions in Batching World Generator! Disabling the generator.", new Object[0]);
            this.unknownExceptionCount = 0;
            Config.Client.Advanced.WorldGenerator.enableDistantGeneration.set(false);
        }
    }

    public void generateLodFromList(GenerationEvent genEvent) throws InterruptedException {
        EVENT_LOGGER.debug("Lod Generate Event: " + String.valueOf(genEvent.minPos), new Object[0]);
        LodUtil.assertTrue(genEvent.size % 2 == 0, "Generation events are expected to be an evan number of chunks wide.");
        int borderSize = MAX_WORLD_GEN_CHUNK_BORDER_NEEDED;
        int refSize = genEvent.size - 1 + borderSize * 2;
        int refPosX = genEvent.minPos.getX() - borderSize;
        int refPosZ = genEvent.minPos.getZ() - borderSize;
        LightGetterAdaptor lightGetterAdaptor = new LightGetterAdaptor((class_1922)this.params.level);
        DummyLightEngine dummyLightEngine = new DummyLightEngine(lightGetterAdaptor);
        HashMap chunkSkyLightingByDhPos = new HashMap();
        HashMap chunkBlockLightingByDhPos = new HashMap();
        HashMap generatedChunkByDhPos = new HashMap();
        HashMap chunkWrappersByDhPos = new HashMap();
        for (int xOffset = 0; xOffset < 2; ++xOffset) {
            int xOffsetFinal = xOffset;
            for (int zOffset = 0; zOffset < 2; ++zOffset) {
                int zOffsetFinal = zOffset;
                int radius = refSize / 2;
                int centerX = refPosX + radius + xOffset;
                int centerZ = refPosZ + radius + zOffset;
                ArrayGridList<class_2791> regionChunks = new ArrayGridList<class_2791>(refSize, (x, z) -> this.generateEmptyChunk(x + refPosX + xOffsetFinal, z + refPosZ + zOffsetFinal, chunkSkyLightingByDhPos, chunkBlockLightingByDhPos, generatedChunkByDhPos));
                class_2791 centerChunk = regionChunks.stream().filter(chunk -> chunk.method_12004().field_9181 == centerX && chunk.method_12004().field_9180 == centerZ).findFirst().get();
                genEvent.refreshTimeout();
                DhLitWorldGenRegion region = new DhLitWorldGenRegion(centerX, centerZ, centerChunk, this.params.level, dummyLightEngine, regionChunks, class_2806.field_16423, radius, (x, z) -> this.generateEmptyChunk(x, z, chunkSkyLightingByDhPos, chunkBlockLightingByDhPos, generatedChunkByDhPos));
                lightGetterAdaptor.setRegion(region);
                genEvent.threadedParam.makeStructFeat((class_5281)region, this.params);
                ArrayGridList<ChunkWrapper> chunkWrapperList = new ArrayGridList<ChunkWrapper>(regionChunks.gridSize);
                regionChunks.forEachPos((relX, relZ) -> {
                    DhChunkPos chunkPos = new DhChunkPos(relX + xOffsetFinal, relZ + zOffsetFinal);
                    class_2791 chunk = (class_2791)regionChunks.get((int)relX, (int)relZ);
                    if (chunkWrappersByDhPos.containsKey(chunkPos)) {
                        chunkWrapperList.set((int)relX, (int)relZ, (ChunkWrapper)chunkWrappersByDhPos.get(chunkPos));
                    } else if (chunk != null) {
                        ChunkWrapper chunkWrapper = new ChunkWrapper(chunk, (class_4538)region, this.serverlevel.getLevelWrapper());
                        chunkWrapperList.set((int)relX, (int)relZ, chunkWrapper);
                        if (chunkBlockLightingByDhPos.containsKey(chunkWrapper.getChunkPos())) {
                            chunkWrapper.setBlockLightStorage((ChunkLightStorage)chunkBlockLightingByDhPos.get(chunkWrapper.getChunkPos()));
                            chunkWrapper.setSkyLightStorage((ChunkLightStorage)chunkSkyLightingByDhPos.get(chunkWrapper.getChunkPos()));
                            chunkWrapper.setUseDhLighting(true);
                            chunkWrapper.setIsDhLightCorrect(true);
                        }
                        chunkWrappersByDhPos.put(chunkPos, chunkWrapper);
                    } else {
                        LodUtil.assertNotReach("Programmer Error: No chunk found in grid list, position offset is likely wrong.");
                    }
                });
                this.generateDirect(genEvent, chunkWrapperList, borderSize, genEvent.targetGenerationStep, region);
                genEvent.timer.nextEvent("cleanup");
            }
        }
        for (DhChunkPos dhChunkPos : chunkWrappersByDhPos.keySet()) {
            ChunkWrapper wrappedChunk = (ChunkWrapper)chunkWrappersByDhPos.get(dhChunkPos);
            class_2791 target = wrappedChunk.getChunk();
            if (target instanceof class_2818) {
                ((class_2818)target).field_12855 = true;
            }
            if (!wrappedChunk.isLightCorrect()) {
                throw new RuntimeException("The generated chunk somehow has isLightCorrect() returning false");
            }
            boolean isFull = ChunkWrapper.getStatus(target) == class_2806.field_12803 || target instanceof class_2818;
            boolean isPartial = target.method_39297();
            if (isFull) {
                LOAD_LOGGER.debug("Detected full existing chunk at {}", target.method_12004());
                genEvent.resultConsumer.accept(wrappedChunk);
                continue;
            }
            if (isPartial) {
                LOAD_LOGGER.debug("Detected old existing chunk at {}", target.method_12004());
                genEvent.resultConsumer.accept(wrappedChunk);
                continue;
            }
            if (ChunkWrapper.getStatus(target) == class_2806.field_12798) {
                genEvent.resultConsumer.accept(wrappedChunk);
                continue;
            }
            genEvent.resultConsumer.accept(wrappedChunk);
        }
        genEvent.timer.complete();
        genEvent.refreshTimeout();
        if (PREF_LOGGER.canMaybeLog()) {
            genEvent.threadedParam.perf.recordEvent(genEvent.timer);
            PREF_LOGGER.debugInc("{}", genEvent.timer);
        }
    }

    private class_2791 generateEmptyChunk(int x, int z, HashMap<DhChunkPos, ChunkLightStorage> chunkSkyLightingByDhPos, HashMap<DhChunkPos, ChunkLightStorage> chunkBlockLightingByDhPos, HashMap<DhChunkPos, class_2791> generatedChunkByDhPos) {
        class_1923 chunkPos = new class_1923(x, z);
        DhChunkPos dhChunkPos = new DhChunkPos(x, z);
        if (generatedChunkByDhPos.containsKey(dhChunkPos)) {
            return generatedChunkByDhPos.get(dhChunkPos);
        }
        class_2791 newChunk = null;
        try {
            ChunkLoader.CombinedChunkLightStorage combinedLights;
            class_2487 chunkData = this.getChunkNbtData(chunkPos);
            newChunk = this.loadOrMakeChunk(chunkPos, chunkData);
            if (Config.Client.Advanced.LodBuilding.pullLightingForPregeneratedChunks.get().booleanValue() && (combinedLights = ChunkLoader.readLight(newChunk, chunkData)) != null) {
                chunkSkyLightingByDhPos.put(dhChunkPos, combinedLights.skyLightStorage);
                chunkBlockLightingByDhPos.put(dhChunkPos, combinedLights.blockLightStorage);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (newChunk == null) {
            newChunk = new class_2839(chunkPos, class_2843.field_12950, (class_5539)this.params.level, this.params.biomes, null);
        }
        generatedChunkByDhPos.put(dhChunkPos, newChunk);
        return newChunk;
    }

    private class_2487 getChunkNbtData(class_1923 chunkPos) {
        class_3218 level = this.params.level;
        class_2487 chunkData = null;
        try {
            class_4698 ioWorker = level.method_14178().field_17254.field_21494;
            int maxGetTimeInSec = Config.Client.Advanced.WorldGenerator.worldGenerationTimeoutLengthInSeconds.get();
            CompletableFuture future = ioWorker.method_31738(chunkPos);
            try {
                Optional data = (Optional)future.get(maxGetTimeInSec, TimeUnit.SECONDS);
                if (data.isPresent()) {
                    chunkData = (class_2487)data.get();
                }
            }
            catch (Exception e) {
                LOAD_LOGGER.warn("Unable to get chunk at pos [" + String.valueOf(chunkPos) + "] after [" + maxGetTimeInSec + "] milliseconds.", e);
                future.cancel(true);
            }
        }
        catch (Exception e) {
            LOAD_LOGGER.error("DistantHorizons: Couldn't load or make chunk " + String.valueOf(chunkPos) + ". Error: " + e.getMessage(), e);
        }
        return chunkData;
    }

    private class_2791 loadOrMakeChunk(class_1923 chunkPos, class_2487 chunkData) {
        class_3218 level = this.params.level;
        if (chunkData == null) {
            return BatchGenerationEnvironment.CreateEmptyChunk(level, chunkPos);
        }
        try {
            LOAD_LOGGER.debug("DistantHorizons: Loading chunk [" + String.valueOf(chunkPos) + "] from disk.", new Object[0]);
            return ChunkLoader.read((class_5281)level, chunkPos, chunkData);
        }
        catch (Exception e) {
            LOAD_LOGGER.error("DistantHorizons: couldn't load or make chunk at [" + String.valueOf(chunkPos) + "].Please try optimizing your world to fix this issue. \nWorld optimization can be done from the singleplayer world selection screen.\nError: [" + e.getMessage() + "].", e);
            return BatchGenerationEnvironment.CreateEmptyChunk(level, chunkPos);
        }
    }

    private static class_2839 CreateEmptyChunk(class_3218 level, class_1923 chunkPos) {
        return new class_2839(chunkPos, class_2843.field_12950, (class_5539)level, level.method_30349().method_30530(class_7924.field_41236), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateDirect(GenerationEvent genEvent, ArrayGridList<ChunkWrapper> chunksToGenerate, int border, EDhApiWorldGenerationStep step, DhLitWorldGenRegion region) throws InterruptedException {
        int i;
        block34: {
            int i2;
            block33: {
                int i3;
                block32: {
                    int i4;
                    block31: {
                        int i5;
                        block30: {
                            int i6;
                            block29: {
                                int i7;
                                block28: {
                                    int i8;
                                    if (Thread.interrupted()) {
                                        return;
                                    }
                                    chunksToGenerate.forEach(chunkWrapper -> {
                                        class_2791 chunk = chunkWrapper.getChunk();
                                        if (chunk instanceof class_2839) {
                                            class_2839 protoChunk = (class_2839)chunk;
                                            protoChunk.method_17032(region.method_22336());
                                        }
                                    });
                                    if (step != EDhApiWorldGenerationStep.EMPTY) break block28;
                                    genEvent.timer.nextEvent("light");
                                    int maxSkyLight = this.serverlevel.getServerLevelWrapper().hasSkyLight() ? 15 : 0;
                                    ArrayList<IChunkWrapper> iChunkWrapperList = new ArrayList<IChunkWrapper>();
                                    for (i8 = 0; i8 < chunksToGenerate.size(); ++i8) {
                                        ChunkWrapper chunkWrapper2 = (ChunkWrapper)chunksToGenerate.get(i8);
                                        if (chunkWrapper2.getStatus() == class_2806.field_12798) continue;
                                        iChunkWrapperList.add(chunkWrapper2);
                                    }
                                    for (i8 = 0; i8 < iChunkWrapperList.size(); ++i8) {
                                        IChunkWrapper centerChunk = (IChunkWrapper)iChunkWrapperList.get(i8);
                                        if (centerChunk == null) continue;
                                        BatchGenerationEnvironment.throwIfThreadInterrupted();
                                        class_2902.method_16684((class_2791)((ChunkWrapper)centerChunk).getChunk(), (Set)class_2806.field_12795.method_12160());
                                        if (centerChunk.isLightCorrect()) continue;
                                        DhLightingEngine.INSTANCE.lightChunk(centerChunk, iChunkWrapperList, maxSkyLight);
                                    }
                                    genEvent.refreshTimeout();
                                    return;
                                }
                                genEvent.timer.nextEvent("structStart");
                                BatchGenerationEnvironment.throwIfThreadInterrupted();
                                this.stepStructureStart.generateGroup(genEvent.threadedParam, region, BatchGenerationEnvironment.GetCutoutFrom(chunksToGenerate, EDhApiWorldGenerationStep.STRUCTURE_START));
                                genEvent.refreshTimeout();
                                if (step != EDhApiWorldGenerationStep.STRUCTURE_START) break block29;
                                genEvent.timer.nextEvent("light");
                                int maxSkyLight = this.serverlevel.getServerLevelWrapper().hasSkyLight() ? 15 : 0;
                                ArrayList<IChunkWrapper> iChunkWrapperList = new ArrayList<IChunkWrapper>();
                                for (i7 = 0; i7 < chunksToGenerate.size(); ++i7) {
                                    ChunkWrapper chunkWrapper3 = (ChunkWrapper)chunksToGenerate.get(i7);
                                    if (chunkWrapper3.getStatus() == class_2806.field_12798) continue;
                                    iChunkWrapperList.add(chunkWrapper3);
                                }
                                for (i7 = 0; i7 < iChunkWrapperList.size(); ++i7) {
                                    IChunkWrapper centerChunk = (IChunkWrapper)iChunkWrapperList.get(i7);
                                    if (centerChunk == null) continue;
                                    BatchGenerationEnvironment.throwIfThreadInterrupted();
                                    class_2902.method_16684((class_2791)((ChunkWrapper)centerChunk).getChunk(), (Set)class_2806.field_12795.method_12160());
                                    if (centerChunk.isLightCorrect()) continue;
                                    DhLightingEngine.INSTANCE.lightChunk(centerChunk, iChunkWrapperList, maxSkyLight);
                                }
                                genEvent.refreshTimeout();
                                return;
                            }
                            genEvent.timer.nextEvent("structRef");
                            BatchGenerationEnvironment.throwIfThreadInterrupted();
                            this.stepStructureReference.generateGroup(genEvent.threadedParam, region, BatchGenerationEnvironment.GetCutoutFrom(chunksToGenerate, EDhApiWorldGenerationStep.STRUCTURE_REFERENCE));
                            genEvent.refreshTimeout();
                            if (step != EDhApiWorldGenerationStep.STRUCTURE_REFERENCE) break block30;
                            genEvent.timer.nextEvent("light");
                            int maxSkyLight = this.serverlevel.getServerLevelWrapper().hasSkyLight() ? 15 : 0;
                            ArrayList<IChunkWrapper> iChunkWrapperList = new ArrayList<IChunkWrapper>();
                            for (i6 = 0; i6 < chunksToGenerate.size(); ++i6) {
                                ChunkWrapper chunkWrapper4 = (ChunkWrapper)chunksToGenerate.get(i6);
                                if (chunkWrapper4.getStatus() == class_2806.field_12798) continue;
                                iChunkWrapperList.add(chunkWrapper4);
                            }
                            for (i6 = 0; i6 < iChunkWrapperList.size(); ++i6) {
                                IChunkWrapper centerChunk = (IChunkWrapper)iChunkWrapperList.get(i6);
                                if (centerChunk == null) continue;
                                BatchGenerationEnvironment.throwIfThreadInterrupted();
                                class_2902.method_16684((class_2791)((ChunkWrapper)centerChunk).getChunk(), (Set)class_2806.field_12795.method_12160());
                                if (centerChunk.isLightCorrect()) continue;
                                DhLightingEngine.INSTANCE.lightChunk(centerChunk, iChunkWrapperList, maxSkyLight);
                            }
                            genEvent.refreshTimeout();
                            return;
                        }
                        genEvent.timer.nextEvent("biome");
                        BatchGenerationEnvironment.throwIfThreadInterrupted();
                        this.stepBiomes.generateGroup(genEvent.threadedParam, region, BatchGenerationEnvironment.GetCutoutFrom(chunksToGenerate, EDhApiWorldGenerationStep.BIOMES));
                        genEvent.refreshTimeout();
                        if (step != EDhApiWorldGenerationStep.BIOMES) break block31;
                        genEvent.timer.nextEvent("light");
                        int maxSkyLight = this.serverlevel.getServerLevelWrapper().hasSkyLight() ? 15 : 0;
                        ArrayList<IChunkWrapper> iChunkWrapperList = new ArrayList<IChunkWrapper>();
                        for (i5 = 0; i5 < chunksToGenerate.size(); ++i5) {
                            ChunkWrapper chunkWrapper5 = (ChunkWrapper)chunksToGenerate.get(i5);
                            if (chunkWrapper5.getStatus() == class_2806.field_12798) continue;
                            iChunkWrapperList.add(chunkWrapper5);
                        }
                        for (i5 = 0; i5 < iChunkWrapperList.size(); ++i5) {
                            IChunkWrapper centerChunk = (IChunkWrapper)iChunkWrapperList.get(i5);
                            if (centerChunk == null) continue;
                            BatchGenerationEnvironment.throwIfThreadInterrupted();
                            class_2902.method_16684((class_2791)((ChunkWrapper)centerChunk).getChunk(), (Set)class_2806.field_12795.method_12160());
                            if (centerChunk.isLightCorrect()) continue;
                            DhLightingEngine.INSTANCE.lightChunk(centerChunk, iChunkWrapperList, maxSkyLight);
                        }
                        genEvent.refreshTimeout();
                        return;
                    }
                    genEvent.timer.nextEvent("noise");
                    BatchGenerationEnvironment.throwIfThreadInterrupted();
                    this.stepNoise.generateGroup(genEvent.threadedParam, region, BatchGenerationEnvironment.GetCutoutFrom(chunksToGenerate, EDhApiWorldGenerationStep.NOISE));
                    genEvent.refreshTimeout();
                    if (step != EDhApiWorldGenerationStep.NOISE) break block32;
                    genEvent.timer.nextEvent("light");
                    int maxSkyLight = this.serverlevel.getServerLevelWrapper().hasSkyLight() ? 15 : 0;
                    ArrayList<IChunkWrapper> iChunkWrapperList = new ArrayList<IChunkWrapper>();
                    for (i4 = 0; i4 < chunksToGenerate.size(); ++i4) {
                        ChunkWrapper chunkWrapper6 = (ChunkWrapper)chunksToGenerate.get(i4);
                        if (chunkWrapper6.getStatus() == class_2806.field_12798) continue;
                        iChunkWrapperList.add(chunkWrapper6);
                    }
                    for (i4 = 0; i4 < iChunkWrapperList.size(); ++i4) {
                        IChunkWrapper centerChunk = (IChunkWrapper)iChunkWrapperList.get(i4);
                        if (centerChunk == null) continue;
                        BatchGenerationEnvironment.throwIfThreadInterrupted();
                        class_2902.method_16684((class_2791)((ChunkWrapper)centerChunk).getChunk(), (Set)class_2806.field_12795.method_12160());
                        if (centerChunk.isLightCorrect()) continue;
                        DhLightingEngine.INSTANCE.lightChunk(centerChunk, iChunkWrapperList, maxSkyLight);
                    }
                    genEvent.refreshTimeout();
                    return;
                }
                genEvent.timer.nextEvent("surface");
                BatchGenerationEnvironment.throwIfThreadInterrupted();
                this.stepSurface.generateGroup(genEvent.threadedParam, region, BatchGenerationEnvironment.GetCutoutFrom(chunksToGenerate, EDhApiWorldGenerationStep.SURFACE));
                genEvent.refreshTimeout();
                if (step != EDhApiWorldGenerationStep.SURFACE) break block33;
                genEvent.timer.nextEvent("light");
                int maxSkyLight = this.serverlevel.getServerLevelWrapper().hasSkyLight() ? 15 : 0;
                ArrayList<IChunkWrapper> iChunkWrapperList = new ArrayList<IChunkWrapper>();
                for (i3 = 0; i3 < chunksToGenerate.size(); ++i3) {
                    ChunkWrapper chunkWrapper7 = (ChunkWrapper)chunksToGenerate.get(i3);
                    if (chunkWrapper7.getStatus() == class_2806.field_12798) continue;
                    iChunkWrapperList.add(chunkWrapper7);
                }
                for (i3 = 0; i3 < iChunkWrapperList.size(); ++i3) {
                    IChunkWrapper centerChunk = (IChunkWrapper)iChunkWrapperList.get(i3);
                    if (centerChunk == null) continue;
                    BatchGenerationEnvironment.throwIfThreadInterrupted();
                    class_2902.method_16684((class_2791)((ChunkWrapper)centerChunk).getChunk(), (Set)class_2806.field_12795.method_12160());
                    if (centerChunk.isLightCorrect()) continue;
                    DhLightingEngine.INSTANCE.lightChunk(centerChunk, iChunkWrapperList, maxSkyLight);
                }
                genEvent.refreshTimeout();
                return;
            }
            genEvent.timer.nextEvent("carver");
            BatchGenerationEnvironment.throwIfThreadInterrupted();
            if (step != EDhApiWorldGenerationStep.CARVERS) break block34;
            genEvent.timer.nextEvent("light");
            int maxSkyLight = this.serverlevel.getServerLevelWrapper().hasSkyLight() ? 15 : 0;
            ArrayList<IChunkWrapper> iChunkWrapperList = new ArrayList<IChunkWrapper>();
            for (i2 = 0; i2 < chunksToGenerate.size(); ++i2) {
                ChunkWrapper chunkWrapper8 = (ChunkWrapper)chunksToGenerate.get(i2);
                if (chunkWrapper8.getStatus() == class_2806.field_12798) continue;
                iChunkWrapperList.add(chunkWrapper8);
            }
            for (i2 = 0; i2 < iChunkWrapperList.size(); ++i2) {
                IChunkWrapper centerChunk = (IChunkWrapper)iChunkWrapperList.get(i2);
                if (centerChunk == null) continue;
                BatchGenerationEnvironment.throwIfThreadInterrupted();
                class_2902.method_16684((class_2791)((ChunkWrapper)centerChunk).getChunk(), (Set)class_2806.field_12795.method_12160());
                if (centerChunk.isLightCorrect()) continue;
                DhLightingEngine.INSTANCE.lightChunk(centerChunk, iChunkWrapperList, maxSkyLight);
            }
            genEvent.refreshTimeout();
            return;
        }
        try {
            genEvent.timer.nextEvent("feature");
            BatchGenerationEnvironment.throwIfThreadInterrupted();
            this.stepFeatures.generateGroup(genEvent.threadedParam, region, BatchGenerationEnvironment.GetCutoutFrom(chunksToGenerate, EDhApiWorldGenerationStep.FEATURES));
            genEvent.refreshTimeout();
            genEvent.timer.nextEvent("light");
        }
        catch (Throwable throwable) {
            int i9;
            genEvent.timer.nextEvent("light");
            int maxSkyLight = this.serverlevel.getServerLevelWrapper().hasSkyLight() ? 15 : 0;
            ArrayList<IChunkWrapper> iChunkWrapperList = new ArrayList<IChunkWrapper>();
            for (i9 = 0; i9 < chunksToGenerate.size(); ++i9) {
                ChunkWrapper chunkWrapper9 = (ChunkWrapper)chunksToGenerate.get(i9);
                if (chunkWrapper9.getStatus() == class_2806.field_12798) continue;
                iChunkWrapperList.add(chunkWrapper9);
            }
            for (i9 = 0; i9 < iChunkWrapperList.size(); ++i9) {
                IChunkWrapper centerChunk = (IChunkWrapper)iChunkWrapperList.get(i9);
                if (centerChunk == null) continue;
                BatchGenerationEnvironment.throwIfThreadInterrupted();
                class_2902.method_16684((class_2791)((ChunkWrapper)centerChunk).getChunk(), (Set)class_2806.field_12795.method_12160());
                if (centerChunk.isLightCorrect()) continue;
                DhLightingEngine.INSTANCE.lightChunk(centerChunk, iChunkWrapperList, maxSkyLight);
            }
            genEvent.refreshTimeout();
            throw throwable;
        }
        int maxSkyLight = this.serverlevel.getServerLevelWrapper().hasSkyLight() ? 15 : 0;
        ArrayList<IChunkWrapper> iChunkWrapperList = new ArrayList<IChunkWrapper>();
        for (i = 0; i < chunksToGenerate.size(); ++i) {
            ChunkWrapper chunkWrapper10 = (ChunkWrapper)chunksToGenerate.get(i);
            if (chunkWrapper10.getStatus() == class_2806.field_12798) continue;
            iChunkWrapperList.add(chunkWrapper10);
        }
        for (i = 0; i < iChunkWrapperList.size(); ++i) {
            IChunkWrapper centerChunk = (IChunkWrapper)iChunkWrapperList.get(i);
            if (centerChunk == null) continue;
            BatchGenerationEnvironment.throwIfThreadInterrupted();
            class_2902.method_16684((class_2791)((ChunkWrapper)centerChunk).getChunk(), (Set)class_2806.field_12795.method_12160());
            if (centerChunk.isLightCorrect()) continue;
            DhLightingEngine.INSTANCE.lightChunk(centerChunk, iChunkWrapperList, maxSkyLight);
        }
        genEvent.refreshTimeout();
    }

    private static <T> ArrayGridList<T> GetCutoutFrom(ArrayGridList<T> total, int border) {
        return new ArrayGridList<T>(total, border, total.gridSize - border);
    }

    private static <T> ArrayGridList<T> GetCutoutFrom(ArrayGridList<T> total, EDhApiWorldGenerationStep step) {
        return BatchGenerationEnvironment.GetCutoutFrom(total, 0);
    }

    @Override
    public int getEventCount() {
        return this.generationEventList.size();
    }

    @Override
    public void stop() {
        EVENT_LOGGER.info(BatchGenerationEnvironment.class.getSimpleName() + " shutting down...", new Object[0]);
        EVENT_LOGGER.info("Canceling in progress generation event futures...", new Object[0]);
        Iterator<GenerationEvent> iter = this.generationEventList.iterator();
        while (iter.hasNext()) {
            GenerationEvent event = iter.next();
            event.future.cancel(true);
            iter.remove();
        }
        RegionFileStorageExternalCache regionStorage = this.regionFileStorageCacheRef.get();
        if (regionStorage != null) {
            try {
                regionStorage.close();
            }
            catch (IOException e) {
                EVENT_LOGGER.error("Failed to close region file storage cache!", e);
            }
        }
        EVENT_LOGGER.info(BatchGenerationEnvironment.class.getSimpleName() + " shutdown complete.", new Object[0]);
    }

    @Override
    public CompletableFuture<Void> generateChunks(int minX, int minZ, int genSize, EDhApiWorldGenerationStep targetStep, ExecutorService worldGeneratorThreadPool, Consumer<IChunkWrapper> resultConsumer) {
        GenerationEvent genEvent = GenerationEvent.startEvent(new DhChunkPos(minX, minZ), genSize, this, targetStep, resultConsumer, worldGeneratorThreadPool);
        this.generationEventList.add(genEvent);
        return genEvent.future;
    }

    public static void throwIfThreadInterrupted() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException(FullDataToRenderDataTransformer.class.getSimpleName() + " task interrupted.");
        }
    }

    static {
        DependencySetupDoneCheck.getIsCurrentThreadDistantGeneratorThread = BatchGenerationEnvironment::isCurrentThreadDistantGeneratorThread;
        boolean isTerraFirmaCraft = false;
        try {
            Class.forName("net.dries007.tfc.world.TFCChunkGenerator");
            isTerraFirmaCraft = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        EVENT_LOGGER.info("DH TerraFirmaCraft detection: " + isTerraFirmaCraft, new Object[0]);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)EDhApiWorldGenerationStep.EMPTY, (Object)1);
        builder.put((Object)EDhApiWorldGenerationStep.STRUCTURE_START, (Object)0);
        builder.put((Object)EDhApiWorldGenerationStep.STRUCTURE_REFERENCE, (Object)0);
        builder.put((Object)EDhApiWorldGenerationStep.BIOMES, (Object)(isTerraFirmaCraft ? 1 : 0));
        builder.put((Object)EDhApiWorldGenerationStep.NOISE, (Object)(isTerraFirmaCraft ? 1 : 0));
        builder.put((Object)EDhApiWorldGenerationStep.SURFACE, (Object)0);
        builder.put((Object)EDhApiWorldGenerationStep.CARVERS, (Object)0);
        builder.put((Object)EDhApiWorldGenerationStep.LIQUID_CARVERS, (Object)0);
        builder.put((Object)EDhApiWorldGenerationStep.FEATURES, (Object)0);
        builder.put((Object)EDhApiWorldGenerationStep.LIGHT, (Object)0);
        WORLD_GEN_CHUNK_BORDER_NEEDED_BY_GEN_STEP = builder.build();
        MAX_WORLD_GEN_CHUNK_BORDER_NEEDED = 0;
    }

    @FunctionalInterface
    public static interface IEmptyChunkGeneratorFunc {
        public class_2791 generate(int var1, int var2);
    }

    public static class PerfCalculator {
        private static final String[] TIME_NAMES = new String[]{"total", "setup", "structStart", "structRef", "biome", "noise", "surface", "carver", "feature", "light", "cleanup"};
        public static final int SIZE = 50;
        ArrayList<Rolling> times = new ArrayList();

        public PerfCalculator() {
            for (int i = 0; i < 11; ++i) {
                this.times.add(new Rolling(50));
            }
        }

        public void recordEvent(EventTimer event) {
            for (EventTimer.Event e : event.events) {
                String name = e.name;
                int index = Arrays.asList(TIME_NAMES).indexOf(name);
                if (index == -1) continue;
                this.times.get(index).add(e.timeNs);
            }
            this.times.get(0).add(event.getTotalTimeNs());
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.times.size(); ++i) {
                if (this.times.get(i).getAverage() == 0.0) continue;
                sb.append(TIME_NAMES[i]).append(": ").append(this.times.get(i).getAverage()).append("\n");
            }
            return sb.toString();
        }
    }
}

